/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.plainJava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.utils.JavaAccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPointProvider;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class PlainJavaAccessPointProvider
implements IAccessPointProvider {
    public List createIntrinsicAccessPoint(IModelElement element) {
        List result = Collections.EMPTY_LIST;
        if (element instanceof IExtensibleElement) {
            String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
            className = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(className);
            String methodName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
            methodName = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(methodName);
            String constructorName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:constructorName");
            constructorName = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(constructorName);
            result = PlainJavaAccessPointProvider.getIntrinsicAccessPoints((IExtensibleElement)element, className, methodName, constructorName, null, null, false);
        }
        return result;
    }

    public static List getIntrinsicAccessPoints(IExtensibleElement element, String className, String methodName, String constructorName, DirectionType direction, String hint, boolean paramsOnly) {
        return PlainJavaAccessPointProvider.getIntrinsicAccessPoints(element, className, methodName, false, constructorName, direction, hint, paramsOnly);
    }

    public static List getIntrinsicAccessPoints(IExtensibleElement element, String fullClassName, String methodName, boolean usedForObjectCreation, String constructorName, DirectionType direction, String hint, boolean paramsOnly) {
        ArrayList accessPoints = new ArrayList();
        if (element != null) {
            TypeFinder finder;
            TypeInfo type;
            IModelElement ref = element instanceof ITypedElement ? ((ITypedElement)element).getMetaType() : (IModelElement)element;
            DataTypeType dataType = ModelUtils.getDataType((IModelElement)ref, (String)"serializable");
            AttributeType browsable = AttributeUtil.getAttribute((IExtensibleElement)element, (String)"carnot:engine:browsable");
            if ((browsable == null || AttributeUtil.getBooleanValue((AttributeType)browsable) || AccessPointUtil.isOut((DirectionType)direction)) && fullClassName != null && (type = (finder = new TypeFinder((EObject)ref)).findType(fullClassName)) != null) {
                String fragmentName = PlainJavaAccessPointProvider.getFragmentNameFilter(hint);
                List methods = finder.getMethods(type, fragmentName);
                int i = 0;
                while (i < methods.size()) {
                    MethodInfo method = (MethodInfo)methods.get(i);
                    if (methodName != null) {
                        String compactMethodName = StringUtils.replace((String)methodName, (String)", ", (String)",");
                        if (method.getEncoded().equals(compactMethodName)) {
                            method.setUsedForObjectCreation(usedForObjectCreation);
                            PlainJavaAccessPointProvider.addParameterAccessPoints(method, accessPoints, direction, dataType, paramsOnly);
                            if (paramsOnly) {
                                return accessPoints;
                            }
                        }
                    }
                    if (!paramsOnly) {
                        PlainJavaAccessPointProvider.addMethodAccessPoint(method, accessPoints, direction, dataType);
                    }
                    ++i;
                }
                if (hint == null && constructorName != null) {
                    String compactCtorName = StringUtils.replace((String)constructorName, (String)", ", (String)",");
                    List constructors = finder.getConstructors(type);
                    int i2 = 0;
                    while (i2 < constructors.size()) {
                        MethodInfo method = (MethodInfo)constructors.get(i2);
                        if (method.getEncoded().equals(compactCtorName) && method.isAccessible()) {
                            PlainJavaAccessPointProvider.addParameterAccessPoints(method, accessPoints, direction, dataType, paramsOnly);
                        }
                        ++i2;
                    }
                }
            }
        }
        return accessPoints;
    }

    public static String getFragmentNameFilter(String hint) {
        if (hint == null) {
            hint = "";
        } else {
            int ix = hint.indexOf(40);
            if (ix >= 0) {
                hint = hint.substring(0, ix);
            }
        }
        return hint;
    }

    public static void addParameterAccessPoints(MethodInfo method, ArrayList accessPoints, DirectionType direction, DataTypeType dataType, boolean paramsOnly) {
        String prefix;
        String string = prefix = method.isUsedForObjectCreation() ? "InitParam" : "Param";
        if (AccessPointUtil.isIn((DirectionType)direction)) {
            int i = 0;
            while (i < method.getParameterCount()) {
                String humanName = method.getParameterName(i);
                String paramName = String.valueOf(humanName.toLowerCase().charAt(0)) + prefix + (i + 1);
                AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)paramName, (String)(String.valueOf(paramName) + " : " + humanName), (String)method.getParameterType(i), (DirectionType)DirectionType.IN_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.PARAMETER.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
                accessPoints.add(accessPoint);
                ++i;
            }
        }
        if (!paramsOnly && method.hasReturn() && AccessPointUtil.isOut((DirectionType)direction)) {
            AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)"returnValue", (String)("returnValue : " + method.getReturnName()), (String)method.getReturnType(), (DirectionType)DirectionType.OUT_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.RETURN_VALUE.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
            accessPoints.add(accessPoint);
        }
    }

    public static void addMethodAccessPoint(MethodInfo method, ArrayList accessPoints, DirectionType direction, DataTypeType dataType) {
        if (method.getParameterCount() == 0) {
            if (method.hasReturn() && AccessPointUtil.isOut((DirectionType)direction) && method.isAccessible()) {
                AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)method.getEncoded(), (String)method.getLabel(), (String)method.getReturnType(), (DirectionType)DirectionType.OUT_LITERAL, (!method.isPrimitiveReturn() && !method.isArrayReturn() ? 1 : 0) != 0, (String[])new String[]{JavaAccessPointType.METHOD.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
                accessPoints.add(accessPoint);
            }
        } else if (method.getParameterCount() == 1 && AccessPointUtil.isIn((DirectionType)direction) && method.isAccessible()) {
            AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)method.getEncoded(), (String)method.getLabel(), (String)method.getParameterType(0), (DirectionType)DirectionType.IN_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.METHOD.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
            accessPoints.add(accessPoint);
        }
    }

    public static String[] splitAccessPath(String accessPath) {
        if (accessPath != null && accessPath.length() > 0) {
            int pCount = 0;
            int i = 0;
            while (i < accessPath.length()) {
                if (accessPath.charAt(i) == '.' && pCount == 0) {
                    return new String[]{accessPath.substring(0, i), accessPath.substring(i + 1)};
                }
                if (accessPath.charAt(i) == '(') {
                    ++pCount;
                }
                if (accessPath.charAt(i) == ')') {
                    --pCount;
                }
                ++i;
            }
        }
        String[] stringArray = new String[2];
        stringArray[0] = accessPath;
        return stringArray;
    }
}

