/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice;

import java.util.Map;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.QNameUtil;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSResource;

public final class JaxWSUtil {
    private static final String EMPTY_STRING = "";

    private JaxWSUtil() {
    }

    public static void createAccessPoint(Map<String, AccessPointType> rawAccessPoints, ApplicationType application, String id, String name, DirectionType direction, DataTypeType type, String className) {
        AccessPointType ap = null;
        if (rawAccessPoints != null) {
            ap = rawAccessPoints.get(id);
        }
        if (ap == null) {
            ap = AccessPointUtil.createAccessPoint((String)id, (String)name, (DirectionType)direction, (DataTypeType)type);
            application.getAccessPoint().add((Object)ap);
        } else {
            rawAccessPoints.remove(id);
            ap.setName(name);
            ap.setType(type);
            ap.setDescription(null);
            ap.getAttribute().clear();
        }
        if (className != null) {
            AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:className", (String)className);
        }
        if (DirectionType.IN_LITERAL.equals((Object)direction)) {
            AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:browsable", (String)"boolean", (String)Boolean.TRUE.toString());
        }
    }

    public static void createAccessPoint(ApplicationType application, Part part, String bindingStyle, DirectionType direction, DataTypeType serializable, DataTypeType plainXML, Map<String, AccessPointType> rawAccessPoints, JaxWSOutlineSynchronizer synchronizer) {
        String className = EMPTY_STRING;
        if (!StringUtils.isEmpty((String)bindingStyle) && !"message".equals(bindingStyle)) {
            if (synchronizer != null) {
                className = synchronizer.getMapping(part);
            }
            if (className.length() == 0 && (className = JaxWSResource.getDefaultMappedClass(JaxWSResource.getType(part))) == null) {
                className = EMPTY_STRING;
            }
        }
        DataTypeType type = className.length() == 0 ? plainXML : serializable;
        String name = part.getName();
        JaxWSUtil.createAccessPoint(rawAccessPoints, application, name, name, direction, type, className);
        JaxWSUtil.createStructAccessPoint(rawAccessPoints, application, String.valueOf(name) + "_struct", direction, part);
    }

    public static TypeDeclarationType findMatchingTypeDeclaration(ApplicationType application, Part part) {
        ExternalPackages packages;
        QName qname = part.getElementName();
        if (qname == null && (qname = part.getTypeName()) == null) {
            return null;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        TypeDeclarationType type = JaxWSUtil.findMatchingTypeDeclaration(qname, model);
        if (type == null && (packages = model.getExternalPackages()) != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                model = ModelUtils.getExternalModel((ExternalPackage)pkg);
                if (model != null && (type = JaxWSUtil.findMatchingTypeDeclaration(qname, model)) != null) break;
            }
        }
        return type;
    }

    public static TypeDeclarationType findMatchingTypeDeclaration(QName qname, ModelType model) {
        TypeDeclarationsType allTypeDeclarations = model.getTypeDeclarations();
        TypeDeclarationType typeDeclaration = allTypeDeclarations.getTypeDeclaration(qname.getLocalPart());
        if (typeDeclaration == null) {
            return null;
        }
        TypedXPath rootXPath = StructuredTypeUtils.getXPathMap((TypeDeclarationType)typeDeclaration).getRootXPath();
        if (!QNameUtil.toString((String)rootXPath.getXsdElementNs(), (String)rootXPath.getXsdElementName()).equals(qname.toString())) {
            return null;
        }
        return typeDeclaration;
    }

    private static void createStructAccessPoint(Map<String, AccessPointType> rawAccessPoints, ApplicationType application, String id, DirectionType direction, Part part) {
        TypeDeclarationType typeDeclaration = JaxWSUtil.findMatchingTypeDeclaration(application, part);
        if (typeDeclaration == null) {
            return;
        }
        AccessPointType ap = null;
        String name = String.valueOf(id) + " (" + typeDeclaration.getName() + ")";
        DataTypeType dataType = ModelUtils.getDataType((IModelElement)application, (String)"struct");
        if (rawAccessPoints != null) {
            ap = rawAccessPoints.get(id);
        }
        String transformationType = null;
        if (direction.equals((Object)DirectionType.IN_LITERAL) || direction.equals((Object)DirectionType.INOUT_LITERAL)) {
            transformationType = "DOM";
        }
        if (ap == null) {
            ap = AccessPointUtil.createAccessPoint((String)id, (String)name, (DirectionType)direction, (DataTypeType)dataType);
            application.getAccessPoint().add((Object)ap);
            StructuredTypeUtils.setStructuredAccessPointAttributes((IExtensibleElement)ap, (TypeDeclarationType)typeDeclaration, (String)transformationType);
        } else {
            rawAccessPoints.remove(id);
            ap.setName(name);
            ap.setType(dataType);
            ap.setDescription(null);
            ap.getAttribute().clear();
            StructuredTypeUtils.setStructuredAccessPointAttributes((IExtensibleElement)ap, (TypeDeclarationType)typeDeclaration, (String)transformationType);
        }
    }

    public static void createAccessPoints(ApplicationType application, Message message, String bindingStyle, DirectionType direction, DataTypeType serializable, DataTypeType plainXML, Map<String, AccessPointType> rawAccessPoints, JaxWSOutlineSynchronizer synchronizer) {
        for (Part part : message.getOrderedParts(null)) {
            JaxWSUtil.createAccessPoint(application, part, bindingStyle, direction, serializable, plainXML, rawAccessPoints, synchronizer);
        }
    }
}

