/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.struct;

import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;

public class StructAccessPathEditor
implements IAccessPathEditor {
    public List<AccessPointType> getAccessPoints(String hint, IExtensibleElement dataObject, DirectionType direction) {
        List accessPoints = CollectionUtils.newList();
        if (dataObject instanceof DataType) {
            TypeDeclarationType declaration = null;
            if (GenericUtils.isStructuredDataType((DataType)dataObject)) {
                declaration = StructuredTypeUtils.getTypeDeclaration((DataType)((DataType)dataObject));
            }
            if (declaration == null) {
                return accessPoints;
            }
            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)declaration);
            this.addAccessPoints(accessPoints, (IModelElement)dataObject, xPathMap.getRootXPath(), xPathMap, direction);
        } else if (dataObject instanceof StructAccessPointType) {
            StructAccessPointType ap = (StructAccessPointType)dataObject;
            this.addAccessPoints(accessPoints, (IModelElement)ap.getType(), ap.getXPath(), ap.getXPathMap(), direction);
        }
        return accessPoints;
    }

    private void addAccessPoints(List<AccessPointType> accessPoints, IModelElement modelElement, TypedXPath xPath, IXPathMap xPathMap, DirectionType direction) {
        List childXPaths = xPath.getChildXPaths();
        int i = 0;
        while (i < childXPaths.size()) {
            TypedXPath childXPath = (TypedXPath)childXPaths.get(i);
            accessPoints.add(this.createElementAccessPoint(childXPath, xPathMap, modelElement, direction));
            ++i;
        }
    }

    private AccessPointType createElementAccessPoint(TypedXPath xPath, IXPathMap xPathMap, IModelElement modelElement, DirectionType direction) {
        DataTypeType dataType = null;
        String type = null;
        if (xPath.getType() == -1) {
            dataType = ModelUtils.getDataType((IModelElement)modelElement, (String)"struct");
        } else {
            dataType = ModelUtils.getDataType((IModelElement)modelElement, (String)"primitive");
            switch (xPath.getType()) {
                case 0: {
                    type = "boolean";
                    break;
                }
                case 1: {
                    type = "char";
                    break;
                }
                case 2: {
                    type = "byte";
                    break;
                }
                case 3: {
                    type = "short";
                    break;
                }
                case 4: {
                    type = "int";
                    break;
                }
                case 5: {
                    type = "long";
                    break;
                }
                case 6: {
                    type = "float";
                    break;
                }
                case 7: {
                    type = "double";
                    break;
                }
                case 8: {
                    type = "String";
                    break;
                }
                case 9: {
                    type = "Timestamp";
                }
            }
        }
        StructAccessPointType accessPoint = new StructAccessPointType(xPath, xPathMap);
        String name = StructuredDataXPathUtils.getLastXPathPart((String)xPath.getXPath());
        accessPoint.setId(name);
        accessPoint.setName(name);
        accessPoint.setType(dataType);
        accessPoint.setDirection(direction);
        AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:path:separator", (String)"/");
        AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:browsable", (Boolean)true);
        if (xPath.isList()) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:data:indexed", (Boolean)true);
        }
        AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:data:bidirectional", (Boolean)true);
        if (type != null) {
            AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:type", (String)type);
        }
        return accessPoint;
    }

    public String[] splitAccessPath(String accessPath) {
        String[] stringArray;
        int ix = accessPath.indexOf("/");
        if (ix < 0) {
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            stringArray2[0] = accessPath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = accessPath.substring(0, ix);
            stringArray = stringArray3;
            stringArray3[1] = accessPath.substring(ix + "/".length());
        }
        return stringArray;
    }

    public boolean supportsBrowsing() {
        return true;
    }
}

