/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.jms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.engine.extensions.jms.app.JMSLocation;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JMSTriggerAccessPointPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String[][] LOCATION = new String[][]{{JMSLocation.HEADER.getId(), "Header"}, {JMSLocation.BODY.getId(), "Body"}};
    private LabeledCombo locationCombo;
    private LabeledText idText;
    private LabeledText nameText;
    private AccessPointType accessPointType;
    private LabelWithStatus lblTypeName;
    private TypeSelectionComposite classTypeBrowser;
    private Button autoIdButton;
    private Button[] buttons;
    private SelectionListener autoIdListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selection = ((Button)e.widget).getSelection();
            if (selection) {
                JMSTriggerAccessPointPropertyPage.this.idText.getText().setEditable(false);
                String computedId = ModelUtils.computeId((String)JMSTriggerAccessPointPropertyPage.this.nameText.getText().getText());
                JMSTriggerAccessPointPropertyPage.this.idText.getText().setText(computedId);
            } else {
                JMSTriggerAccessPointPropertyPage.this.idText.getText().setEditable(true);
            }
        }
    };
    private ModifyListener idSyncListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String name = text.getText();
            if (JMSTriggerAccessPointPropertyPage.this.autoIdButton.getSelection()) {
                JMSTriggerAccessPointPropertyPage.this.idText.getText().setText(ModelUtils.computeId((String)name));
            }
        }
    };

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.nameText.getText().removeModifyListener(this.idSyncListener);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        this.accessPointType = (AccessPointType)element;
        binding.bind(this.idText, (EObject)this.accessPointType, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id());
        binding.bind(this.nameText, (EObject)this.accessPointType, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
        binding.getValidationBindingManager().bind((EObject)this.accessPointType, (Object)"carnot:engine:jms.location", this.locationCombo.getLabel());
        String location = AttributeUtil.getAttributeValue((IExtensibleElement)this.accessPointType, (String)"carnot:engine:jms.location");
        if (location != null) {
            int i = 0;
            while (i < LOCATION.length) {
                if (LOCATION[i][0].equals(location)) {
                    this.locationCombo.getCombo().select(i);
                    break;
                }
                ++i;
            }
        }
        binding.bind(new LabeledText(this.classTypeBrowser.getText(), this.lblTypeName), (IExtensibleElement)this.accessPointType, "carnot:engine:className");
        this.nameText.getText().addModifyListener(this.idSyncListener);
        this.bindParameterMapping();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AccessPointType accessPointType = (AccessPointType)element;
        int locationIndex = this.locationCombo.getCombo().getSelectionIndex();
        if (locationIndex < 0) {
            AttributeUtil.setAttribute((IExtensibleElement)accessPointType, (String)"carnot:engine:jms.location", null);
        } else {
            AttributeUtil.setAttribute((IExtensibleElement)accessPointType, (String)"carnot:engine:jms.location", (String)JMSLocation.class.getName(), (String)LOCATION[locationIndex][0]);
        }
        GenericUtils.setAutoIdValue(this.getModelElement(), this.autoIdButton.getSelection());
    }

    private void bindParameterMapping() {
        if (!StringUtils.isEmpty(this.idText.getText().getText())) {
            Iterator iter = this.getParameter(this.idText.getText().getText(), (TriggerType)this.getModelElement().eContainer()).iterator();
            while (iter.hasNext()) {
                this.getWidgetBindingManager().bind(this.idText, (EObject)((ParameterMappingType)iter.next()), (EStructuralFeature)PKG_CWM.getParameterMappingType_Parameter());
            }
        }
    }

    private List getParameter(String id, TriggerType trigger) {
        ArrayList<ParameterMappingType> parameters = new ArrayList<ParameterMappingType>();
        for (ParameterMappingType mapping : trigger.getParameterMapping()) {
            if (StringUtils.isEmpty(id) || StringUtils.isEmpty(mapping.getParameter()) || !id.equals(mapping.getParameter())) continue;
            parameters.add(mapping);
        }
        return parameters;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.locationCombo = FormBuilder.createLabeledCombo((Composite)composite, (String)Diagram_Messages.LB_Location);
        int i = 0;
        while (i < LOCATION.length) {
            this.locationCombo.getCombo().add(LOCATION[i][1]);
            ++i;
        }
        this.locationCombo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int locationIndex = JMSTriggerAccessPointPropertyPage.this.locationCombo.getCombo().getSelectionIndex();
                if (locationIndex > -1) {
                    AttributeUtil.setAttribute((IExtensibleElement)JMSTriggerAccessPointPropertyPage.this.accessPointType, (String)"carnot:engine:jms.location", (String)JMSLocation.class.getName(), (String)LOCATION[locationIndex][0]);
                }
            }
        });
        this.nameText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.idText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.autoIdButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BTN_AutoId, (int)2);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue(this.getModelElement());
        this.autoIdButton.setSelection(autoIdButtonValue);
        if (autoIdButtonValue) {
            this.idText.getText().setEditable(false);
        }
        this.autoIdButton.addSelectionListener(this.autoIdListener);
        this.lblTypeName = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_SPI_Type);
        this.classTypeBrowser = new TypeSelectionComposite(composite, Diagram_Messages.LB_SPI_Type);
        return composite;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.bindParameterMapping();
            IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
            if (manager != null) {
                manager.updateButtons(this.getModelElement(), this.buttons);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }
}

