/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.timer;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.NumericFieldVerifier;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.DefaultModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.TimeAttrUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimerPropertyPage
extends DefaultModelElementPropertyPage {
    private static final String DAYS = Diagram_Messages.DAYS;
    private static final String MONTHS = Diagram_Messages.MONTHS;
    private static final String YEARS = Diagram_Messages.YEARS;
    private static final String HOURS = Diagram_Messages.SHORT_HOURS;
    private static final String MINUTES = Diagram_Messages.SHORT_MINUTES;
    private static final String SECONDS = Diagram_Messages.SHORT_SECONDS;
    private DatePickerCombo timestampStartCombo;
    private Text hoursStartTimestampText;
    private Text minutesStartTimestampText;
    private Text secondsStartTimestampText;
    private Button periodicalButton;
    private final Text[] txtPeriodParts = new Text[6];
    private DatePickerCombo timestampStopCombo;
    private Text hoursStopTimestampText;
    private Text minutesStopTimestampText;
    private Text secondsStopTimestampText;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement node) {
        if (node instanceof IExtensibleElement) {
            IExtensibleElement eNode = (IExtensibleElement)node;
            Calendar startTime = null;
            String tsStart = AttributeUtil.getAttributeValue((IExtensibleElement)eNode, (String)"carnot:engine:startTime");
            if (!StringUtils.isEmpty((String)tsStart)) {
                startTime = Calendar.getInstance();
                startTime.setTime(new Date(Long.parseLong(tsStart)));
            }
            TimerPropertyPage.initTmestamp(startTime, this.timestampStartCombo, this.hoursStartTimestampText, this.minutesStartTimestampText, this.secondsStartTimestampText);
            String tsPeriodicity = AttributeUtil.getAttributeValue((IExtensibleElement)eNode, (String)"carnot:engine:periodicity");
            if (!StringUtils.isEmpty((String)tsPeriodicity)) {
                this.enablePeriodicity(true);
                this.periodicalButton.setSelection(true);
                AttributeType attrPeriod = AttributeUtil.getAttribute((IExtensibleElement)eNode, (String)"carnot:engine:periodicity");
                if (attrPeriod != null) {
                    this.initPeriod(node);
                }
                Calendar stopTime = null;
                String tsStop = AttributeUtil.getAttributeValue((IExtensibleElement)eNode, (String)"carnot:engine:stopTime");
                if (!StringUtils.isEmpty((String)tsStop)) {
                    stopTime = Calendar.getInstance();
                    stopTime.setTime(new Date(Long.parseLong(tsStop)));
                }
                TimerPropertyPage.initTmestamp(stopTime, this.timestampStopCombo, this.hoursStopTimestampText, this.minutesStopTimestampText, this.secondsStopTimestampText);
            } else {
                this.periodicalButton.setSelection(false);
                this.enablePeriodicity(false);
                TimerPropertyPage.initTmestamp(null, this.timestampStopCombo, this.hoursStopTimestampText, this.minutesStopTimestampText, this.secondsStopTimestampText);
            }
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        TimerPropertyPage.updateTimestampAttr((IExtensibleElement)element, "carnot:engine:startTime", this.timestampStartCombo, this.hoursStartTimestampText, this.minutesStartTimestampText, this.secondsStartTimestampText);
        if (this.periodicalButton.getSelection()) {
            this.updatePeriodAttribute((IExtensibleElement)element);
            TimerPropertyPage.updateTimestampAttr((IExtensibleElement)element, "carnot:engine:stopTime", this.timestampStopCombo, this.hoursStopTimestampText, this.minutesStopTimestampText, this.secondsStopTimestampText);
        } else {
            TimeAttrUtils.updatePeriodAttr((IExtensibleElement)element, "carnot:engine:periodicity", null);
            TimerPropertyPage.updateTimestampAttr((IExtensibleElement)element, "carnot:engine:stopTime", null, null, null, null);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)5);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_StartTimestamp);
        this.timestampStartCombo = new DatePickerCombo(composite, 2048);
        Calendar timestampStartCalendar = Calendar.getInstance();
        timestampStartCalendar.roll(1, 0);
        Date timestampStartDate = timestampStartCalendar.getTime();
        this.timestampStartCombo.setDate(timestampStartDate);
        this.timestampStartCombo.setDateFormat((DateFormat)new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY));
        this.timestampStartCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.hoursStartTimestampText = FormBuilder.createText((Composite)composite);
        this.hoursStartTimestampText.setTextLimit(2);
        GridData gdHoursStartTimestamp = new GridData();
        gdHoursStartTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.hoursStartTimestampText.setLayoutData((Object)gdHoursStartTimestamp);
        this.hoursStartTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 23));
        this.minutesStartTimestampText = FormBuilder.createText((Composite)composite);
        this.minutesStartTimestampText.setTextLimit(2);
        GridData gdMinutesStartTimestamp = new GridData();
        gdMinutesStartTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.minutesStartTimestampText.setLayoutData((Object)gdMinutesStartTimestamp);
        this.minutesStartTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
        this.secondsStartTimestampText = FormBuilder.createText((Composite)composite);
        this.secondsStartTimestampText.setTextLimit(2);
        GridData gdSecondsStartTimestamp = new GridData();
        gdSecondsStartTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.secondsStartTimestampText.setLayoutData((Object)gdSecondsStartTimestamp);
        this.secondsStartTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Periodical);
        this.periodicalButton = FormBuilder.createCheckBox((Composite)composite, (String)"", (int)4);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Periodicity);
        this.createConstantComposite(composite);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_StopTimestamp);
        this.timestampStopCombo = new DatePickerCombo(composite, 2048);
        Calendar timestampStopCalendar = Calendar.getInstance();
        timestampStopCalendar.roll(1, 0);
        Date timestampStopDate = timestampStopCalendar.getTime();
        this.timestampStopCombo.setDate(timestampStopDate);
        this.timestampStopCombo.setDateFormat((DateFormat)new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY));
        this.timestampStopCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.hoursStopTimestampText = FormBuilder.createText((Composite)composite, (int)2048);
        this.hoursStopTimestampText.setTextLimit(2);
        GridData gdHoursStopTimestamp = new GridData();
        gdHoursStopTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.hoursStopTimestampText.setLayoutData((Object)gdHoursStopTimestamp);
        this.hoursStopTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 23));
        this.minutesStopTimestampText = FormBuilder.createText((Composite)composite, (int)2048);
        this.minutesStopTimestampText.setTextLimit(2);
        GridData gdMinutesStopTimestamp = new GridData();
        gdMinutesStopTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.minutesStopTimestampText.setLayoutData((Object)gdMinutesStopTimestamp);
        this.minutesStopTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
        this.secondsStopTimestampText = FormBuilder.createText((Composite)composite, (int)2048);
        this.secondsStopTimestampText.setTextLimit(2);
        GridData gdSecondsStopTimestamp = new GridData();
        gdSecondsStopTimestamp.widthHint = FormBuilder.getTextSize((Control)composite, (int)4);
        this.secondsStopTimestampText.setLayoutData((Object)gdSecondsStopTimestamp);
        this.secondsStopTimestampText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
        this.periodicalButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimerPropertyPage.this.enablePeriodicity(TimerPropertyPage.this.periodicalButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TimerPropertyPage.this.enablePeriodicity(TimerPropertyPage.this.periodicalButton.getSelection());
            }
        });
        return composite;
    }

    private void createConstantComposite(Composite parent) {
        Composite pnlPeriod = FormBuilder.createComposite((Composite)parent, (int)12, (int)4);
        pnlPeriod.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)4));
        GridLayout periodGridLayout = new GridLayout(12, false);
        periodGridLayout.marginWidth = 0;
        periodGridLayout.marginHeight = 0;
        pnlPeriod.setLayout((Layout)periodGridLayout);
        GridData gdPeriod = new GridData();
        gdPeriod.widthHint = FormBuilder.getTextSize((Control)parent, (int)4);
        this.createYearsText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)YEARS);
        this.createMonthText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)MONTHS);
        this.createDaysText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)DAYS);
        this.createHoursText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)HOURS);
        this.createMinText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)MINUTES);
        this.createSecText(pnlPeriod, gdPeriod);
        FormBuilder.createLabel((Composite)pnlPeriod, (String)SECONDS);
    }

    private void createYearsText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[0] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[0].setTextLimit(3);
        this.txtPeriodParts[0].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[0].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 999));
    }

    private void createMonthText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[1] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[1].setTextLimit(2);
        this.txtPeriodParts[1].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[1].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 11));
    }

    private void createDaysText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[2] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[2].setTextLimit(3);
        this.txtPeriodParts[2].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[2].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 365));
    }

    private void createHoursText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[3] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[3].setTextLimit(2);
        this.txtPeriodParts[3].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[3].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 23));
    }

    private void createMinText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[4] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[4].setTextLimit(2);
        this.txtPeriodParts[4].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[4].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
    }

    private void createSecText(Composite parent, GridData gdPeriod) {
        this.txtPeriodParts[5] = FormBuilder.createText((Composite)parent);
        this.txtPeriodParts[5].setTextLimit(2);
        this.txtPeriodParts[5].setLayoutData((Object)gdPeriod);
        this.txtPeriodParts[5].addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
    }

    private void initPeriod(IModelElement element) {
        AttributeType attrPeriod = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:periodicity");
        if (attrPeriod != null) {
            TimeAttrUtils.initPeriod(this.txtPeriodParts, attrPeriod);
        }
    }

    private void updatePeriodAttribute(IExtensibleElement element) {
        TimeAttrUtils.updatePeriodAttr(element, "carnot:engine:periodicity", this.txtPeriodParts);
    }

    private void enablePeriodicity(boolean enabled) {
        int i = 0;
        while (i < this.txtPeriodParts.length) {
            if (this.txtPeriodParts[i] != null && !this.txtPeriodParts[i].isDisposed()) {
                this.txtPeriodParts[i].setEnabled(enabled);
            }
            ++i;
        }
        if (!this.timestampStopCombo.isDisposed()) {
            this.timestampStopCombo.setEnabled(enabled);
        }
        if (!this.hoursStopTimestampText.isDisposed()) {
            this.hoursStopTimestampText.setEnabled(enabled);
        }
        if (!this.minutesStopTimestampText.isDisposed()) {
            this.minutesStopTimestampText.setEnabled(enabled);
        }
        if (!this.secondsStopTimestampText.isDisposed()) {
            this.secondsStopTimestampText.setEnabled(enabled);
        }
    }

    private static void initTmestamp(Calendar timeStamp, DatePickerCombo dateCombo, Text hours, Text minutes, Text seconds) {
        dateCombo.setDate(timeStamp != null ? timeStamp.getTime() : null);
        hours.setText(timeStamp != null ? Integer.toString(timeStamp.get(11)) : "");
        minutes.setText(timeStamp != null ? Integer.toString(timeStamp.get(12)) : "");
        seconds.setText(timeStamp != null ? Integer.toString(timeStamp.get(13)) : "");
    }

    private static void updateTimestampAttr(IExtensibleElement element, String attrName, DatePickerCombo dateCombo, Text hours, Text minutes, Text seconds) {
        Calendar timeStamp = null;
        if (dateCombo != null && dateCombo.getDate() != null) {
            timeStamp = Calendar.getInstance();
            timeStamp.setTime(dateCombo.getDate());
            timeStamp.add(11, TimeAttrUtils.parseShort(hours.getText()));
            timeStamp.add(12, TimeAttrUtils.parseShort(minutes.getText()));
            timeStamp.add(13, TimeAttrUtils.parseShort(seconds.getText()));
        }
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)attrName, (String)Reflect.getAbbreviatedName(Long.TYPE), (String)(timeStamp != null ? Long.toString(timeStamp.getTime().getTime()) : ""));
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
    }
}

