/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.ui.DereferencePathBrowserContentProvider;
import org.eclipse.stardust.modeling.core.ui.DereferencePathBrowserLabelProvider;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DereferencePathBrowser
extends Dialog {
    private TypeInfo type;
    private String selectedMethod = "";
    private TypeFinder finder;
    private String title;
    private boolean isConstructor = false;
    private boolean isDeep = true;

    public DereferencePathBrowser(Shell parentShell, TypeInfo type, TypeFinder finder, String title) {
        super(parentShell);
        this.type = type;
        this.finder = finder;
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = 300;
        gd.minimumWidth = 320;
        gd.heightHint = 300;
        gd.widthHint = 320;
        Tree tree = FormBuilder.createTree((Composite)composite, (int)2816);
        final TreeViewer viewer = new TreeViewer(tree);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeItem methodItem = ((TreeViewer)event.getSource()).getTree().getSelection()[0];
                DereferencePathBrowser.this.selectedMethod = DereferencePathBrowser.this.getMethodPath(methodItem);
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeItem methodItem = viewer.getTree().getSelection()[0];
                if (methodItem.getItems().length < 1) {
                    DereferencePathBrowser.this.selectedMethod = DereferencePathBrowser.this.getMethodPath(methodItem).substring(0, DereferencePathBrowser.this.getMethodPath(methodItem).length());
                    DereferencePathBrowser.this.close();
                } else {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (viewer.getExpandedState(obj)) {
                        viewer.collapseToLevel(obj, 1);
                    } else {
                        viewer.expandToLevel(obj, 1);
                    }
                }
            }
        });
        viewer.setContentProvider((IContentProvider)new DereferencePathBrowserContentProvider(this.finder, this.isConstructor, this.isDeep));
        viewer.setLabelProvider((IBaseLabelProvider)new DereferencePathBrowserLabelProvider());
        viewer.setInput((Object)this.type);
        viewer.setSorter(new ViewerSorter());
        return composite;
    }

    private String getMethodPath(TreeItem methodItem) {
        String methodPath = null;
        if (methodItem.getParentItem() != null) {
            methodPath = this.getMethodPath(methodItem.getParentItem());
        }
        MethodInfo info = (MethodInfo)methodItem.getData();
        String methodName = info.getEncoded();
        methodPath = methodPath == null ? methodName : String.valueOf(methodPath) + "." + methodName;
        return methodPath;
    }

    public String getSelectedMethod() {
        return this.selectedMethod;
    }

    public void setConstructor(boolean b) {
        this.isConstructor = b;
    }

    public void setDeep(boolean b) {
        this.isDeep = b;
    }
}

