/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class DereferencePathBrowserContentProvider
implements ITreeContentProvider {
    private final TypeFinder finder;
    private boolean isConstructor = false;
    private boolean isDeep = true;

    public DereferencePathBrowserContentProvider(TypeFinder finder, boolean isConstructor, boolean deep) {
        this.finder = finder;
        this.isConstructor = isConstructor;
        this.isDeep = deep;
    }

    public Object[] getChildren(Object parentElement) {
        String returnType;
        IType type;
        if (parentElement instanceof TypeInfo) {
            parentElement = ((TypeInfo)parentElement).getType();
        }
        MethodInfo[] methods = null;
        if (parentElement instanceof IType) {
            methods = this.isConstructor ? this.sort(this.finder.getConstructors((IType)parentElement).toArray()) : this.sort(this.finder.getMethods((IType)parentElement).toArray());
        } else if (parentElement instanceof MethodInfo && (type = this.finder.findExactType(returnType = ((MethodInfo)parentElement).getReturnType())) != null) {
            methods = this.sort(this.finder.getMethods(type).toArray());
        }
        return methods;
    }

    private MethodInfo[] sort(Object[] objects) {
        HashMap<String, Object> methodMap = new HashMap<String, Object>();
        Object[] methodNames = new String[objects.length];
        int i = 0;
        while (i < objects.length) {
            String methodName = ((MethodInfo)objects[i]).getLabel();
            methodMap.put(methodName, objects[i]);
            methodNames[i] = methodName;
            ++i;
        }
        Arrays.sort(methodNames);
        MethodInfo[] sortedMethods = new MethodInfo[objects.length];
        int i2 = 0;
        while (i2 < methodNames.length) {
            sortedMethods[i2] = (MethodInfo)methodMap.get(methodNames[i2]);
            ++i2;
        }
        return sortedMethods;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TypeInfo) {
            element = ((TypeInfo)element).getType();
        }
        if (element instanceof IType) {
            if (this.isConstructor) {
                return true;
            }
            return this.finder.getMethods((IType)element).size() > 0;
        }
        if (element instanceof MethodInfo && this.isDeep) {
            String returnType = ((MethodInfo)element).getReturnType();
            return !StringUtils.isEmpty(returnType) && this.isNoPrimitiveType(returnType);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.hasChildren(inputElement)) {
            return this.getChildren(inputElement);
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isNoPrimitiveType(String returnType) {
        return !returnType.equalsIgnoreCase("void") && !returnType.equals("int") && !returnType.equals("long") && !returnType.equals("double") && !returnType.equals("boolean") && !returnType.equals("char") && !returnType.equals("byte") && !StringUtils.isEmpty(returnType);
    }
}

