/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.stardust.common.Period;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.swt.widgets.Text;

public class TimeAttrUtils {
    private static final short ZERO = 0;
    private static final short ZERO_YEAR = 0;
    private static final short ZERO_DAY = 0;
    private static final int[] FIELD_KIND;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        FIELD_KIND = nArray;
    }

    public static void initPeriod(Text[] txtPeriodParts, AttributeType attr) {
        Period period = attr != null ? new Period(attr.getValue()) : new Period(0, 0, 0, 0, 0, 0);
        int i = 0;
        while (i < FIELD_KIND.length) {
            if (i < txtPeriodParts.length) {
                txtPeriodParts[i].setText(Short.toString(period.get(FIELD_KIND[i])));
            }
            ++i;
        }
    }

    public static String initPeriod(AttributeType attr) {
        Period period = attr != null ? new Period(attr.getValue()) : new Period(0, 0, 0, 0, 0, 0);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < FIELD_KIND.length) {
            int periodPartSize = FIELD_KIND[i] == 0 || FIELD_KIND[i] == 2 ? 3 : 2;
            String periodField = Short.toString(period.get(FIELD_KIND[i]));
            int j = 0;
            while (j < periodPartSize - periodField.length()) {
                buffer.append(String.valueOf(0));
                ++j;
            }
            buffer.append(periodField);
            if (i < FIELD_KIND.length - 1) {
                buffer.append(": ");
            }
            ++i;
        }
        String periodPart = buffer.toString();
        return periodPart;
    }

    public static void updatePeriodAttr(IExtensibleElement element, String attrName, Text[] txtPeriodParts) {
        Period period = null;
        if (txtPeriodParts != null) {
            short[] fields = new short[FIELD_KIND.length];
            int i = 0;
            while (i < fields.length) {
                if (i < txtPeriodParts.length) {
                    fields[i] = TimeAttrUtils.parseShort(txtPeriodParts[i].getText());
                }
                ++i;
            }
            period = new Period(fields[0], fields[1], fields[2], fields[3], fields[4], fields[5]);
        }
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)attrName, (String)Reflect.getAbbreviatedName(Period.class), (String)(period != null ? period.toString() : ""));
    }

    public static void updatePeriodAttr(IExtensibleElement element, String attrName, String[] periodParts) {
        Period period = null;
        if (periodParts != null) {
            short[] fields = new short[FIELD_KIND.length];
            int i = 0;
            while (i < fields.length) {
                if (i < periodParts.length) {
                    fields[i] = TimeAttrUtils.parseShort(periodParts[i].trim());
                }
                ++i;
            }
            period = new Period(fields[0], fields[1], fields[2], fields[3], fields[4], fields[5]);
        }
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)attrName, (String)Reflect.getAbbreviatedName(Period.class), (String)(period != null ? period.toString() : ""));
    }

    public static short parseShort(String value) {
        try {
            Number result = NumberFormat.getIntegerInstance().parse(value);
            return result != null ? result.shortValue() : (short)0;
        }
        catch (ParseException parseException) {
            return 0;
        }
    }
}

