/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.views.repository.VersionRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SwitchProjectAction
extends Action {
    private VersionRepository repository;
    private Map imageCache;

    public SwitchProjectAction(VersionRepository repository) {
        super(Diagram_Messages.LB_Repository_Project);
        this.repository = repository;
        this.imageCache = new HashMap();
        this.setMenuCreator(new IMenuCreator(){
            private Menu projectsMenu;

            public void dispose() {
                if (this.projectsMenu != null) {
                    int i = 0;
                    while (i < this.projectsMenu.getItemCount()) {
                        MenuItem menuItem = this.projectsMenu.getItem(i);
                        menuItem.setData(null);
                        menuItem.setImage(null);
                        ++i;
                    }
                    this.projectsMenu.dispose();
                    this.projectsMenu = null;
                }
            }

            public Menu getMenu(Control parent) {
                this.dispose();
                this.projectsMenu = new Menu(parent);
                SwitchProjectAction.this.populateMenu(this.projectsMenu);
                return this.projectsMenu;
            }

            public Menu getMenu(Menu parent) {
                this.dispose();
                this.projectsMenu = new Menu(parent);
                SwitchProjectAction.this.populateMenu(this.projectsMenu);
                return this.projectsMenu;
            }
        });
    }

    private Menu populateMenu(Menu projectsMenu) {
        IProject[] projects = this.repository.getContentProvider().getProjects();
        this.addMenuItem(projectsMenu, null, projects != null && projects.length > 0);
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isAccessible() && projects[i].isOpen()) {
                    this.addMenuItem(projectsMenu, projects[i], false);
                }
                ++i;
            }
        }
        return projectsMenu;
    }

    private void addMenuItem(Menu parent, IProject value, boolean addSeparator) {
        MenuItem item = new MenuItem(parent, 0);
        item.setData((Object)value);
        if (value == null) {
            item.setText(Diagram_Messages.LB_Repository_SelectionProject);
        } else {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)value.getAdapter(IWorkbenchAdapter.class);
            if (adapter == null) {
                item.setText(value.getName());
            } else {
                item.setText(adapter.getLabel((Object)value));
                item.setImage(this.getImage(adapter.getImageDescriptor((Object)value)));
            }
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                IProject project = (IProject)item.getData();
                SwitchProjectAction.this.repository.setStickyProject(project);
            }
        });
        if (addSeparator) {
            new MenuItem(parent, 2);
        }
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        Image image = (Image)this.imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            this.imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public void dispose() {
        Collection values = this.imageCache.values();
        for (Image image : values) {
            image.dispose();
        }
        this.imageCache.clear();
        this.imageCache = null;
        this.repository = null;
    }
}

