/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.Functor;
import org.eclipse.stardust.common.TransformingIterator;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IEventHandler;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IModelParticipant;
import org.eclipse.stardust.engine.api.model.IModeler;
import org.eclipse.stardust.engine.api.model.IParticipant;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.ITransition;
import org.eclipse.stardust.engine.api.model.ITrigger;
import org.eclipse.stardust.engine.api.runtime.DeploymentOptions;
import org.eclipse.stardust.engine.api.runtime.ParsedDeploymentUnit;
import org.eclipse.stardust.engine.api.runtime.Service;
import org.eclipse.stardust.engine.core.model.utils.Identifiable;
import org.eclipse.stardust.engine.core.runtime.beans.AbstractModelLoaderFactory;
import org.eclipse.stardust.engine.core.runtime.beans.AuditTrailPartitionBean;
import org.eclipse.stardust.engine.core.runtime.beans.DefaultServiceFactory;
import org.eclipse.stardust.engine.core.runtime.beans.IAuditTrailPartition;
import org.eclipse.stardust.engine.core.runtime.beans.IRuntimeOidRegistry;
import org.eclipse.stardust.engine.core.runtime.beans.ManagedService;
import org.eclipse.stardust.engine.core.runtime.beans.ModelLoader;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerBean;
import org.eclipse.stardust.engine.core.runtime.beans.ModelPersistorBean;
import org.eclipse.stardust.engine.core.runtime.beans.RuntimeOidUtils;
import org.eclipse.stardust.engine.core.runtime.beans.UserBean;
import org.eclipse.stardust.engine.core.runtime.beans.UserDomainBean;
import org.eclipse.stardust.engine.core.runtime.beans.UserRealmBean;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemDescription;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLoader;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLocatorUtils;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.SecurityProperties;
import org.eclipse.stardust.modeling.debug.engine.DebugActivityThreadContext;
import org.eclipse.stardust.modeling.debug.engine.DebugForkingServiceFactory;
import org.eclipse.stardust.modeling.debug.engine.DebugInvocationManager;

public class DebugServiceFactory
extends DefaultServiceFactory {
    public static final String DEBUG_ACCOUNT = "workflow-debugger";
    private String password;
    private String username;
    private DebugActivityThreadContext activityThreadContext = new DebugActivityThreadContext();

    public DebugServiceFactory(final List<IModel> models) {
        Parameters.instance().set("ActivityThread.Context", (Object)this.activityThreadContext);
        Parameters.instance().set("Engine.ForkingServiceHome", (Object)new DebugForkingServiceFactory());
        AuditTrailPartitionBean debugPartition = new AuditTrailPartitionBean(DEBUG_ACCOUNT);
        UserDomainBean debugDomain = new UserDomainBean(DEBUG_ACCOUNT, debugPartition, null);
        Parameters.instance().set("Current.PartitionOid", (Object)new Short(debugPartition.getOID()));
        Parameters.instance().set("Current.Partition", (Object)debugPartition);
        Parameters.instance().set("Current.DomainOid", (Object)new Long(debugDomain.getOID()));
        Parameters.instance().set("Current.Domain", (Object)debugDomain);
        ItemLocatorUtils.registerDescription((String)"model.manager", (ItemDescription)new ItemDescription(new ItemLoader(){

            public Object load() {
                return new ModelManagerBean((AbstractModelLoaderFactory)new DebugModelLoaderFactory(models));
            }
        }));
        UserRealmBean debugRealm = new UserRealmBean(DEBUG_ACCOUNT, DEBUG_ACCOUNT, debugPartition);
        UserBean debugUser = new UserBean(DEBUG_ACCOUNT, DEBUG_ACCOUNT, DEBUG_ACCOUNT, debugRealm);
        debugUser.setPassword(DEBUG_ACCOUNT);
        for (IModel model : models) {
            Iterator i = model.getAllWorkflowParticipants();
            while (i.hasNext()) {
                IModelParticipant participant = (IModelParticipant)i.next();
                debugUser.addToParticipants(participant, null);
            }
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("user", DEBUG_ACCOUNT);
        credentials.put("password", DEBUG_ACCOUNT);
        this.setCredentials(credentials);
    }

    public Object getService(Class service) {
        Object inner;
        Service result = this.getServiceFromPool(service);
        if (result != null) {
            return result;
        }
        String serviceName = service.getName();
        int dot = serviceName.lastIndexOf(".");
        String packageName = serviceName.substring(0, dot).replace(".api.", ".core.");
        String className = serviceName.substring(dot + 1);
        try {
            Class<?> impl = Class.forName(String.valueOf(packageName) + ".beans." + className + "Impl");
            inner = impl.newInstance();
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        DebugInvocationManager manager = new DebugInvocationManager(inner);
        result = (Service)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service, ManagedService.class}, (InvocationHandler)((Object)manager));
        this.putServiceToPool(service, result);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Security.Partition", DEBUG_ACCOUNT);
        props.put("Security.Realm", DEBUG_ACCOUNT);
        props.put("Security.Domain", DEBUG_ACCOUNT);
        ((ManagedService)result).login(this.username, this.password, props);
        return result;
    }

    public void setCredentials(Map credentials) {
        this.username = (String)credentials.get("user");
        this.password = (String)credentials.get("password");
    }

    public void close() {
        super.close();
        ItemLocatorUtils.unregisterDescription((String)"model.manager");
    }

    public DebugActivityThreadContext getActivityThreadContext() {
        return this.activityThreadContext;
    }

    private static final class DebugModelLoader
    implements ModelLoader {
        private List<IModel> models;
        private short partitionOid;

        private DebugModelLoader(List<IModel> models, short partitionOid) {
            this.models = models;
            this.partitionOid = partitionOid;
        }

        public void loadRuntimeOidRegistry(IRuntimeOidRegistry rtOidRegistry) {
            for (IModel model : this.models) {
                this.loadRuntimeOidRegistry(rtOidRegistry, model);
            }
        }

        private void loadRuntimeOidRegistry(IRuntimeOidRegistry rtOidRegistry, IModel model) {
            Iterator i = model.getAllData();
            while (i.hasNext()) {
                IData data = (IData)i.next();
                rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.DATA, RuntimeOidUtils.getFqId((Identifiable)data), this.getPartitionAwareRtOid(data.getElementOID()));
            }
            i = model.getAllParticipants();
            while (i.hasNext()) {
                IParticipant participant = (IParticipant)i.next();
                if (!(participant instanceof IModelParticipant) || participant instanceof IModeler) continue;
                rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.PARTICIPANT, RuntimeOidUtils.getFqId((Identifiable)participant), this.getPartitionAwareRtOid(((IModelParticipant)participant).getElementOID()));
            }
            i = model.getAllProcessDefinitions();
            while (i.hasNext()) {
                IProcessDefinition process = (IProcessDefinition)i.next();
                rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.PROCESS, RuntimeOidUtils.getFqId((Identifiable)process), this.getPartitionAwareRtOid(process.getElementOID()));
                Iterator j = process.getAllTriggers();
                while (j.hasNext()) {
                    ITrigger trigger = (ITrigger)j.next();
                    rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.TRIGGER, RuntimeOidUtils.getFqId((Identifiable)trigger), this.getPartitionAwareRtOid(trigger.getElementOID()));
                }
                j = process.getAllActivities();
                while (j.hasNext()) {
                    IActivity activity = (IActivity)j.next();
                    rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.ACTIVITY, RuntimeOidUtils.getFqId((Identifiable)activity), this.getPartitionAwareRtOid(activity.getElementOID()));
                    Iterator k = activity.getAllEventHandlers();
                    while (k.hasNext()) {
                        IEventHandler handler = (IEventHandler)k.next();
                        rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.EVENT_HANDLER, RuntimeOidUtils.getFqId((Identifiable)handler), this.getPartitionAwareRtOid(handler.getElementOID()));
                    }
                }
                j = process.getAllTransitions();
                while (j.hasNext()) {
                    ITransition transition = (ITransition)j.next();
                    rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.TRANSITION, RuntimeOidUtils.getFqId((Identifiable)transition), this.getPartitionAwareRtOid(transition.getElementOID()));
                }
                j = process.getAllEventHandlers();
                while (j.hasNext()) {
                    IEventHandler handler = (IEventHandler)j.next();
                    rtOidRegistry.registerRuntimeOid(IRuntimeOidRegistry.EVENT_HANDLER, RuntimeOidUtils.getFqId((Identifiable)handler), this.getPartitionAwareRtOid(handler.getElementOID()));
                }
            }
        }

        private long getPartitionAwareRtOid(int elementOid) {
            return (long)elementOid + ((long)this.partitionOid - 1L << 48);
        }

        public Iterator loadModels() {
            return new TransformingIterator(this.models.iterator(), (Functor)new Functor<IModel, ModelPersistorBean>(){
                int currentModelOid = 1;

                public ModelPersistorBean execute(final IModel source) {
                    final int modelOid = this.currentModelOid++;
                    return new ModelPersistorBean(){
                        private static final long serialVersionUID = 1L;

                        public IModel fetchModel() {
                            source.setModelOID(modelOid);
                            return source;
                        }

                        public IAuditTrailPartition getPartition() {
                            return SecurityProperties.getPartition();
                        }

                        public long getPredecessorOID() {
                            return DebugModelLoader.this.models.indexOf(source) - 1;
                        }

                        public long getModelOID() {
                            return modelOid;
                        }

                        public String getId() {
                            return source.getId();
                        }

                        public long getOID() {
                            return modelOid;
                        }
                    };
                }
            });
        }

        public void deployModel(List<ParsedDeploymentUnit> units, DeploymentOptions options, IRuntimeOidRegistry rtOidRegistry) {
            throw new UnsupportedOperationException();
        }

        public void modifyModel(ParsedDeploymentUnit unit, DeploymentOptions options, IRuntimeOidRegistry rtOidRegistry) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class DebugModelLoaderFactory
    extends AbstractModelLoaderFactory {
        private List<IModel> models;

        public DebugModelLoaderFactory(List<IModel> models) {
            this.models = models;
        }

        public ModelLoader instance(short partitionOid) {
            return new DebugModelLoader(this.models, partitionOid);
        }
    }
}

