/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.osgi.framework.Bundle;

public class RuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    private static final String[][] carnot_libs = new String[][]{{"org.eclipse.equinox.common", "/"}, {"org.eclipse.debug.core", "/"}, {"org.eclipse.stardust.ide.thirdparty.runtime.xml", "lib/commons-jxpath.jar"}, {"org.eclipse.stardust.ide.thirdparty.runtime.xml", "lib/xercesImpl.jar"}, {"org.eclipse.stardust.ide.thirdparty.cxf", "lib/cxf-api.jar"}, {"org.eclipse.stardust.ide.thirdparty.runtime.j2ee", "lib/geronimo-ejb_2.1_spec.jar"}, {"org.eclipse.stardust.ide.thirdparty.runtime.j2ee", "lib/geronimo-jms_1.1_spec.jar"}, {"org.eclipse.stardust.ide.engine.core", "lib/carnot-engine.jar"}, {"org.eclipse.stardust.ide.engine.core", "lib/carnot-emf-xsd-integration.jar"}, {"org.eclipse.stardust.modeling.integration.webservices", "lib/stardust-engine-ws-cxf.jar"}, {"org.eclipse.stardust.ide.engine.core", "etc"}, {"org.eclipse.stardust.modeling.debug", ".eclipse/bin", "/"}};

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        return this.resolveEntry(entry);
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        return this.resolveEntry(entry);
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
        return null;
    }

    private IRuntimeClasspathEntry[] resolveEntry(IRuntimeClasspathEntry entry) throws CoreException {
        LinkedHashSet result = new LinkedHashSet();
        int i = 0;
        while (i < carnot_libs.length) {
            this.addCarnotDependencies(result, carnot_libs[i]);
            ++i;
        }
        return result.toArray(new IRuntimeClasspathEntry[result.size()]);
    }

    private void addCarnotDependencies(Set files, String[] elements) throws CoreException {
        Bundle bundle = Platform.getBundle((String)elements[0]);
        if (bundle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.debug", 0, MessageFormat.format(Debug_Messages.EXP_BundleHasNotBeenLoadedYet, elements[0]), null));
        }
        IPath systemPath = null;
        int idx = 1;
        while (idx < elements.length) {
            URL entryUrl = bundle.getEntry(elements[idx]);
            if (entryUrl != null) {
                try {
                    systemPath = Path.fromOSString((String)Platform.asLocalURL((URL)entryUrl).getPath());
                    break;
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.debug", 0, Debug_Messages.EXP_ErrorWhileExtendingBootpath, (Throwable)e));
                }
            }
            ++idx;
        }
        if (systemPath == null) {
            Iterator<String> elementsIterator = Arrays.asList(elements).iterator();
            elementsIterator.next();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.debug", 0, MessageFormat.format(Debug_Messages.EXP_BundleDoesNotContain, elements[0], StringUtils.join(elementsIterator, (String)", ")), null));
        }
        files.add(JavaRuntime.newArchiveRuntimeClasspathEntry(systemPath));
    }
}

