/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching.ui;

import java.text.MessageFormat;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.highlighting.HighlightManager;
import org.eclipse.stardust.modeling.debug.model.CWMStackFrame;
import org.eclipse.stardust.modeling.debug.util.WorkflowModelUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class CWMModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private boolean containsActivitySymbol(DiagramType diagram, ActivityType activity) {
        if (diagram != null && activity != null) {
            List<ActivitySymbolType> activitySymbols = WorkflowModelUtils.getActivitySymbols(diagram, activity);
            for (ActivitySymbolType symbol : activitySymbols) {
                if (!symbol.getActivity().equals(activity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean showDiagramContainingActivity(WorkflowModelEditor editor, ActivityType activity) throws PartInitException {
        boolean found = this.containsActivitySymbol(editor.getActiveDiagram(), activity);
        if (!found) {
            List diagrams = editor.getOpenedDiagrams();
            for (DiagramType diagram : diagrams) {
                if (editor.isActiveDiagram(diagram) || !(found = this.containsActivitySymbol(diagram, activity))) continue;
                editor.showDiagramPage(diagram);
                break;
            }
        }
        if (!found) {
            ProcessDefinitionType processdefinition = (ProcessDefinitionType)activity.eContainer();
            EList allDiagrams = processdefinition.getDiagram();
            for (DiagramType diagram : allDiagrams) {
                if (editor.getOpenedDiagrams().contains(diagram) || !(found = this.containsActivitySymbol(diagram, activity))) continue;
                editor.showDiagramPage(diagram);
                break;
            }
        }
        return found;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        block8: {
            CWMStackFrame stackFrame = (CWMStackFrame)frame;
            final ActivityInstanceDigest ai = stackFrame.getActivityInstance();
            try {
                if (ai == null) break block8;
                WorkflowModelEditor editor = (WorkflowModelEditor)editorPart;
                ModelType model = editor.getWorkflowModel();
                QName qproc = QName.valueOf(ai.getProcessDefinitionId());
                String namespace = qproc.getNamespaceURI();
                if (!namespace.equals(model.getId())) {
                    editor = UiAccessor.getEditorForModel(CollectionUtils.newSet(), model, namespace);
                    if (editor == null) {
                        throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, namespace));
                    }
                    model = editor.getWorkflowModel();
                }
                ProcessDefinitionType processDefinition = WorkflowModelUtils.findProcessDefinition(model, qproc.getLocalPart());
                QName qact = QName.valueOf(ai.getActivityId());
                if (!qact.getNamespaceURI().equals(model.getId())) {
                    throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, qact.getNamespaceURI()));
                }
                ActivityType activity = WorkflowModelUtils.findActivity(processDefinition, qact.getLocalPart());
                boolean found = this.showDiagramContainingActivity(editor, activity);
                if (found) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HighlightManager.getDefault().setCurrentSelected(ai);
                        }
                    }).start();
                    EditPart editPart = null;
                    EList symbols = activity.getActivitySymbols();
                    for (ActivitySymbolType symbol : symbols) {
                        editPart = editor.findEditPart((Object)symbol);
                        if (editPart == null) continue;
                        editPart.getParent().getViewer().reveal(editPart);
                        break;
                    }
                } else {
                    throw new RuntimeException(MessageFormat.format(Debug_Messages.MSG_NoSymbolFoundForActivity, activity));
                }
                return found;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        System.out.println(Debug_Messages.MSG_RemoveAnnotations);
    }

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile) {
            return "org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor";
        }
        return null;
    }
}

