/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.engine.api.runtime.DeploymentElement;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;

public class RuntimeUtil {
    public static List<DeploymentElement> createDeploymentElements(List<File> modelFiles) throws IOException {
        List units = CollectionUtils.newList((int)modelFiles.size());
        for (File file : modelFiles) {
            units.add(RuntimeUtil.createDeploymentElement(file));
        }
        return units;
    }

    public static DeploymentElement createDeploymentElement(File file) throws IOException {
        byte[] content = XmlUtils.getContent((File)file);
        if (!file.getName().endsWith("xpdl")) {
            if (ParametersFacade.instance().getBoolean("Carnot.Engine.Deployment.XPDL", true)) {
                String encoding = (String)Parameters.instance().getObject("carnot.engine.xml.encoding", (Object)"ISO-8859-1");
                content = XpdlUtils.convertCarnot2Xpdl((byte[])content, (String)encoding);
            }
        } else if (!ParametersFacade.instance().getBoolean("Carnot.Engine.Deployment.XPDL", true)) {
            String encoding = (String)Parameters.instance().getObject("carnot.engine.xml.encoding", (Object)"ISO-8859-1");
            content = XpdlUtils.convertXpdl2Carnot((byte[])content, (String)encoding);
        }
        return new DeploymentElement(content);
    }
}

