/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30.entity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class MyASTVisitor
extends ASTVisitor {
    private TypeInfo type;
    private ASTNode node;
    private TypeDeclaration result;
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public MyASTVisitor(TypeInfo type) {
        this.type = type;
    }

    public MyASTVisitor(TypeInfo type, ASTNode node) {
        this.type = type;
        this.node = node;
    }

    private TypeDeclaration getTypeDeclaration() {
        return this.result;
    }

    private List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean visit(TypeDeclaration node) {
        String nodeName = node.getName().getFullyQualifiedName();
        if (this.type != null && this.type.isSameType(nodeName)) {
            this.result = node;
        }
        return super.visit(node);
    }

    public boolean visit(MarkerAnnotation node) {
        if (node.getParent().equals((Object)this.node)) {
            this.annotations.add((Annotation)node);
        }
        return super.visit(node);
    }

    public boolean visit(NormalAnnotation node) {
        if (node.getParent().equals((Object)this.node)) {
            this.annotations.add((Annotation)node);
        }
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (node.getParent().equals((Object)this.node)) {
            this.annotations.add((Annotation)node);
        }
        return super.visit(node);
    }

    public static TypeDeclaration findTypeDeclaration(TypeInfo type) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(type.getType().getCompilationUnit());
        ASTNode node = parser.createAST(null);
        MyASTVisitor visitor = new MyASTVisitor(type);
        node.accept((ASTVisitor)visitor);
        return visitor.getTypeDeclaration();
    }

    public static List<Annotation> getAnnotations(TypeInfo type, ASTNode node) {
        MyASTVisitor visitor = new MyASTVisitor(type, node);
        node.accept((ASTVisitor)visitor);
        return visitor.getAnnotations();
    }

    public static Annotation getAnnotation(TypeInfo type, ASTNode node, Class<?> targetClass) {
        List<Annotation> annotations = MyASTVisitor.getAnnotations(type, node);
        for (Annotation annotation : annotations) {
            String annotationType = annotation.getTypeName().toString();
            try {
                if (!targetClass.getName().equals(type.resolve(annotationType))) continue;
                return annotation;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

