/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.javascript;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.runtime.ActivityInstance;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.CodeCompletionHelper;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML.PlainXMLAccessPointType;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.javascript.JSArrayReference;
import org.eclipse.stardust.modeling.javascript.JSAssignment;
import org.eclipse.stardust.modeling.javascript.JSClassLoader;
import org.eclipse.stardust.modeling.javascript.JSCompletionOnMemberAccess;
import org.eclipse.stardust.modeling.javascript.JSFieldReference;
import org.eclipse.stardust.modeling.validation.util.FieldInfo;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ast.IASTNode;
import org.eclipse.wst.jsdt.core.ast.IArrayReference;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IBinaryExpression;
import org.eclipse.wst.jsdt.core.ast.IBlock;
import org.eclipse.wst.jsdt.core.ast.IEqualExpression;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class JavaScriptInferenceEngine
extends InferEngine {
    private static final char[] NAME_IPP_INITIALIZE = "ippInitialize".toCharArray();
    private static final char[] NAME_IPP_IMPORT = "ippImport".toCharArray();
    private CompilationUnitDeclaration cu;
    private ModelType model;
    private TypeFinder typeFinder;
    private Map<String, ITypedElement> inferredIppVariables;
    private Map<String, ITypedElement> inferredIppAccessPointsByName;
    private Map<String, ITypedElement> inferredIppAccessPointsByType;
    private Map<String, Map<String, InferredType>> inferredVariables;
    private Map<InferredAttribute, ITypedElement> bpmAttributesToAp;
    private Map<String, String> xPathToJavaType;
    private Map<String, String> xPathToRealJavaType;
    private Map<String, String> xPathToJavaField;
    private Map<InferredAttribute, String> bpmAttributesToXPath;
    private Map arrayMap = new HashMap();

    public synchronized boolean visit(IFunctionCall functionCall) {
        MessageSend messageSend = null;
        if (functionCall instanceof MessageSend) {
            messageSend = (MessageSend)functionCall;
        }
        if (messageSend != null) {
            if (messageSend.arguments != null) {
                int i = 0;
                while (i < messageSend.arguments.length) {
                    if (messageSend.arguments[i] instanceof CompletionOnMemberAccess && !(messageSend.arguments[i] instanceof JSCompletionOnMemberAccess)) {
                        messageSend.arguments[i] = this.buildCompletionOnMemberAccess(messageSend.arguments[i]);
                    }
                    ++i;
                }
            }
            if (messageSend.receiver instanceof ArrayReference && !(messageSend.receiver instanceof JSArrayReference)) {
                messageSend.receiver = this.buildArrayReference(messageSend.receiver);
            } else if (messageSend.receiver instanceof FieldReference && !(messageSend.receiver instanceof JSFieldReference)) {
                messageSend.receiver = this.buildFieldReference(messageSend.receiver);
            }
        }
        return super.visit(functionCall);
    }

    public synchronized void initialize() {
        super.initialize();
        this.model = null;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IEditorPart currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (currentEditor instanceof WorkflowModelEditor) {
                this.model = ((WorkflowModelEditor)currentEditor).getWorkflowModel();
            }
        } else {
            int i = 0;
            while (i < PlatformUI.getWorkbench().getWorkbenchWindows().length) {
                IEditorPart activeEditor;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[i];
                if (window.getActivePage() != null && (activeEditor = window.getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
                    this.model = ((WorkflowModelEditor)activeEditor).getWorkflowModel();
                    break;
                }
                ++i;
            }
        }
        if (this.typeFinder == null) {
            this.typeFinder = new TypeFinder((EObject)this.model);
        }
        this.inferredIppVariables = CollectionUtils.newMap();
        this.inferredIppAccessPointsByName = CollectionUtils.newMap();
        this.inferredIppAccessPointsByType = CollectionUtils.newMap();
        this.inferredVariables = CollectionUtils.newMap();
        this.bpmAttributesToAp = CollectionUtils.newMap();
        this.bpmAttributesToXPath = CollectionUtils.newMap();
        this.xPathToJavaType = CollectionUtils.newMap();
        this.xPathToRealJavaType = CollectionUtils.newMap();
        this.xPathToJavaField = CollectionUtils.newMap();
    }

    public synchronized void setCompilationUnit(CompilationUnitDeclaration compilationUnit) {
        super.setCompilationUnit(compilationUnit);
        this.cu = compilationUnit;
    }

    public synchronized boolean visit(IFieldReference iFieldReference) {
        FieldReference fieldReference = null;
        if (iFieldReference instanceof FieldReference) {
            fieldReference = (FieldReference)iFieldReference;
        }
        try {
            if (fieldReference.receiver instanceof ArrayReference && !(fieldReference.receiver instanceof JSArrayReference)) {
                fieldReference.receiver = this.buildArrayReference(fieldReference.receiver);
            } else if (fieldReference.receiver instanceof FieldReference && !(fieldReference.receiver instanceof JSFieldReference)) {
                fieldReference.receiver = this.buildFieldReference(fieldReference.receiver);
            }
            ProgramElement[] pe = this.cu.statements;
            int i = 0;
            while (i < pe.length) {
                if (!(pe[i] instanceof JSAssignment)) {
                    if (pe[i] instanceof Assignment) {
                        pe[i] = this.buildAssignment((Assignment)pe[i]);
                    } else if (pe[i] instanceof CompletionOnMemberAccess && !(pe[i] instanceof JSCompletionOnMemberAccess)) {
                        pe[i] = this.buildCompletionOnMemberAccess((Expression)pe[i]);
                    } else if (pe[i] instanceof FieldReference && !(pe[i] instanceof JSFieldReference) && !(pe[i] instanceof JSCompletionOnMemberAccess)) {
                        pe[i] = this.buildFieldReference((Expression)pe[i]);
                    }
                }
                ++i;
            }
            ITypedElement data = this.findAccessPointFromDereferentiation((Reference)fieldReference);
            if (data != null) {
                String xPath = this.findXPathFromDereferentiation(fieldReference);
                Map<String, InferredType> inferredDerefPaths = this.inferredVariables.get(((IIdentifiableElement)data).getId());
                if (inferredDerefPaths != null && !inferredDerefPaths.containsKey(xPath)) {
                    Stack<String> xPaths = new Stack<String>();
                    xPaths.push(xPath);
                    while (!xPaths.contains(xPath = this.findParentXPath(xPath))) {
                        xPaths.push(xPath);
                        if (!inferredDerefPaths.containsKey(xPath)) continue;
                    }
                    do {
                        String useClassName;
                        InferredType attrType;
                        if ((attrType = inferredDerefPaths.get(xPath = (String)xPaths.pop())) != null) continue;
                        boolean isJavaType = false;
                        String className = null;
                        boolean isXMLType = false;
                        if (data instanceof DataType) {
                            String type;
                            if (((DataType)data).getType().getId().equals("primitive")) {
                                type = AttributeUtil.getAttributeValue((IExtensibleElement)((DataType)data), (String)"carnot:engine:type");
                                attrType = this.getInferredTypeFromJavaType(type, xPath, null);
                            } else if (GenericUtils.isStructuredDataType((DataType)((DataType)data)) || GenericUtils.isDMSDataType((DataType)((DataType)data)) || GenericUtils.isXMLDataType((DataType)((DataType)data))) {
                                isXMLType = true;
                            } else {
                                type = GenericUtils.getReferenceClassName((DataType)((DataType)data));
                                attrType = this.getInferredTypeFromJavaType(type, xPath, null);
                                if (attrType == null) {
                                    isJavaType = true;
                                    className = GenericUtils.getReferenceClassName((DataType)((DataType)data));
                                    attrType = this.addType(className.toCharArray());
                                    attrType.isDefinition = true;
                                    attrType.isAnonymous = false;
                                }
                            }
                        }
                        if (attrType == null) {
                            attrType = "/".equals(xPath) ? this.addType(((IIdentifiableElement)data).getId().toCharArray()) : this.addType((String.valueOf(((IIdentifiableElement)data).getId()) + "_" + xPath.replace('/', '_')).toCharArray());
                            attrType.isDefinition = true;
                            attrType.isAnonymous = true;
                            isXMLType = true;
                        }
                        inferredDerefPaths.put(xPath, attrType);
                        IAccessPathEditor apEditor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)((DataTypeType)data.getMetaType()));
                        if (isXMLType) {
                            List apAttributes;
                            if ("/".equals(xPath)) {
                                apAttributes = apEditor.getAccessPoints(null, (IExtensibleElement)data, DirectionType.INOUT_LITERAL);
                            } else {
                                int idx = xPath.lastIndexOf("/") + 1;
                                String elementName = xPath.substring(idx, xPath.length());
                                ITypedElement accessPointType = this.inferredIppAccessPointsByName.get(elementName);
                                apAttributes = apEditor.getAccessPoints(null, (IExtensibleElement)accessPointType, DirectionType.INOUT_LITERAL);
                            }
                            List<XSDEnumerationFacet> enums = this.checkEnumeration(data);
                            if (enums != null) {
                                this.addEnumsTo(attrType, xPath, enums);
                            }
                            int i2 = 0;
                            while (i2 < apAttributes.size()) {
                                AccessPointType apAttribute = (AccessPointType)apAttributes.get(i2);
                                String attrName = apAttribute.getId();
                                boolean isAtAttribute = false;
                                if (attrName.startsWith("@")) {
                                    attrName = attrName.replace("@", "");
                                    isAtAttribute = true;
                                }
                                InferredAttribute ia = attrType.addAttribute(attrName.toCharArray(), (IASTNode)this.cu, 0);
                                if (isAtAttribute) {
                                    this.addContentMethodsTo(attrType);
                                }
                                boolean isArray = false;
                                if (apAttribute.getType().getId().startsWith("prim")) {
                                    if (apAttribute instanceof StructAccessPointType) {
                                        isArray = AttributeUtil.getBooleanValue((IExtensibleElement)apAttribute, (String)"carnot:engine:data:indexed");
                                        if (isArray) {
                                            if (apAttribute instanceof StructAccessPointType) {
                                                this.arrayMap.put(((StructAccessPointType)apAttribute).getXPath().toString(), "true");
                                                ia.type = this.getInferredTypeFromXPath(((StructAccessPointType)apAttribute).getXPath());
                                            } else {
                                                this.arrayMap.put(apAttribute.getId(), "true");
                                            }
                                        } else {
                                            ia.type = this.getInferredTypeFromXPath(((StructAccessPointType)apAttribute).getXPath());
                                        }
                                    } else if (apAttribute instanceof PlainXMLAccessPointType) {
                                        isArray = AttributeUtil.getBooleanValue((IExtensibleElement)apAttribute, (String)"carnot:engine:data:indexed");
                                        if (isArray) {
                                            if (apAttribute instanceof StructAccessPointType) {
                                                this.arrayMap.put(((StructAccessPointType)apAttribute).getXPath().toString(), "true");
                                            } else {
                                                this.arrayMap.put(apAttribute.getId(), "true");
                                            }
                                        } else {
                                            ia.type = this.getInferredTypeFromXPath(((PlainXMLAccessPointType)apAttribute).getXPath());
                                        }
                                    }
                                } else {
                                    isArray = AttributeUtil.getBooleanValue((IExtensibleElement)apAttribute, (String)"carnot:engine:data:indexed");
                                    if (isArray) {
                                        if (apAttribute instanceof StructAccessPointType) {
                                            this.arrayMap.put(((StructAccessPointType)apAttribute).getXPath().toString(), "true");
                                        } else {
                                            this.arrayMap.put(apAttribute.getId(), "true");
                                        }
                                    }
                                }
                                this.bpmAttributesToAp.put(ia, data);
                                if ("/".equals(xPath)) {
                                    this.bpmAttributesToXPath.put(ia, "/" + apAttribute.getId());
                                } else {
                                    this.bpmAttributesToXPath.put(ia, String.valueOf(xPath) + "/" + apAttribute.getId());
                                }
                                this.inferredIppAccessPointsByName.put(apAttribute.getId(), (ITypedElement)apAttribute);
                                ++i2;
                            }
                        }
                        if (!isJavaType) continue;
                        InferredType myType = null;
                        if (!"/".equals(xPath) && !StringUtils.isEmpty((String)(useClassName = this.xPathToJavaType.get(xPath)))) {
                            className = useClassName;
                            myType = this.getInferredTypeFromJavaType(className, xPath, null);
                            if (myType == null) {
                                myType = this.addType(className.toCharArray());
                                myType.isDefinition = true;
                                myType.isAnonymous = false;
                            }
                            inferredDerefPaths.put(xPath, myType);
                        }
                        if (!"/".equals(xPath) && myType == null && !StringUtils.isEmpty((String)(useClassName = this.xPathToJavaField.get(xPath)))) {
                            className = useClassName;
                            myType = this.getInferredTypeFromJavaType(className, xPath, null);
                            if (myType == null) {
                                myType = this.addType(className.toCharArray());
                                myType.isDefinition = true;
                                myType.isAnonymous = false;
                            }
                            inferredDerefPaths.put(xPath, myType);
                        }
                        if (myType == null) {
                            myType = attrType;
                        }
                        if (className == null) continue;
                        this.inferreJavaFields(xPath, myType, className);
                        this.inferreJavaMethods(xPath, myType, className);
                    } while (!xPaths.isEmpty());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return super.visit((IFieldReference)fieldReference);
    }

    private void inferreJavaMethods(String xPath, InferredType attrType, String className) throws JavaModelException {
        TypeInfo typeInfo = null;
        typeInfo = className.startsWith("java.util.List_") ? this.typeFinder.findType("java.util.List") : this.typeFinder.findType(className);
        if (typeInfo != null) {
            MethodInfo mi;
            String[] parameterSignatures = new String[]{};
            String[] parameterTypes = new String[]{};
            List methods = typeInfo.getMethods();
            if (className.endsWith("ActivityInstance")) {
                mi = new MethodInfo(false, "getAge", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
            }
            if (className.endsWith("Activity")) {
                mi = new MethodInfo(false, "getMeasure", parameterSignatures, parameterTypes, "Ljava.lang.String;", "java.lang.String", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetMeasureQuantity", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getDifficulty", parameterSignatures, parameterTypes, "I", "int", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetProcessingTime", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetIdleTime", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetWaitingTime", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetQueueDepth", parameterSignatures, parameterTypes, "J", "long", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetCostPerExecution", parameterSignatures, parameterTypes, "D", "double", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getTargetCostPerSecond", parameterSignatures, parameterTypes, "D", "double", true);
                methods.add(mi);
                mi = new MethodInfo(false, "getResourcePerformanceCalculation", parameterSignatures, parameterTypes, "B", "boolean", true);
                methods.add(mi);
            }
            int m = 0;
            while (m < methods.size()) {
                MethodInfo methodInfo = (MethodInfo)methods.get(m);
                String methodName = this.getMethodName(methodInfo);
                if (!methodName.startsWith("<") && methodInfo.isAccessible()) {
                    MethodDeclaration md = new MethodDeclaration(this.cu.compilationResult);
                    attrType.addMethod(methodName.toCharArray(), (IFunctionDeclaration)md, 0);
                    String returnType = methodInfo.getReturnType();
                    String xPathForJava = "/".equals(xPath) ? String.valueOf(xPath) + methodName : String.valueOf(xPath) + "/" + methodName;
                    if (returnType.startsWith("java.util.List<")) {
                        String realType = returnType.replaceAll("java.util.List", "");
                        realType = realType.replaceAll("<", "");
                        realType = realType.replaceAll(">", "");
                        returnType = "java.util.List_" + realType;
                        this.xPathToRealJavaType.put(xPathForJava, realType);
                    }
                    if (this.xPathToRealJavaType.get(xPath) != null) {
                        returnType = this.xPathToRealJavaType.get(xPath);
                    }
                    this.xPathToJavaType.put(xPathForJava, returnType);
                    int paramCnt = methodInfo.getParameterCount();
                    InferredType iType = this.getInferredTypeFromJavaType(returnType, xPathForJava, className);
                    if (iType == null) {
                        iType = this.addType(returnType.toCharArray());
                        iType.isDefinition = true;
                        iType.isAnonymous = true;
                    }
                    SingleTypeReference sRef = new SingleTypeReference(iType.getName(), 0L);
                    sRef.resolvedType = null;
                    md.returnType = sRef;
                    md.inferredType = iType;
                    if (paramCnt > 0) {
                        md.arguments = new Argument[paramCnt];
                    }
                    int p = 0;
                    while (p < paramCnt) {
                        md.arguments[p] = new Argument(new String("param" + p).toCharArray(), 0L, null, 0);
                        ++p;
                    }
                }
                ++m;
            }
        }
    }

    private void inferreJavaFields(String xPath, InferredType attrType, String className) throws JavaModelException {
        TypeInfo typeInfo = this.typeFinder.findType(className);
        if (typeInfo != null) {
            List fields = typeInfo.getFields();
            int f = 0;
            while (f < fields.size()) {
                FieldInfo fieldInfo = (FieldInfo)fields.get(f);
                if (fieldInfo.isPublic() || fieldInfo.isEnum()) {
                    String fieldName = fieldInfo.getFieldName();
                    String fieldType = fieldInfo.getFieldType();
                    InferredAttribute iAttribute = attrType.addAttribute(fieldName.toCharArray(), (IASTNode)this.cu, 0);
                    String xPathForJavaField = "/".equals(xPath) ? String.valueOf(xPath) + fieldName : String.valueOf(xPath) + "/" + fieldName;
                    this.xPathToJavaField.put(xPathForJavaField, fieldName);
                    InferredType iType = this.getInferredTypeFromJavaType(fieldType, xPath, null);
                    if (iType == null) {
                        iType = this.addType(fieldType.toCharArray());
                        iType.isDefinition = true;
                        iType.isAnonymous = true;
                    }
                    iAttribute.type = iType;
                }
                ++f;
            }
        }
    }

    private void addGetTargetExecutionTimeTo(InferredType attrType) {
        MethodDeclaration md = new MethodDeclaration(this.cu.compilationResult);
        attrType.addMethod("getTargetExecutionTime".toCharArray(), (IFunctionDeclaration)md, 0);
        InferredType iType = this.StringType;
        md.returnType = new SingleTypeReference(iType.getName(), 0L);
        md.inferredType = iType;
    }

    private void addContentMethodsTo(InferredType attrType) {
        MethodDeclaration md = new MethodDeclaration(this.cu.compilationResult);
        attrType.addMethod("getContent".toCharArray(), (IFunctionDeclaration)md, 0);
        String returnType = "String";
        InferredType iType = this.StringType;
        md.returnType = new SingleTypeReference(iType.getName(), 0L);
        md.inferredType = iType;
        md = new MethodDeclaration(this.cu.compilationResult);
        attrType.addMethod("setContent".toCharArray(), (IFunctionDeclaration)md, 0);
        returnType = "void";
        iType = this.getInferredTypeFromJavaType(returnType, null, null);
        if (iType == null) {
            iType = this.addType(returnType.toCharArray());
            iType.isDefinition = true;
            iType.isAnonymous = true;
        }
        md.returnType = new SingleTypeReference(iType.getName(), 0L);
        md.arguments = new Argument[1];
        md.arguments[0] = new Argument(new String("param0").toCharArray(), 0L, null, 0);
    }

    private void addEnumsTo(InferredType attrType, String xPath, List<XSDEnumerationFacet> enums) {
        for (XSDEnumerationFacet facet : enums) {
            String fieldName = facet.getLexicalValue();
            InferredAttribute iAttribute = attrType.addAttribute(fieldName.toCharArray(), (IASTNode)this.cu, 0);
            String xPathForJavaField = "/".equals(xPath) ? String.valueOf(xPath) + fieldName : String.valueOf(xPath) + "/" + fieldName;
            this.xPathToJavaField.put(xPathForJavaField, fieldName);
            InferredType iType = this.getInferredTypeFromJavaType(Type.String.getId(), xPath, null);
            if (iType == null) {
                iType = this.addType(Type.String.getId().toCharArray());
                iType.isDefinition = true;
                iType.isAnonymous = true;
            }
            iAttribute.type = iType;
        }
    }

    public synchronized boolean visit(InferredAttribute inferredAttr) {
        Map<String, InferredType> inferredDerefPaths;
        InferredType attrType;
        ITypedElement data;
        String xPath;
        boolean result = super.visit(inferredAttr);
        if (inferredAttr.type == null && (xPath = this.bpmAttributesToXPath.get(inferredAttr)) != null && (data = this.bpmAttributesToAp.get(inferredAttr)) != null && (attrType = (inferredDerefPaths = this.inferredVariables.get(((IIdentifiableElement)data).getId())).get(xPath)) != null) {
            inferredAttr.type = attrType;
        }
        return result;
    }

    public synchronized void endVisit(ILocalDeclaration localDeclaration) {
        super.endVisit(localDeclaration);
        try {
            this.endVisitImpl(localDeclaration);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean visit(ILocalDeclaration localDeclaration) {
        boolean result = super.visit(localDeclaration);
        localDeclaration.setInferredType(null);
        IExpression expr = localDeclaration.getInitialization();
        if (expr instanceof CompletionOnMemberAccess) {
            expr = this.buildCompletionOnMemberAccess((Expression)expr);
        }
        ((LocalDeclaration)localDeclaration).initialization = (Expression)expr;
        return result;
    }

    protected synchronized void endVisitImpl(ILocalDeclaration localDeclaration) {
        block17: {
            try {
                Expression typeArgument;
                String name = new String(localDeclaration.getName());
                if (localDeclaration.getInferredType() != null || !(localDeclaration.getInitialization() instanceof MessageSend)) break block17;
                MessageSend initializer = (MessageSend)localDeclaration.getInitialization();
                if (!Arrays.equals(NAME_IPP_INITIALIZE, initializer.selector) || 1 != initializer.arguments.length || !((typeArgument = initializer.arguments[0]) instanceof StringLiteral)) break block17;
                String targetTypeName = String.valueOf(((StringLiteral)typeArgument).source());
                ITypedElement accessPoint = this.inferredIppAccessPointsByType.get(targetTypeName);
                DataType dataType = null;
                if (accessPoint == null && this.model != null) {
                    DataTypeType serializableDataType;
                    if (targetTypeName.indexOf(".") > -1) {
                        DataType serializableType = CarnotWorkflowModelFactory.eINSTANCE.createDataType();
                        serializableType.setId(name);
                        serializableType.setName(name);
                        serializableType.setPredefined(true);
                        serializableDataType = (DataTypeType)ModelUtils.findElementById((List)this.model.getDataType(), (String)"serializable");
                        try {
                            Reflect.setFieldValue((Object)serializableType, (String)"type", (Object)serializableDataType);
                        }
                        catch (Throwable throwable) {
                            serializableType.setType(serializableDataType);
                        }
                        AttributeUtil.setAttribute((IExtensibleElement)serializableType, (String)"carnot:engine:browsable", (String)"true");
                        AttributeUtil.setAttribute((IExtensibleElement)serializableType, (String)"carnot:engine:className", (String)targetTypeName);
                        dataType = serializableType;
                    } else if ("activityInstance".equals(name)) {
                        DataType activityInstance = CarnotWorkflowModelFactory.eINSTANCE.createDataType();
                        activityInstance.setId("activityInstance");
                        activityInstance.setName("Activity Instance");
                        activityInstance.setPredefined(true);
                        serializableDataType = (DataTypeType)ModelUtils.findElementById((List)this.model.getDataType(), (String)"serializable");
                        try {
                            Reflect.setFieldValue((Object)activityInstance, (String)"type", (Object)serializableDataType);
                        }
                        catch (Throwable throwable) {
                            activityInstance.setType(serializableDataType);
                        }
                        AttributeUtil.setAttribute((IExtensibleElement)activityInstance, (String)"carnot:engine:browsable", (String)"true");
                        AttributeUtil.setAttribute((IExtensibleElement)activityInstance, (String)"carnot:engine:className", (String)ActivityInstance.class.getName());
                        dataType = activityInstance;
                    } else {
                        dataType = (DataType)ModelUtils.findIdentifiableElement((List)this.model.getData(), (String)name);
                        CodeCompletionHelper.getInstance().getTypeMap().put(name, dataType);
                    }
                    if (dataType != null) {
                        accessPoint = dataType;
                    } else {
                        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((ModelType)this.model, (String)targetTypeName);
                        accessPoint = new StructAccessPointType(xPathMap.getRootXPath(), xPathMap);
                        ((StructAccessPointType)accessPoint).setId(targetTypeName);
                        ((StructAccessPointType)accessPoint).setType((DataTypeType)ModelUtils.findIdentifiableElement((List)this.model.getDataType(), (String)"struct"));
                    }
                    this.inferredIppAccessPointsByType.put(targetTypeName, accessPoint);
                }
                if (accessPoint != null) {
                    String variableName = String.valueOf(localDeclaration.getName());
                    CodeCompletionHelper.getInstance().getTypeMap().put(variableName, accessPoint);
                    Map derefPaths = this.inferredVariables.get(((IIdentifiableElement)accessPoint).getId());
                    if (derefPaths == null) {
                        InferredType iType;
                        String javaType;
                        InferredType apType = this.addType(targetTypeName.toCharArray());
                        apType.isDefinition = true;
                        derefPaths = CollectionUtils.newMap();
                        this.inferredVariables.put(((IIdentifiableElement)accessPoint).getId(), derefPaths);
                        if (dataType != null && dataType instanceof DataType && !GenericUtils.isStructuredDataType((DataType)dataType) && !GenericUtils.isDMSDataType((DataType)dataType) && !GenericUtils.isXMLDataType((DataType)dataType) && (javaType = GenericUtils.getReferenceClassName((DataType)dataType)) != null && (iType = this.getInferredTypeFromJavaType(javaType, null, null)) != null) {
                            localDeclaration.setInferredType(iType);
                        }
                    } else {
                        localDeclaration.setInferredType(derefPaths.get("/"));
                    }
                    this.inferredIppVariables.put(String.valueOf(localDeclaration.getName()), accessPoint);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private synchronized ITypedElement findAccessPointFromDereferentiation(Reference reference) {
        ITypedElement result = null;
        Reference receiver = reference;
        do {
            if (receiver instanceof FieldReference) {
                receiver = ((FieldReference)receiver).receiver;
                continue;
            }
            if (receiver instanceof ArrayReference) {
                receiver = ((ArrayReference)receiver).receiver;
                continue;
            }
            if (!(receiver instanceof MessageSend)) continue;
            receiver = ((MessageSend)receiver).receiver;
        } while (receiver instanceof FieldReference || receiver instanceof ArrayReference || receiver instanceof MessageSend);
        if (this.model != null && receiver instanceof SingleNameReference) {
            String accessPointId = String.valueOf(((SingleNameReference)receiver).token);
            result = this.inferredIppVariables.get(accessPointId);
        }
        return result;
    }

    public synchronized void doInfer() {
        try {
            super.doInfer();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private synchronized String findXPathFromDereferentiation(FieldReference fieldReference) {
        FieldReference saveFieldReference = fieldReference;
        Stack<String> stack = new Stack<String>();
        StringBuffer xPath = new StringBuffer();
        FieldReference receiver = fieldReference;
        do {
            if (receiver instanceof FieldReference) {
                receiver = receiver.receiver;
                continue;
            }
            if (receiver instanceof ArrayReference) {
                receiver = ((ArrayReference)receiver).receiver;
                continue;
            }
            if (receiver instanceof MessageSend) {
                String selector = String.valueOf(((MessageSend)receiver).selector);
                stack.push(selector);
                receiver = ((MessageSend)receiver).receiver;
                continue;
            }
            if (receiver instanceof SingleNameReference) break;
        } while (receiver instanceof FieldReference || receiver instanceof ArrayReference || receiver instanceof MessageSend || receiver instanceof SingleNameReference);
        while (!stack.isEmpty()) {
            String entry = (String)stack.pop();
            if (xPath.length() == 0) {
                xPath.insert(0, "/");
                xPath.append(entry);
                continue;
            }
            xPath.append("/");
            xPath.append(entry);
        }
        if (xPath.length() != 0) {
            return xPath.toString();
        }
        xPath = new StringBuffer();
        receiver = saveFieldReference;
        do {
            if (receiver instanceof FieldReference) {
                xPath.insert(0, String.valueOf(receiver.token));
                xPath.insert(0, "/");
                receiver = receiver.receiver;
                continue;
            }
            if (!(receiver instanceof ArrayReference)) continue;
            receiver = ((ArrayReference)receiver).receiver;
        } while (receiver instanceof FieldReference || receiver instanceof ArrayReference);
        return xPath.length() > 0 ? xPath.toString() : "/";
    }

    private synchronized String findParentXPath(String xPath) {
        int posSeparator = xPath.lastIndexOf("/");
        if (posSeparator > 0) {
            return xPath.substring(0, posSeparator);
        }
        return "/";
    }

    private synchronized InferredType getInferredTypeFromJavaType(String type, String xPath, String className) {
        InferredType inferredType = null;
        if (type.equals(Type.Calendar.getId()) || type.equals(Type.Timestamp.getId())) {
            inferredType = this.addType("Date".toCharArray());
        }
        if (type.equals(Type.String.getId()) || type.equals(Type.Char.getId()) || type.equals(String.class.getName()) || type.equals(Character.class.getName())) {
            inferredType = this.StringType;
        } else if (type.equals(Type.Double.getId()) || type.equals(Type.Float.getId()) || type.equals(Type.Integer.getId()) || type.equals(Type.Long.getId()) || type.equals(Integer.class.getName()) || type.equals(BigInteger.class.getName()) || type.equals(Long.class.getName()) || type.equals(Short.class.getName()) || type.equals(BigDecimal.class.getName()) || type.equals(Float.class.getName()) || type.equals(Number.class.getName()) || type.equals(Double.class.getName()) || type.equals(Type.Byte.getId()) || type.equals(Byte.class.getName())) {
            inferredType = this.NumberType;
        } else if (type.equals(Type.Boolean.getId()) || type.equals(Boolean.class.getName())) {
            inferredType = this.BooleanType;
        } else if (type.equals("void") || type.equals(Void.class.getName())) {
            inferredType = this.VoidType;
        } else if (type.equals(Object.class.getName()) || type.equals("java.lang.Class<java.lang.Object>")) {
            inferredType = this.ObjectType;
        } else if (type.endsWith("[]") && className != null) {
            InferredType myType = null;
            String fullQualifiedName = this.getFullQualifiedName(type, className);
            if (fullQualifiedName != null) {
                fullQualifiedName = fullQualifiedName.replace("[]", "");
                if (xPath.startsWith("/")) {
                    xPath = xPath.substring(1, xPath.length());
                }
                this.arrayMap.put(xPath, "true");
                myType = this.addType(fullQualifiedName.toCharArray());
                myType.isDefinition = true;
                myType.isAnonymous = false;
                try {
                    this.inferreJavaFields(xPath.toString(), myType, fullQualifiedName);
                    this.inferreJavaMethods(xPath.toString(), myType, fullQualifiedName);
                }
                catch (JavaModelException javaModelException) {}
            } else {
                myType = this.ArrayType;
            }
            return myType;
        }
        return inferredType;
    }

    private String getFullQualifiedName(String type, String className) {
        Class<?> clazz;
        block5: {
            IJavaProject jp = JavaCore.create((IProject)ModelUtils.getProjectFromEObject((EObject)this.model));
            JSClassLoader cl = new JSClassLoader(jp);
            clazz = cl.loadClass(className);
            if (clazz != null) break block5;
            return null;
        }
        try {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (type.equalsIgnoreCase(field.getType().getSimpleName())) {
                    return field.getType().getCanonicalName();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    private synchronized InferredType getInferredTypeFromXPath(TypedXPath xPath) {
        int type = xPath.getType();
        if (type == 0) {
            return this.BooleanType;
        }
        if (type == 9) {
            InferredType myType = null;
            String className = "java.util.Date";
            myType = this.addType(className.toCharArray());
            myType.isDefinition = true;
            myType.isAnonymous = false;
            try {
                this.inferreJavaFields(xPath.toString(), myType, className);
                this.inferreJavaMethods(xPath.toString(), myType, className);
            }
            catch (JavaModelException javaModelException) {}
            return myType;
        }
        if (type == 2) {
            return this.NumberType;
        }
        if (type == 7) {
            return this.NumberType;
        }
        if (type == 6) {
            return this.NumberType;
        }
        if (type == 4) {
            return this.NumberType;
        }
        if (type == 5) {
            return this.NumberType;
        }
        if (type == 3) {
            return this.NumberType;
        }
        return this.StringType;
    }

    public synchronized String getMethodName(MethodInfo methodInfo) {
        return methodInfo.getLabel().substring(0, methodInfo.getLabel().indexOf("("));
    }

    private synchronized JSAssignment buildAssignment(Assignment assignment) {
        JSAssignment ass = new JSAssignment(assignment.lhs, assignment.expression, assignment.sourceEnd);
        ass.bits = assignment.bits;
        ass.constant = assignment.constant;
        ass.resolvedType = assignment.resolvedType;
        ass.sourceEnd = assignment.sourceEnd;
        ass.sourceStart = assignment.sourceStart;
        ass.statementEnd = assignment.statementEnd;
        return ass;
    }

    private synchronized Expression buildCompletionOnMemberAccess(Expression expression) {
        if (expression instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess fieldReference = (CompletionOnMemberAccess)expression;
            JSCompletionOnMemberAccess fr = new JSCompletionOnMemberAccess(fieldReference.token, fieldReference.nameSourcePosition, fieldReference.isInsideAnnotation);
            fr.binding = fieldReference.binding;
            fr.bits = fieldReference.bits;
            fr.constant = fieldReference.constant;
            fr.nameSourcePosition = fieldReference.nameSourcePosition;
            fr.receiver = fieldReference.receiver;
            fr.receiverType = fieldReference.receiverType;
            fr.resolvedType = fieldReference.resolvedType;
            fr.sourceEnd = fieldReference.sourceEnd;
            fr.sourceStart = fieldReference.sourceStart;
            fr.statementEnd = fieldReference.statementEnd;
            fr.token = fieldReference.token;
            fr.isInsideAnnotation = fieldReference.isInsideAnnotation;
            fr.setArrayMap(this.arrayMap);
            return fr;
        }
        return null;
    }

    private synchronized Expression buildFieldReference(Expression expression) {
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            JSFieldReference fr = new JSFieldReference(fieldReference.token, fieldReference.nameSourcePosition);
            fr.binding = fieldReference.binding;
            fr.bits = fieldReference.bits;
            fr.constant = fieldReference.constant;
            fr.nameSourcePosition = fieldReference.nameSourcePosition;
            fr.receiver = fieldReference.receiver;
            fr.receiverType = fieldReference.receiverType;
            fr.resolvedType = fieldReference.resolvedType;
            fr.sourceEnd = fieldReference.sourceEnd;
            fr.sourceStart = fieldReference.sourceStart;
            fr.statementEnd = fieldReference.statementEnd;
            fr.token = fieldReference.token;
            fr.setArrayMap(this.arrayMap);
            return fr;
        }
        return null;
    }

    private synchronized Expression buildArrayReference(Expression expression) {
        if (expression instanceof ArrayReference) {
            ArrayReference fieldReference = (ArrayReference)expression;
            JSArrayReference fr = new JSArrayReference(fieldReference.receiver, fieldReference.position);
            fr.bits = fieldReference.bits;
            fr.constant = fieldReference.constant;
            fr.receiver = fieldReference.receiver;
            fr.resolvedType = fieldReference.resolvedType;
            fr.sourceEnd = fieldReference.sourceEnd;
            fr.sourceStart = fieldReference.sourceStart;
            fr.statementEnd = fieldReference.statementEnd;
            fr.setArrayMap(this.arrayMap);
            return fr;
        }
        return null;
    }

    public synchronized boolean visit(IBinaryExpression iBinaryExpression) {
        BinaryExpression binaryExpression = null;
        if (iBinaryExpression instanceof BinaryExpression) {
            binaryExpression = (BinaryExpression)iBinaryExpression;
        }
        if (binaryExpression != null) {
            if (binaryExpression.right instanceof CompletionOnMemberAccess && !(binaryExpression.right instanceof JSCompletionOnMemberAccess)) {
                binaryExpression.right = this.buildCompletionOnMemberAccess(binaryExpression.right);
            } else if (binaryExpression.right instanceof FieldReference && !(binaryExpression.right instanceof JSFieldReference) && !(binaryExpression.right instanceof JSCompletionOnMemberAccess)) {
                binaryExpression.right = this.buildFieldReference(binaryExpression.right);
            }
            if (binaryExpression.left instanceof CompletionOnMemberAccess && !(binaryExpression.left instanceof JSCompletionOnMemberAccess)) {
                binaryExpression.left = this.buildCompletionOnMemberAccess(binaryExpression.left);
            } else if (binaryExpression.left instanceof FieldReference && !(binaryExpression.left instanceof JSFieldReference) && !(binaryExpression.left instanceof JSCompletionOnMemberAccess)) {
                binaryExpression.left = this.buildFieldReference(binaryExpression.left);
            }
        }
        return super.visit((IBinaryExpression)binaryExpression);
    }

    public synchronized boolean visit(IAssignment iAssignment) {
        Assignment assignment = null;
        if (iAssignment instanceof Assignment) {
            assignment = (Assignment)iAssignment;
        }
        if (assignment != null) {
            if (assignment.expression instanceof CompletionOnMemberAccess && !(assignment.expression instanceof JSCompletionOnMemberAccess)) {
                assignment.expression = this.buildCompletionOnMemberAccess(assignment.expression);
            } else if (assignment.expression instanceof FieldReference && !(assignment.expression instanceof JSFieldReference) && !(assignment.expression instanceof JSCompletionOnMemberAccess)) {
                assignment.expression = this.buildFieldReference(assignment.expression);
            }
            if (assignment.lhs instanceof CompletionOnMemberAccess && !(assignment.lhs instanceof JSCompletionOnMemberAccess)) {
                assignment.lhs = this.buildCompletionOnMemberAccess(assignment.lhs);
            } else if (assignment.lhs instanceof FieldReference && !(assignment.lhs instanceof JSFieldReference) && !(assignment.lhs instanceof JSCompletionOnMemberAccess)) {
                assignment.lhs = this.buildFieldReference(assignment.lhs);
            }
        }
        return super.visit((IAssignment)assignment);
    }

    public synchronized boolean visit(IBlock iBlock) {
        Block block = null;
        if (iBlock instanceof Block) {
            block = (Block)iBlock;
        }
        if (block != null) {
            Statement[] statements = block.statements;
            if (statements == null) {
                return super.visit((IBlock)block);
            }
            int i = 0;
            while (i < statements.length) {
                if (statements[i] instanceof Assignment && !(statements[i] instanceof JSAssignment)) {
                    statements[i] = this.buildAssignment((Assignment)statements[i]);
                } else if (statements[i] instanceof CompletionOnMemberAccess && !(statements[i] instanceof JSCompletionOnMemberAccess)) {
                    statements[i] = this.buildCompletionOnMemberAccess((Expression)statements[i]);
                } else if (statements[i] instanceof ArrayReference && !(statements[i] instanceof JSArrayReference)) {
                    statements[i] = this.buildArrayReference((Expression)statements[i]);
                } else if (statements[i] instanceof FieldReference && !(statements[i] instanceof JSFieldReference) && !(statements[i] instanceof JSCompletionOnMemberAccess)) {
                    statements[i] = this.buildFieldReference((Expression)statements[i]);
                }
                ++i;
            }
        }
        return super.visit(iBlock);
    }

    public synchronized boolean visit(IArrayReference iArrayReference) {
        ArrayReference arrayReference = null;
        if (iArrayReference instanceof ArrayReference) {
            arrayReference = (ArrayReference)iArrayReference;
        }
        if (arrayReference != null) {
            if (arrayReference.receiver instanceof CompletionOnMemberAccess && !(arrayReference.receiver instanceof JSCompletionOnMemberAccess)) {
                arrayReference.receiver = this.buildCompletionOnMemberAccess(arrayReference.receiver);
            } else if (arrayReference.receiver instanceof FieldReference && !(arrayReference.receiver instanceof JSFieldReference) && !(arrayReference.receiver instanceof JSCompletionOnMemberAccess)) {
                arrayReference.receiver = this.buildFieldReference(arrayReference.receiver);
            }
            if (arrayReference.position != null) {
                if (arrayReference.position instanceof CompletionOnMemberAccess && !(arrayReference.position instanceof JSCompletionOnMemberAccess)) {
                    arrayReference.position = this.buildCompletionOnMemberAccess(arrayReference.position);
                } else if (arrayReference.position instanceof FieldReference && !(arrayReference.position instanceof JSFieldReference) && !(arrayReference.position instanceof JSCompletionOnMemberAccess)) {
                    arrayReference.position = this.buildFieldReference(arrayReference.position);
                }
            }
        }
        return super.visit(iArrayReference);
    }

    public synchronized boolean visit(Assignment assignment, BlockScope scope) {
        if (assignment.expression instanceof CompletionOnMemberAccess && !(assignment.expression instanceof JSCompletionOnMemberAccess)) {
            assignment.expression = this.buildCompletionOnMemberAccess(assignment.expression);
        } else if (assignment.expression instanceof FieldReference && !(assignment.expression instanceof JSFieldReference) && !(assignment.expression instanceof JSCompletionOnMemberAccess)) {
            assignment.expression = this.buildFieldReference(assignment.expression);
        }
        if (assignment.lhs instanceof CompletionOnMemberAccess && !(assignment.lhs instanceof JSCompletionOnMemberAccess)) {
            assignment.lhs = this.buildCompletionOnMemberAccess(assignment.lhs);
        } else if (assignment.lhs instanceof FieldReference && !(assignment.lhs instanceof JSFieldReference) && !(assignment.lhs instanceof JSCompletionOnMemberAccess)) {
            assignment.lhs = this.buildFieldReference(assignment.lhs);
        }
        return true;
    }

    public synchronized boolean visit(IEqualExpression iEqualExpression) {
        EqualExpression equalExpression = null;
        if (iEqualExpression instanceof EqualExpression) {
            equalExpression = (EqualExpression)iEqualExpression;
        }
        if (equalExpression != null) {
            if (equalExpression.left instanceof CompletionOnMemberAccess && !(equalExpression.left instanceof JSCompletionOnMemberAccess)) {
                equalExpression.left = this.buildCompletionOnMemberAccess(equalExpression.left);
            } else if (equalExpression.left instanceof FieldReference && !(equalExpression.left instanceof JSFieldReference) && !(equalExpression.left instanceof JSCompletionOnMemberAccess)) {
                equalExpression.left = this.buildFieldReference(equalExpression.left);
            }
            if (equalExpression.right instanceof CompletionOnMemberAccess && !(equalExpression.right instanceof JSCompletionOnMemberAccess)) {
                equalExpression.right = this.buildCompletionOnMemberAccess(equalExpression.right);
            } else if (equalExpression.right instanceof FieldReference && !(equalExpression.right instanceof JSFieldReference) && !(equalExpression.right instanceof JSCompletionOnMemberAccess)) {
                equalExpression.right = this.buildFieldReference(equalExpression.right);
            }
        }
        return super.visit((IEqualExpression)equalExpression);
    }

    private List<XSDEnumerationFacet> checkEnumeration(ITypedElement data) {
        XSDSimpleTypeDefinition st;
        EList schemaContent;
        TypeDeclarationType type = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:dataType");
        if (type != null && !(schemaContent = type.getSchema().getContents()).isEmpty() && schemaContent.get(0) instanceof XSDSimpleTypeDefinition && !(st = (XSDSimpleTypeDefinition)schemaContent.get(0)).getEnumerationFacets().isEmpty()) {
            return st.getEnumerationFacets();
        }
        return null;
    }
}

