/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.MergeEditorInput;
import org.eclipse.stardust.modeling.modelimport.elements.StructureComparator;
import org.eclipse.xsd.XSDSchema;

public class MergeUtil {
    private static final int DUPLICATE_OID = 1;
    private static final int MISSING_OID = 2;
    private static HashMap<Long, EObject> existingElements = new HashMap();
    private static ArrayList addedElements = new ArrayList();
    private static FixedCopier copier = new FixedCopier();

    public static EObject copyAdd(EObject model) {
        EObject result = MergeUtil.copy(model);
        if (model instanceof ParticipantType) {
            copier.copyReference(CarnotWorkflowModelPackage.eINSTANCE.getParticipantType_Participant(), model, result);
        }
        addedElements.add(result);
        return result;
    }

    public static EObject copy(EObject eObject) {
        EObject result = copier.get(eObject);
        return result == null ? copier.copy(eObject) : result;
    }

    public static void copyReferences() {
        copier.copyReferences();
        copier.clear();
        int i = 0;
        while (i < addedElements.size()) {
            EObject eObject = (EObject)addedElements.get(i);
            if (eObject instanceof OrganizationType) {
                EList participantsRef = ((OrganizationType)eObject).getParticipant();
                int j = participantsRef.size() - 1;
                while (j >= 0) {
                    ParticipantType ref = (ParticipantType)participantsRef.get(j);
                    if (ref.getParticipant() == null) {
                        participantsRef.remove(j);
                    }
                    --j;
                }
            }
            MergeUtil.replaceReferencesInAddedElements((EObject)addedElements.get(i));
            ++i;
        }
        addedElements.clear();
    }

    private static void replaceReferencesInAddedElements(EObject eObject) {
        if (eObject instanceof IModelElement) {
            HashMap toChange = new HashMap();
            for (Object child : eObject.eContents()) {
                EObject other;
                if (!(child instanceof IModelElement) || (other = existingElements.get(new Long(((IModelElement)child).getElementOid()))) == null) continue;
                toChange.put(child, other);
            }
            for (Map.Entry entry : toChange.entrySet()) {
                EcoreUtil.replace((EObject)((EObject)entry.getKey()), (EObject)((EObject)entry.getValue()));
            }
        }
    }

    public static boolean initialize(ModelType newModel, ModelType targetModel, MergeEditorInput input) {
        EObject child;
        copier.clear();
        existingElements.clear();
        HashMap<EObject, EObject> matching = new HashMap<EObject, EObject>();
        XMLResource resource = targetModel.eResource() instanceof XMLResource ? (XMLResource)targetModel.eResource() : null;
        TreeIterator i = newModel.eAllContents();
        while (i.hasNext()) {
            EObject other;
            EObject child2 = (EObject)i.next();
            if (!(child2 instanceof IModelElement) || (other = ModelServerUtils.getSameModelElement((EObject)child2, (ModelType)targetModel, (ModelType)newModel)) == null || !child2.eClass().equals(other.eClass())) continue;
            matching.put(child2, other);
        }
        long[] nextOid = new long[]{Long.MIN_VALUE};
        HashSet globalOids = new HashSet();
        ArrayList problems = new ArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet localOids = new HashSet();
        int result = 0;
        TreeIterator i2 = targetModel.eAllContents();
        while (i2.hasNext()) {
            child = (EObject)i2.next();
            result |= MergeUtil.checkDuplicateOrUnsetOid(nextOid, globalOids, localOids, problems, child);
        }
        if (result & true) {
            errors.add(Import_Messages.MergeUtil_DUPLICATE_OIDS_TARGET);
        }
        if ((result & 2) != 0) {
            errors.add(Import_Messages.MergeUtil_MISSING_OIDS_TARGET);
        }
        localOids.clear();
        result = 0;
        i2 = newModel.eAllContents();
        while (i2.hasNext()) {
            child = (EObject)i2.next();
            if (matching.containsKey(child)) continue;
            result |= MergeUtil.checkDuplicateOrUnsetOid(nextOid, globalOids, localOids, problems, child);
        }
        if ((result & 1) != 0) {
            errors.add(Import_Messages.MergeUtil_DUPLICATE_OIDS_SOURCE);
        }
        if ((result & 2) != 0) {
            errors.add(Import_Messages.MergeUtil_MISSING_OIDS_SOURCE);
        }
        if (!errors.isEmpty() && !input.showErrors(errors.toArray(new String[errors.size()]))) {
            return true;
        }
        nextOid[0] = nextOid[0] + 1L;
        int i22 = 0;
        while (i22 < problems.size()) {
            IModelElement me = (IModelElement)problems.get(i22);
            long l = nextOid[0];
            nextOid[0] = l + 1L;
            me.setElementOid(l);
            MergeUtil.updateIdCaches(resource, me);
            ++i22;
        }
        for (Map.Entry entry : matching.entrySet()) {
            IModelElement me = (IModelElement)entry.getKey();
            IModelElement other = (IModelElement)entry.getValue();
            me.setElementOid(other.getElementOid());
            MergeUtil.updateIdCaches(resource, me);
            existingElements.put(new Long(me.getElementOid()), (EObject)other);
        }
        return false;
    }

    private static int checkDuplicateOrUnsetOid(long[] nextOid, HashSet globalOids, HashSet localOids, ArrayList problems, EObject child) {
        int result = 0;
        if (child instanceof IModelElement) {
            IModelElement me = (IModelElement)child;
            if (me.isSetElementOid()) {
                long oid = me.getElementOid();
                Long key = new Long(oid);
                if (globalOids.contains(key)) {
                    problems.add(me);
                } else {
                    globalOids.add(key);
                    nextOid[0] = Math.max(nextOid[0], oid);
                }
                if (localOids.contains(key)) {
                    result |= 1;
                } else {
                    localOids.add(key);
                }
            } else {
                result |= 2;
                problems.add(me);
            }
        }
        return result;
    }

    private static void updateIdCaches(XMLResource resource, IModelElement me) {
        if (resource != null) {
            resource.setID((EObject)me, String.valueOf(me.getElementOid()));
        }
    }

    public static EObject getElementInOtherModel(EObject element, ModelType model) {
        List list = MergeUtil.getContainingList(element, model);
        if (list != null) {
            StructureComparator elementNode = new StructureComparator(element, null);
            for (EObject target : list) {
                StructureComparator targetNode = new StructureComparator(target, null);
                if (!elementNode.equals(targetNode)) continue;
                return target;
            }
        }
        return null;
    }

    private static List getContainingList(EObject obj, ModelType model) {
        Object parent = obj.eContainer();
        if (parent == null) {
            return null;
        }
        EStructuralFeature feature = obj.eContainingFeature();
        parent = parent instanceof ModelType ? model : MergeUtil.getElementInOtherModel(parent, model);
        return parent != null && feature.isMany() ? (List)parent.eGet(feature) : null;
    }

    private static final class FixedCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        private FixedCopier() {
        }

        public EObject get(Object key) {
            EObject result = (EObject)super.get(key);
            if (result == null && key instanceof IModelElement) {
                result = (EObject)existingElements.get(new Long(((IModelElement)key).getElementOid()));
            }
            return result;
        }

        public EObject copy(EObject object) {
            Object result = object instanceof XSDSchema ? ((XSDSchema)object).cloneConcreteComponent(true, false) : super.copy(object);
            if (result instanceof IModelElement) {
                Long key = new Long(((IModelElement)result).getElementOid());
                if (!existingElements.containsKey(key)) {
                    existingElements.put(key, result);
                }
            }
            return result;
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            super.copyReference(eReference, eObject, copyEObject);
        }
    }
}

