/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.propertypages;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementAdapter;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementValueAdapter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.project.effort.EffortByKeyParameter;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortKey;
import org.eclipse.stardust.modeling.project.effort.EffortListener;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.EffortParameters;
import org.eclipse.stardust.modeling.project.effort.NamedItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractProjectPlanningAspectPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage {
    private EffortParameterScope scope;
    protected String errorMessage = null;
    private EffortParameters effortParameters;
    protected boolean inNotification;
    private static final LabelProvider namedItemLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((NamedItem)element).getName();
        }
    };

    public void setScope(EffortParameterScope scope) {
        this.scope = scope;
    }

    boolean hasError() {
        return this.errorMessage != null;
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    protected EffortParameters getEffortParameters() {
        if (this.effortParameters == null) {
            ModelType model = ModelUtils.findContainingModel((EObject)this.getModelElement());
            this.effortParameters = EffortParameters.getEffortParameters(model);
        }
        return this.effortParameters;
    }

    public Composite createParameterComposite(Composite parent) {
        final ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        scroller.setLayout((Layout)layout);
        scroller.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        final Composite composite = FormBuilder.createComposite((Composite)scroller, (int)1);
        scroller.setContent((Control)composite);
        final EffortParameters parameters = this.getEffortParameters();
        this.updateContent(composite);
        final EffortListener listener = new EffortListener(){

            @Override
            public void handleEvent(EffortEvent event) {
                AbstractProjectPlanningAspectPropertyPage.this.updateContent(composite);
                scroller.setMinSize(composite.computeSize(-1, -1));
            }
        };
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parameters.removeListener(listener);
                AbstractProjectPlanningAspectPropertyPage.this.scope.removeListener(listener);
            }
        });
        parameters.addListener(listener);
        this.scope.addListener(listener);
        return scroller;
    }

    void updateContent(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.hasError()) {
            Label label = FormBuilder.createLabel((Composite)composite, (String)this.errorMessage);
            label.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        } else {
            this.addControls(composite);
        }
        composite.layout();
        composite.setSize(composite.computeSize(-1, -1));
    }

    private void addControls(Composite composite) {
        Iterator<String> iter = this.scope.getParameterNames();
        while (iter.hasNext()) {
            String name = iter.next();
            EffortParameter parameter = this.scope.getParameter(name);
            if (parameter instanceof EffortByKeyParameter) {
                this.addComboEntry(composite, (EffortByKeyParameter)parameter);
                continue;
            }
            this.addTextEntry(composite, parameter);
        }
    }

    private void addComboEntry(final Composite composite, final EffortByKeyParameter parameter) {
        final LabeledViewer labeledViewer = FormBuilder.createComboViewer((Composite)composite, (String)(String.valueOf(parameter.getName()) + ":"), (List)Collections.EMPTY_LIST);
        final WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        final IExtensibleElement extensible = (IExtensibleElement)this.getModelElement();
        ComboViewer viewer = (ComboViewer)labeledViewer.getViewer();
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)namedItemLabelProvider);
        final ExtensibleElementValueAdapter keyAdapter = new ExtensibleElementValueAdapter(){

            public Object fromModel(ExtensibleElementAdapter binding, Object value) {
                return value == null ? null : parameter.getKey((String)value);
            }

            public Object toModel(ExtensibleElementAdapter binding, Object value) {
                return value == null ? null : ((EffortKey)value).getName();
            }
        };
        viewer.setInput(this.getKeyList(viewer, parameter));
        wBndMgr.bind(labeledViewer, extensible, this.getAttributeName(parameter.getName()), keyAdapter);
        final EffortListener updater = new EffortListener(){

            @Override
            public void handleEvent(EffortEvent event) {
                if ("name".equals(event.getProperty())) {
                    wBndMgr.unbind(labeledViewer, extensible, (Object)AbstractProjectPlanningAspectPropertyPage.this.getAttributeName((String)event.getOldValue()));
                    wBndMgr.bind(labeledViewer, extensible, AbstractProjectPlanningAspectPropertyPage.this.getAttributeName((String)event.getNewValue()), keyAdapter);
                    Label label = labeledViewer.getLabel().getLabel();
                    label.setText(AbstractProjectPlanningAspectPropertyPage.this.getLabelForParameter((String)event.getNewValue()));
                    composite.layout(new Control[]{label});
                }
            }
        };
        viewer.getCombo().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parameter.removeListener(updater);
            }
        });
        parameter.addListener(updater);
    }

    private void addTextEntry(final Composite composite, final EffortParameter parameter) {
        final LabeledText labeledText = FormBuilder.createLabeledText((Composite)composite, (String)this.getLabelForParameter(parameter.getName()));
        labeledText.getText().addVerifyListener((VerifyListener)VerifierFactory.doubleVerifier);
        final WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        final IExtensibleElement extensible = (IExtensibleElement)this.getModelElement();
        wBndMgr.bind(labeledText, extensible, this.getAttributeName(parameter.getName()));
        final EffortListener updater = new EffortListener(){

            @Override
            public void handleEvent(EffortEvent event) {
                if ("name".equals(event.getProperty())) {
                    wBndMgr.unbind(labeledText, extensible, (Object)AbstractProjectPlanningAspectPropertyPage.this.getAttributeName((String)event.getOldValue()));
                    wBndMgr.bind(labeledText, extensible, AbstractProjectPlanningAspectPropertyPage.this.getAttributeName((String)event.getNewValue()));
                    Label label = labeledText.getLabel().getLabel();
                    label.setText(AbstractProjectPlanningAspectPropertyPage.this.getLabelForParameter((String)event.getNewValue()));
                    composite.layout(new Control[]{label});
                }
            }
        };
        labeledText.getText().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parameter.removeListener(updater);
            }
        });
        parameter.addListener(updater);
    }

    private String getAttributeName(String parameterName) {
        return "project-planning:" + parameterName;
    }

    private String getLabelForParameter(String parameterName) {
        return String.valueOf(parameterName) + ":";
    }

    private List<EffortKey> getKeyList(final ComboViewer viewer, final EffortByKeyParameter parameter) {
        final EffortListener updater = new EffortListener(){

            @Override
            public void handleEvent(EffortEvent event) {
                if (event.getSource() == parameter.getScope() && event.getProperty() == "items.remove" && event.getOldValue() == parameter) {
                    parameter.removeListener(this);
                } else {
                    if (event.getSource() == parameter && event.getProperty() == "items.remove") {
                        EffortKey key = (EffortKey)event.getOldValue();
                        key.removeListener(this);
                    }
                    ISelection selection = viewer.getSelection();
                    viewer.setInput((Object)AbstractProjectPlanningAspectPropertyPage.this.getKeyList(this, parameter));
                    viewer.setSelection(selection);
                }
            }
        };
        viewer.getCombo().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parameter.getScope().removeListener(updater);
                parameter.removeListener(updater);
                Iterator<String> i = parameter.getKeyNames();
                while (i.hasNext()) {
                    String keyName = i.next();
                    EffortKey key = parameter.getKey(keyName);
                    key.removeListener(updater);
                }
            }
        });
        parameter.getScope().addListener(updater);
        parameter.addListener(updater);
        return this.getKeyList(updater, parameter);
    }

    private List<EffortKey> getKeyList(EffortListener updater, EffortByKeyParameter parameter) {
        List keys = CollectionUtils.newList();
        Iterator<String> i = parameter.getKeyNames();
        while (i.hasNext()) {
            String keyName = i.next();
            EffortKey key = parameter.getKey(keyName);
            keys.add(key);
            key.addListener(updater);
        }
        return keys;
    }
}

