/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowModelEditorsCollector {
    private HashMap models = new HashMap();

    public WorkflowModelEditorsCollector() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] references = page.getEditorReferences();
                if (references != null) {
                    int k = 0;
                    while (k < references.length) {
                        IEditorReference reference = references[k];
                        try {
                            IEditorInput input = reference.getEditorInput();
                            if (input instanceof FileEditorInput) {
                                ModelType model;
                                IFile file = ((FileEditorInput)input).getFile();
                                IEditorPart part = reference.getEditor(false);
                                if (part instanceof WorkflowModelEditor && (model = ((WorkflowModelEditor)part).getWorkflowModel()) != null) {
                                    ArrayList<IEditorPart> opened = (ArrayList<IEditorPart>)this.models.get(file);
                                    if (opened == null) {
                                        opened = new ArrayList<IEditorPart>();
                                        this.models.put(file, opened);
                                    }
                                    opened.add(part);
                                }
                            }
                        }
                        catch (PartInitException partInitException) {}
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        this.models.clear();
        this.models = null;
    }

    public List getEditors(IFile file) {
        ArrayList list = (ArrayList)this.models.get(file);
        return list == null ? Collections.EMPTY_LIST : list;
    }
}

