/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui.dialogs;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private Callback[] callbacks;
    private Control[] controls;
    private String title;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LoginDialog.this.updateButtons();
        }
    };

    public LoginDialog(Shell shell, String title, Callback[] callbacks) {
        super(shell);
        this.title = title;
        if (callbacks != null) {
            this.callbacks = callbacks;
            this.controls = new Control[callbacks.length];
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        topLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        topLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        comp.setLayout((Layout)topLayout);
        comp.setFont(parent.getFont());
        int i = 0;
        while (i < this.callbacks.length) {
            if (this.callbacks[i] instanceof NameCallback) {
                this.controls[i] = this.addNameCallback(comp, (NameCallback)this.callbacks[i]);
            } else if (this.callbacks[i] instanceof PasswordCallback) {
                this.controls[i] = this.addPasswordCallback(comp, (PasswordCallback)this.callbacks[i]);
            } else if (this.callbacks[i] instanceof ChoiceCallback) {
                this.controls[i] = this.addChoiceCallback(comp, (ChoiceCallback)this.callbacks[i]);
            }
            ++i;
        }
        LoginDialog.applyDialogFont((Control)comp);
        return comp;
    }

    private Control addChoiceCallback(Composite comp, ChoiceCallback callback) {
        this.createLabel(comp, callback.getPrompt());
        Button checkBox = new Button(comp, 32);
        checkBox.setText(callback.getChoices()[0]);
        checkBox.setFont(comp.getFont());
        return checkBox;
    }

    private Control addPasswordCallback(Composite comp, PasswordCallback password) {
        this.createLabel(comp, password.getPrompt());
        char[] chars = password.getPassword();
        Text passwordText = this.createText(comp, chars == null ? "" : new String(chars));
        passwordText.setEchoChar('*');
        return passwordText;
    }

    private Text addNameCallback(Composite comp, NameCallback name) {
        this.createLabel(comp, name.getPrompt());
        String text = name.getName();
        if (text == null) {
            text = name.getDefaultName();
        }
        Text nameText = this.createText(comp, text == null ? "" : text);
        return nameText;
    }

    private void createLabel(Composite comp, String text) {
        Label passwordLabel = new Label(comp, 0);
        passwordLabel.setText(text);
        passwordLabel.setFont(comp.getFont());
    }

    private Text createText(Composite comp, String text) {
        Text passwordText = new Text(comp, 2052);
        passwordText.setText(text);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        passwordText.setLayoutData((Object)gd);
        passwordText.setFont(comp.getFont());
        passwordText.addModifyListener(this.listener);
        return passwordText;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int i = 0;
            while (i < this.callbacks.length) {
                if (this.callbacks[i] instanceof NameCallback) {
                    ((NameCallback)this.callbacks[i]).setName(((Text)this.controls[i]).getText());
                } else if (this.callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)this.callbacks[i]).setPassword(((Text)this.controls[i]).getText().toCharArray());
                } else if (this.callbacks[i] instanceof ChoiceCallback) {
                    ((ChoiceCallback)this.callbacks[i]).setSelectedIndex(((Button)this.controls[i]).getSelection() ? 0 : -1);
                }
                ++i;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void updateButtons() {
        boolean enabled = false;
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && !(enabled = this.isValidInput(this.controls[i]))) break;
            ++i;
        }
        this.getButton(0).setEnabled(enabled);
    }

    private boolean isValidInput(Control control) {
        if (control instanceof Text) {
            String value = ((Text)control).getText();
            return value.length() > 0;
        }
        return true;
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

