/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.IDiagramChangeListener;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.dialog.ApplyUpdatesCommand;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.templates.adapters.TemplateContentAdapter;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.stardust.modeling.templates.views.WorkflowModelEditorAction;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class DropTemplateWorkflowModelEditorAction
extends WorkflowModelEditorAction
implements IDiagramChangeListener {
    private Map dropListeners = new HashMap();

    public static boolean isValidDndSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        return selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof ITemplate;
    }

    @Override
    protected void register(WorkflowModelEditor part) {
        part.addDiagramChangeListener((IDiagramChangeListener)this);
        DiagramEditorPage[] editors = part.getEditors();
        int i = 0;
        while (i < editors.length) {
            this.diagramPageOpened(editors[i]);
            ++i;
        }
    }

    @Override
    protected void unregister(WorkflowModelEditor part) {
        part.removeDiagramChangeListener((IDiagramChangeListener)this);
        DiagramEditorPage[] editors = part.getEditors();
        int i = 0;
        while (i < editors.length) {
            this.diagramPageClosed(editors[i]);
            ++i;
        }
    }

    public void diagramPageChanged(DiagramEditorPage page) {
    }

    public void diagramPageClosed(DiagramEditorPage page) {
        TransferDropTargetListener dropTargetListener = (TransferDropTargetListener)this.dropListeners.get(page);
        if (dropTargetListener != null) {
            page.getGraphicalViewer().removeDropTargetListener(dropTargetListener);
        }
    }

    public void diagramPageOpened(final DiagramEditorPage page) {
        TransferDropTargetListener dropTargetListener = new TransferDropTargetListener(){

            public Transfer getTransfer() {
                return LocalSelectionTransfer.getTransfer();
            }

            public boolean isEnabled(DropTargetEvent event) {
                DiagramType targetDiagram;
                org.eclipse.swt.graphics.Point location = this.getAbsoluteLocation(page.getGraphicalViewer().getControl());
                page.getWorkflowModelEditor();
                EditPart editPart = page.getGraphicalViewer().findObjectAt(new Point(event.x - location.x, event.y - location.y));
                EditPart targetEditPart = GenericUtils.isValidTargetEditPart((EditPart)editPart);
                if (targetEditPart == null) {
                    return false;
                }
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                boolean enabled = DropTemplateWorkflowModelEditorAction.isValidDndSelection(selection);
                if (enabled) {
                    event.detail = 1;
                }
                if ((targetDiagram = page.getDiagram()) == null || !(targetDiagram.eContainer() instanceof ProcessDefinitionType)) {
                    return false;
                }
                return enabled;
            }

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                WorkflowModelEditor editor = page.getWorkflowModelEditor();
                DiagramType targetDiagram = page.getDiagram();
                if (editor.getModelServer().requireLock((EObject)targetDiagram)) {
                    ModelServerUtils.showMessageBox((String)Diagram_Messages.MSG_LOCK_NEEDED);
                    return;
                }
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                ITemplate template = (ITemplate)((IStructuredSelection)selection).getFirstElement();
                org.eclipse.swt.graphics.Point location = this.getAbsoluteLocation(page.getGraphicalViewer().getControl());
                final EditPart editPart = page.getGraphicalViewer().findObjectAt(new Point(event.x - location.x, event.y - location.y));
                ModelType targetModel = editor.getWorkflowModel();
                TemplateContentAdapter contentAdapter = new TemplateContentAdapter(targetModel, template);
                targetModel.eAdapters().add((Object)contentAdapter);
                ChangeRecorder recorder = new ChangeRecorder((EObject)targetModel);
                editor.getModelManager().getModelOidUtil();
                try {
                    try {
                        template.applyTemplate(editor, targetModel, targetDiagram, editPart, event.x - location.x, event.y - location.y);
                        ApplyUpdatesCommand command = new ApplyUpdatesCommand(recorder.endRecording());
                        editor.getEditDomain().getCommandStack().execute((Command)command);
                        CompoundCommand reorderCmd = null;
                        if (editPart instanceof AbstractSwimlaneEditPart) {
                            LaneEditPart laneEditPart = (LaneEditPart)editPart;
                            if (!laneEditPart.getLaneModel().getActivitySymbol().isEmpty()) {
                                for (ActivitySymbolType activitySymbolType : laneEditPart.getLaneModel().getActivitySymbol()) {
                                    ActivityType activityType = (ActivityType)activitySymbolType.getModelElement();
                                    if (!activityType.getImplementation().equals((Object)ActivityImplementationType.MANUAL_LITERAL)) continue;
                                    activityType.setPerformer(laneEditPart.getLaneModel().getParticipantReference());
                                }
                            }
                            reorderCmd = new CompoundCommand();
                            reorderCmd.add((Command)new DelegatingCommand(){

                                public Command createDelegate() {
                                    return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)((AbstractSwimlaneEditPart)editPart));
                                }
                            });
                            reorderCmd.add((Command)new DelegatingCommand(){

                                public Command createDelegate() {
                                    return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)((AbstractSwimlaneEditPart)editPart), (Integer)new Integer(2));
                                }
                            });
                            editor.getEditDomain().getCommandStack().execute((Command)reorderCmd);
                        }
                        editor.selectSymbols(contentAdapter.getAddedSymbols(), targetDiagram);
                        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)editor.getCurrentPage();
                        diagramEditorPage.setFocus();
                        INodeSymbol lastSymbol = (INodeSymbol)contentAdapter.getAddedSymbols().get(0);
                        diagramEditorPage.setMouseLocation(new Point((double)lastSymbol.getXPos(), (double)lastSymbol.getYPos()));
                    }
                    catch (ImportCancelledException importCancelledException) {
                        ApplyUpdatesCommand command = new ApplyUpdatesCommand(recorder.endRecording());
                        editor.getEditDomain().getCommandStack().execute((Command)command);
                        editor.getEditDomain().getCommandStack().undo();
                        targetModel.eAdapters().remove((Object)contentAdapter);
                        recorder.dispose();
                    }
                }
                finally {
                    targetModel.eAdapters().remove((Object)contentAdapter);
                    recorder.dispose();
                }
            }

            private org.eclipse.swt.graphics.Point getAbsoluteLocation(Control control) {
                org.eclipse.swt.graphics.Point location = control.getLocation();
                if (control.getParent() != null) {
                    org.eclipse.swt.graphics.Point parentLocation = this.getAbsoluteLocation((Control)control.getParent());
                    location.x += parentLocation.x;
                    location.y += parentLocation.y;
                }
                return location;
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
        this.dropListeners.put(page, dropTargetListener);
        page.getGraphicalViewer().addDropTargetListener(dropTargetListener);
    }
}

