/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer;

import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.IMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;

public class StructDataMappingRenderer
implements IMappingRenderer {
    private MessageTransformationController controller;
    private StructAccessPointType messageType;

    public StructDataMappingRenderer(MessageTransformationController controller, AccessPointType messageType) {
        this.controller = controller;
        this.messageType = (StructAccessPointType)messageType;
    }

    @Override
    public AccessPointType getType() {
        return this.messageType;
    }

    @Override
    public String renderGetterCode(boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        String javaPath = this.createJavaPath(ignoreArrays, variablesAsIndices, config);
        return javaPath;
    }

    @Override
    public String renderSetterCode(String getterCode, boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        String accessCode = this.createJavaPath(ignoreArrays, variablesAsIndices, config);
        if (this.controller.getArraySelectionDepthTarget() > 0) {
            return String.valueOf(accessCode) + " = " + getterCode;
        }
        return getterCode;
    }

    @Override
    public String renderAdditionCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, MappingConfiguration config) {
        String targetIndex;
        String sourcePath = this.createJavaPath(false, false, config);
        if (sourcePath.endsWith(".")) {
            sourcePath = sourcePath.replace(".", "");
        }
        if ((targetIndex = targetMapper.renderGetterCode(false, false, config)).endsWith(".")) {
            targetIndex = targetIndex.replace(".", "");
        }
        String result = targetIndex;
        if (config.isAppend()) {
            int idx1 = targetIndex.lastIndexOf("[");
            int idx2 = targetIndex.lastIndexOf("]");
            int idx = idx2 - idx1 + 1;
            targetIndex = targetIndex.substring(0, targetIndex.length() - idx);
            targetIndex = String.valueOf(targetIndex) + ".length + 1";
            String xPath = this.controller.getXPathFor(targetMapper.getType());
            config.getIndexMap().put(xPath, targetIndex);
            result = targetMapper.renderGetterCode(false, false, config);
        }
        if (result.endsWith(".")) {
            result = targetIndex.replace(".", "");
        }
        return String.valueOf(result) + " = " + sourcePath + ";";
    }

    @Override
    public String renderListMappingCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, MappingConfiguration config) {
        String result = "";
        String sourceArray = sourceMapper.renderGetterCode(false, true, config);
        String targetArray = targetMapper.renderGetterCode(false, true, config);
        int index = 0;
        if (depth > 9) {
            index = 1;
        }
        String sourcePath = sourceArray.substring(0, sourceArray.length() - 4 - index);
        String varDeclaration = "n" + depth;
        String o = this.controller.getUsedVar().get("n" + depth);
        if (o == null) {
            varDeclaration = "var n" + depth;
            this.controller.getUsedVar().put("n" + depth, "defined");
        }
        result = String.valueOf(result) + inset + "for (" + varDeclaration + " = 0; n" + depth + " < " + sourcePath + ".length; ++n" + depth + "){\n";
        result = this.controller.isComplexType(sourceMapper.getType()) ? this.renderAssignmentCode(sourceMapper, targetMapper, inset, depth, result, config) : String.valueOf(result) + inset + "   " + targetArray + " = " + sourceArray + ";\n";
        result = String.valueOf(result) + inset + "}\n";
        result = result.replace("= null", "= " + AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"RootElement"));
        result = result.replace("null", AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"RootElement"));
        return result;
    }

    @Override
    public String renderAssignmentCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, String result, MappingConfiguration config) {
        Object[] sourceChildren = this.controller.getSourceAPB().getChildren(sourceMapper.getType());
        Object[] targetChildren = this.controller.getTargetAPB().getChildren(targetMapper.getType());
        int i = 0;
        while (i < sourceChildren.length) {
            StructDataMappingRenderer sourceChildTypeMapper = new StructDataMappingRenderer(this.controller, (AccessPointType)sourceChildren[i]);
            StructDataMappingRenderer targetChildTypeMapper = new StructDataMappingRenderer(this.controller, (AccessPointType)targetChildren[i]);
            if (this.controller.isList((AccessPointType)sourceChildren[i])) {
                result = String.valueOf(result) + this.renderListMappingCode(sourceChildTypeMapper, targetChildTypeMapper, String.valueOf(inset) + "   ", depth + 1, config);
            } else if (this.controller.isComplexType((AccessPointType)sourceChildren[i])) {
                result = this.renderAssignmentCode(sourceChildTypeMapper, targetChildTypeMapper, inset, depth, result, config);
            } else {
                String sourceChildArray = sourceChildTypeMapper.renderGetterCode(false, true, config);
                String targetChildArray = targetChildTypeMapper.renderGetterCode(false, true, config);
                result = String.valueOf(result) + inset + "   " + targetChildArray + " = " + sourceChildArray + ";\n";
            }
            ++i;
        }
        return result;
    }

    private String createJavaPath(boolean ignoreArrays, boolean useVariableAsIndices, MappingConfiguration config) {
        String javaPath = "";
        javaPath = this.controller.isRoot((AccessPointType)this.messageType) ? this.messageType.getId() : this.controller.getXPathFor((AccessPointType)this.messageType);
        javaPath = javaPath.replace('/', '.');
        if (!ignoreArrays) {
            javaPath = this.addArrayInfo(useVariableAsIndices, config);
        }
        return javaPath;
    }

    private String addArrayInfo(boolean useVariablesAsIndices, MappingConfiguration config) {
        String idx = "[n]";
        if (!useVariablesAsIndices) {
            idx = "[0]";
        }
        TypedXPath parentXPath = this.messageType.getXPath();
        String[] segments = parentXPath.toString().split("/");
        int j = segments.length;
        while (!StringUtils.isEmpty((String)parentXPath.toString())) {
            --j;
            if (parentXPath.isList()) {
                String xPath = String.valueOf(this.controller.getRootFor((AccessPointType)this.messageType)) + "/" + parentXPath.getXPath();
                if (config != null && config.getIndexMap().get(xPath) != null) {
                    String idx2 = config.getIndexMap().get(xPath);
                    segments[j] = String.valueOf(segments[j]) + "[" + idx2 + "]";
                } else {
                    segments[j] = String.valueOf(segments[j]) + idx;
                }
            }
            parentXPath = parentXPath.getParentXPath();
        }
        int n = 0;
        int adepth = 0;
        int arraySelectionDepth = 0;
        arraySelectionDepth = this.controller.isSourceField((AccessPointType)this.messageType) ? this.controller.getArraySelectionDepthSource() : this.controller.getArraySelectionDepthTarget();
        if (useVariablesAsIndices) {
            int i = 0;
            while (i < segments.length) {
                if (segments[i].indexOf("[n]") != -1) {
                    if (++adepth >= arraySelectionDepth) {
                        segments[i] = segments[i].replace("[n]", "[n" + n + "]");
                        ++n;
                    } else {
                        segments[i] = segments[i].replace("[n]", "[0]");
                    }
                }
                ++i;
            }
        }
        String javaPath = "";
        int i = 0;
        while (i < segments.length) {
            javaPath = String.valueOf(javaPath) + segments[i] + ".";
            ++i;
        }
        javaPath = String.valueOf(this.controller.getRootFor((AccessPointType)this.messageType)) + "." + javaPath.substring(0, javaPath.length() - 1);
        return javaPath;
    }

    @Override
    public String getTypeString() {
        TypedXPath xPath = this.messageType.getXPath();
        int type = xPath.getType();
        if (type == 8) {
            return "String";
        }
        if (type == 4) {
            return "Number";
        }
        if (type == 2) {
            return "Number";
        }
        if (type == 5) {
            return "Number";
        }
        if (type == 3) {
            return "Number";
        }
        if (type == 6) {
            return "Number";
        }
        if (type == 0) {
            return "Boolean";
        }
        if (type == 7) {
            return "Number";
        }
        if (type == -1) {
            if (!StringUtils.isEmpty((String)xPath.getXsdTypeName())) {
                return xPath.getXsdTypeName();
            }
            return xPath.getXsdElementName();
        }
        if (type == 9) {
            return "Date";
        }
        if (type == 14) {
            return "String";
        }
        return " ";
    }
}

