/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.PrimitivesFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.SerializableFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.StructuredTypesFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class MessageAdditionDialog
extends Dialog
implements ModifyListener {
    private static final int RESET_ID = 22;
    private Text messageNameText;
    private String tagName;
    private ComboViewer messageComboViewer;
    private MessageTransformationController controller;
    private AccessPointType messageType;
    private String messageName;
    private List messageTypes;
    private String preset;
    private List allMessageTypes = new ArrayList();
    private List typeFilters = new ArrayList();
    private Combo messageCombo;
    private Label errorLabel;
    private WorkflowModelEditor wfme;
    private Composite mainComposite;
    private boolean isError = false;
    private Combo dataTypeCombo;
    private ComboViewer dataTypeComboViewer;
    private Label structLabel;
    private TypeSelectionComposite classBrowser;
    private StackLayout stack;
    private Composite structPrimComposite;
    private Composite classBrowseComposite;
    private Group messageComposite;
    protected ViewerFilter selectedFilter;
    private DirectionType directionType;

    public MessageAdditionDialog(Shell parentShell, MessageTransformationController controller, List messageTypes, String preset, DirectionType directionType) {
        super(parentShell);
        this.controller = controller;
        this.messageTypes = messageTypes;
        this.directionType = directionType;
        this.preset = preset;
        this.allMessageTypes.addAll(controller.getSourceMessageTypes());
        this.allMessageTypes.addAll(controller.getTargetMessageTypes());
        this.typeFilters.add(new StructuredTypesFilter());
        this.typeFilters.add(new PrimitivesFilter());
        if (!controller.isSimpleMode()) {
            this.typeFilters.add(new SerializableFilter());
        }
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart currentEditor;
        this.mainComposite = parent;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            this.wfme = (WorkflowModelEditor)currentEditor;
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 3;
        Label tagNameLabel = new Label(comp, 16384);
        tagNameLabel.setText(MessageFormat.format(Modeling_Messages.TXT_NAME, this.controller.getNameString()));
        if (!this.controller.isSimpleMode()) {
            tagNameLabel.setText(Modeling_Messages.TXT_MSG_NAME);
        }
        this.messageNameText = new Text(comp, 2052);
        this.messageNameText.addModifyListener((ModifyListener)this);
        GridData data = new GridData(768);
        this.messageNameText.setLayoutData((Object)data);
        this.errorLabel = new Label(comp, 0);
        this.errorLabel.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
        this.errorLabel.setVisible(false);
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.horizontalSpan = 2;
        Label typeLabel = new Label(comp, 16384);
        typeLabel.setText(Modeling_Messages.TXT_DATETYPE);
        this.dataTypeCombo = new Combo(comp, 128);
        this.dataTypeCombo.setLayoutData((Object)comboData);
        this.dataTypeComboViewer = new ComboViewer(this.dataTypeCombo);
        this.dataTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.messageComposite = new Group(comp, 0);
        this.stack = new StackLayout();
        this.messageComposite.setLayout((Layout)this.stack);
        GridData messageCompData = new GridData();
        messageCompData.grabExcessHorizontalSpace = true;
        messageCompData.grabExcessVerticalSpace = true;
        messageCompData.horizontalAlignment = 4;
        messageCompData.verticalAlignment = 4;
        messageCompData.horizontalSpan = 2;
        this.messageComposite.setLayout((Layout)this.stack);
        this.messageComposite.setLayoutData((Object)messageCompData);
        this.structPrimComposite = new Composite((Composite)this.messageComposite, 0);
        GridLayout structPrimLayout = new GridLayout();
        structPrimLayout.numColumns = 2;
        GridData structPrimData = new GridData();
        structPrimData.grabExcessHorizontalSpace = true;
        structPrimData.grabExcessVerticalSpace = true;
        structPrimData.verticalAlignment = 4;
        structPrimData.horizontalAlignment = 4;
        structPrimData.horizontalSpan = 2;
        this.structPrimComposite.setLayoutData((Object)structPrimData);
        this.structPrimComposite.setLayout((Layout)structPrimLayout);
        this.messageCombo = new Combo(this.structPrimComposite, 128);
        this.messageCombo.setLayoutData((Object)comboData);
        this.messageComboViewer = new ComboViewer(this.messageCombo);
        this.messageComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.messageComboViewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.wfme));
        this.classBrowseComposite = new Composite((Composite)this.messageComposite, 0);
        GridLayout classBrowseLayout = new GridLayout();
        classBrowseLayout.numColumns = 1;
        GridData classBrowseData = new GridData();
        classBrowseData.grabExcessHorizontalSpace = true;
        classBrowseData.grabExcessVerticalSpace = true;
        classBrowseData.verticalAlignment = 4;
        classBrowseData.horizontalAlignment = 4;
        this.classBrowseComposite.setLayout((Layout)classBrowseLayout);
        this.classBrowseComposite.setLayoutData((Object)classBrowseData);
        this.classBrowser = new TypeSelectionComposite(this.classBrowseComposite, Modeling_Messages.PlainJavaPropertyPage_LB_Plain_Java);
        this.classBrowser.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MessageAdditionDialog.this.serializableTypeModified(e);
            }
        });
        this.stack.topControl = this.classBrowseComposite;
        parent.getShell().setMinimumSize(300, 150);
        parent.getShell().setText(String.valueOf(Modeling_Messages.TXT_ADD) + this.controller.getNameString());
        return comp;
    }

    private void initCombos() {
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    MessageAdditionDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                    String text = MessageAdditionDialog.this.messageType.getId();
                    int n = 1;
                    while (MessageAdditionDialog.this.isAccessPointIdDefined(String.valueOf(text) + n)) {
                        ++n;
                    }
                    text = String.valueOf(text) + n;
                    MessageAdditionDialog.this.messageNameText.setText(text);
                    MessageAdditionDialog.this.messageNameText.setSelection(0, MessageAdditionDialog.this.messageNameText.getText().length());
                }
                MessageAdditionDialog.this.buttonEnablement();
            }
        });
        this.dataTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                MessageAdditionDialog.this.selectedFilter = (ViewerFilter)selection.getFirstElement();
                MessageAdditionDialog.this.messageComboViewer.setFilters(new ViewerFilter[]{MessageAdditionDialog.this.selectedFilter});
                ((MessageAdditionDialog)MessageAdditionDialog.this).stack.topControl = MessageAdditionDialog.this.selectedFilter instanceof SerializableFilter ? MessageAdditionDialog.this.classBrowseComposite : MessageAdditionDialog.this.structPrimComposite;
                MessageAdditionDialog.this.messageComposite.setText(String.valueOf(Modeling_Messages.TXT_SEL) + MessageAdditionDialog.this.selectedFilter.toString());
                MessageAdditionDialog.this.messageComposite.layout();
            }
        });
        this.messageComboViewer.setInput(this.controller.getAvailableMessageTypes());
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    MessageAdditionDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                }
            }
        });
        this.dataTypeComboViewer.setInput((Object)this.typeFilters);
        ArrayList filterSelection = new ArrayList();
        filterSelection.add(this.typeFilters.get(0));
        this.dataTypeComboViewer.setSelection((ISelection)new StructuredSelection(filterSelection));
        ArrayList<AccessPointType> selection = new ArrayList<AccessPointType>();
        selection.add(this.controller.getAvailableMessageTypes().get(0));
        this.messageNameText.setSelection(0, this.messageNameText.getText().length());
    }

    protected void buttonEnablement() {
        String text = this.messageNameText.getText();
        this.errorLabel.setVisible(this.isError);
        if (this.getButton(0) != null) {
            if (this.selectedFilter instanceof SerializableFilter) {
                this.getButton(0).setEnabled(!this.isError && !text.equalsIgnoreCase("") && text.indexOf(" ") == -1);
            } else {
                this.getButton(0).setEnabled(!this.isError && !text.equalsIgnoreCase("") && text.indexOf(" ") == -1 && this.messageCombo.getSelectionIndex() != -1);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.initCombos();
        this.buttonEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.messageName = this.messageNameText.getText();
        }
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent arg0) {
        String text = this.messageNameText.getText();
        if (!this.controller.isSimpleMode()) {
            if (this.getMessageTypeByName(text) != null) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_DOES_ALREADY_EXIST, text));
            } else if (!StringUtils.isValidIdentifier((String)text)) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
            } else {
                this.isError = false;
                this.errorLabel.setToolTipText(null);
            }
        } else if (!StringUtils.isValidIdentifier((String)text)) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
        } else {
            this.isError = false;
            this.errorLabel.setToolTipText(null);
        }
        this.buttonEnablement();
    }

    private void serializableTypeModified(ModifyEvent e) {
        AccessPointType apt;
        String messageName;
        String text = messageName = this.classBrowser.getType().getType().getElementName();
        int n = 1;
        while (this.isAccessPointIdDefined(String.valueOf(text) + n)) {
            ++n;
        }
        text = String.valueOf(text) + n;
        this.messageNameText.setText(text);
        this.messageType = apt = this.controller.getMtaUtils().createSerializableAccessPoint(this.classBrowser.getType(), text, this.directionType);
    }

    public AccessPointType getMessageType() {
        return this.messageType;
    }

    public String getMessageName() {
        return this.messageName;
    }

    private boolean isAccessPointIdDefined(String id) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(name)) continue;
            return messageType;
        }
        return null;
    }
}

