/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.modeling.validation.AccessPathEvaluationContext;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.StructDataMappingUtils;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class BridgeObject {
    private IType endClass;
    private final DirectionType direction;
    private final String label;

    public BridgeObject(IType endClass, DirectionType direction) {
        this.endClass = endClass;
        this.direction = direction;
        this.label = endClass == null ? null : endClass.getFullyQualifiedName();
    }

    public BridgeObject(IType endClass, DirectionType direction, String label) {
        this.endClass = endClass;
        this.direction = direction;
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public IType getEndClass() {
        return this.endClass;
    }

    public DirectionType getDirection() {
        return this.direction;
    }

    public boolean acceptAssignmentFrom(BridgeObject rhs) {
        if (this.direction == DirectionType.OUT_LITERAL) {
            return false;
        }
        if (rhs.direction == DirectionType.IN_LITERAL) {
            return false;
        }
        return TypeFinder.isAssignable(this.getEndClass(), rhs.getEndClass());
    }

    public static BridgeObject getBridge(ITypedElement ap, String path, DirectionType direction) throws ValidationException {
        return BridgeObject.getBridge(ap, path, direction, null);
    }

    public static BridgeObject getBridge(ITypedElement ap, String path, DirectionType direction, AccessPathEvaluationContext context) throws ValidationException {
        IBridgeObjectProvider bridgeProvider = ValidatorRegistry.getBridgeObjectProvider(ap);
        BridgeObject result = bridgeProvider != null ? bridgeProvider.getBridgeObject(ap, path, direction) : new BridgeObject(JavaDataTypeUtils.getTypeFromCurrentProject(Object.class.getName()), direction);
        return result;
    }

    public static void checkMapping(ITypedElement left, String leftPath, ITypedElement right, String rightPath) throws ValidationException {
        BridgeObject.checkMapping(left, leftPath, right, rightPath, null);
    }

    public static void checkMapping(ITypedElement left, String leftPath, ITypedElement right, String rightPath, ActivityType activity) throws ValidationException {
        BridgeObject leftBridge = BridgeObject.getBridge(left, leftPath, DirectionType.IN_LITERAL, new AccessPathEvaluationContext(right, rightPath, activity));
        BridgeObject rightBridge = BridgeObject.getBridge(right, rightPath, DirectionType.OUT_LITERAL, new AccessPathEvaluationContext(left, leftPath, activity));
        if (StructDataMappingUtils.isVizRulesApplication(activity) && (BridgeObject.isAssignable(rightBridge.getEndClass(), Map.class) && BridgeObject.isAssignable(leftBridge.getEndClass(), Serializable.class) || BridgeObject.isAssignable(rightBridge.getEndClass(), Serializable.class) && BridgeObject.isAssignable(leftBridge.getEndClass(), Map.class))) {
            return;
        }
        if (!leftBridge.acceptAssignmentFrom(rightBridge)) {
            throw new ValidationException(MessageFormat.format(Validation_Messages.BridgeObject_assignmentNotCompatible, leftBridge, rightBridge), rightPath == null || rightPath.length() == 0 ? right : rightPath);
        }
    }

    private static boolean isAssignable(IType type, Class<?> clazz) {
        if (type == null || clazz == null) {
            return false;
        }
        try {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType clazzType = JavaDataTypeUtils.getTypeFromCurrentProject(clazz.getName());
            return typeHierarchy.contains(clazzType);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

