/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.IValidationExtensionRegistry;
import org.eclipse.stardust.modeling.validation.ValidationExtensionRegistry;

public class ValidatorRegistry {
    private static final IModelValidator[] EMPTY_MODEL_VALIDATORS = new IModelValidator[0];
    private static final IModelElementValidator[] EMPTY_MODEL_ELEMENT_VALIDATORS = new IModelElementValidator[0];
    private static IValidationExtensionRegistry validationExtensionRegistry = ValidationExtensionRegistry.getInstance();
    private static ThreadLocal<Map<String, String>> filterSet = new ThreadLocal();

    public static void setValidationExtensionRegistry(IValidationExtensionRegistry validationExtensionRegistry) {
        ValidatorRegistry.validationExtensionRegistry = validationExtensionRegistry;
    }

    public static void setFilters(Map<String, String> filters) {
        filterSet.set(filters);
    }

    public static Map<String, String> getFilters() {
        return filterSet.get();
    }

    public static IModelValidator[] getModelValidators() {
        List result = null;
        IConfigurationElement[] extensions = validationExtensionRegistry.getConfigurationElementsFor("org.eclipse.stardust.modeling.validation.modelValidator");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            try {
                IModelValidator validator = (IModelValidator)extension.createExecutableExtension("class");
                if (result == null) {
                    result = CollectionUtils.newList();
                }
                result.add(validator);
            }
            catch (Exception exception) {}
            ++i;
        }
        return result == null ? EMPTY_MODEL_VALIDATORS : result.toArray(new IModelValidator[result.size()]);
    }

    public static IBridgeObjectProvider getBridgeObjectProvider(ITypedElement modelElement) {
        IMetaType type = modelElement.getMetaType();
        if (type != null) {
            String id = type.getId();
            IConfigurationElement[] extensions = validationExtensionRegistry.getConfigurationElementsFor("org.eclipse.stardust.modeling.validation.bridgeObjectProvider");
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement extension = extensions[i];
                try {
                    Object provider;
                    String dataTypeId = extension.getAttribute("dataTypeId");
                    if (CompareHelper.areEqual((Object)dataTypeId, (Object)id) && IBridgeObjectProvider.class.isInstance(provider = extension.createExecutableExtension("class"))) {
                        return (IBridgeObjectProvider)provider;
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        return null;
    }

    public static IModelElementValidator[] getModelElementValidators(IModelElement element) {
        List result = null;
        IConfigurationElement[] extensions = validationExtensionRegistry.getConfigurationElementsFor("org.eclipse.stardust.modeling.validation.modelElementValidator");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            if (SpiExtensionRegistry.isMatchingElement((EObject)element, (String)"targetType", ValidatorRegistry.getFilters(), (IConfigurationElement)extension)) {
                try {
                    IModelElementValidator validator = (IModelElementValidator)extension.createExecutableExtension("class");
                    if (result == null) {
                        result = CollectionUtils.newList();
                    }
                    result.add(validator);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return result == null ? EMPTY_MODEL_ELEMENT_VALIDATORS : result.toArray(new IModelElementValidator[result.size()]);
    }
}

