/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.XPathAnnotations;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;

public class DataPathValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        DataPathType other;
        ArrayList<Issue> result = new ArrayList<Issue>();
        DataPathType dataPath = (DataPathType)element;
        if (!StringUtils.isValidIdentifier((String)dataPath.getId())) {
            result.add(Issue.error((EObject)dataPath, Validation_Messages.ERR_DATAPATH_NotValidIdentifier, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (this.findDuplicateId(dataPath)) {
            result.add(Issue.error((EObject)dataPath, Validation_Messages.ERR_DATAPATH_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        DataType data = dataPath.getData();
        if (!(!"PROCESS_ATTACHMENTS".equals(dataPath.getId()) || (other = this.findOtherDataPath(dataPath)) != null && data != null && data == other.getData() && "dmsDocumentList".equals(data.getType().getId()) && StringUtils.isEmpty((String)dataPath.getDataPath()) && StringUtils.isEmpty((String)other.getDataPath()))) {
            result.add(Issue.warning((EObject)dataPath, MessageFormat.format(Validation_Messages.WR_IS_A_RESERVED_IDENTIFIER, "PROCESS_ATTACHMENTS"), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (StringUtils.isEmpty((String)dataPath.getName())) {
            result.add(Issue.error((EObject)dataPath, Validation_Messages.ERR_DATAPATH_NoNameSpecified, ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        }
        if (data == null) {
            result.add(Issue.error((EObject)dataPath, Validation_Messages.ERR_DATAPATH_NoDataSpecified, ValidationService.PKG_CWM.getDataPathType_Data()));
        } else {
            IBridgeObjectProvider dataBridgeProvider;
            if (!StringUtils.isEmpty((String)dataPath.getDataPath()) && (dataBridgeProvider = ValidatorRegistry.getBridgeObjectProvider((ITypedElement)data)) != null) {
                try {
                    dataBridgeProvider.getBridgeObject((ITypedElement)data, dataPath.getDataPath(), DirectionType.OUT_LITERAL.equals((Object)dataPath.getDirection()) ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL);
                }
                catch (Exception exception) {
                    result.add(Issue.warning((EObject)dataPath, Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, ValidationService.PKG_CWM.getDataPathType_DataPath()));
                }
            }
            if (dataPath.isKey()) {
                if (dataPath.isDescriptor()) {
                    String dataTypeId = data.getType().getId();
                    if (!"primitive".equals(dataTypeId)) {
                        String accessPath = dataPath.getDataPath();
                        if (!"struct".equals(dataTypeId)) {
                            result.add(Issue.error((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_PRIMITIVE_STRUCTURED, ValidationService.PKG_CWM.getDataPathType_Key()));
                        } else if (accessPath == null || accessPath.length() == 0) {
                            result.add(Issue.error((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_PRIMITIVE, ValidationService.PKG_CWM.getDataPathType_Key()));
                        } else {
                            try {
                                IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((DataType)data);
                                if (StructuredDataXPathUtils.returnSinglePrimitiveType((String)accessPath, (IXPathMap)xPathMap) == -1) {
                                    result.add(Issue.error((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_PRIMITIVE, ValidationService.PKG_CWM.getDataPathType_Key()));
                                } else {
                                    XPathAnnotations xPathAnnotations = StructuredDataXPathUtils.getXPathAnnotations((String)accessPath, (IXPathMap)xPathMap);
                                    if (!xPathAnnotations.isIndexed() || !xPathAnnotations.isPersistent()) {
                                        result.add(Issue.error((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_INDEXED_PERSISTENT, ValidationService.PKG_CWM.getDataPathType_Key()));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                result.add(Issue.error((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_NO_SCHEMA, ValidationService.PKG_CWM.getDataPathType_Key()));
                            }
                        }
                    }
                } else {
                    result.add(Issue.warning((EObject)dataPath, Validation_Messages.MSG_KEY_DESCRIPTOR_NO_DESCRIPTOR, ValidationService.PKG_CWM.getDataPathType_Key()));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private DataPathType findOtherDataPath(DataPathType dataPath) {
        EList allPaths = ModelUtils.findContainingProcess((EObject)dataPath).getDataPath();
        for (DataPathType otherDataPath : allPaths) {
            if (otherDataPath == dataPath || !CompareHelper.areEqual((Object)otherDataPath.getId(), (Object)dataPath.getId()) || !CompareHelper.areEqual((Object)otherDataPath.getDirection(), (Object)this.oposite(dataPath.getDirection()))) continue;
            return otherDataPath;
        }
        return null;
    }

    private Object oposite(DirectionType direction) {
        if (direction == null) {
            return null;
        }
        switch (direction) {
            case IN_LITERAL: {
                return DirectionType.OUT_LITERAL;
            }
            case OUT_LITERAL: {
                return DirectionType.IN_LITERAL;
            }
        }
        return direction;
    }

    private boolean findDuplicateId(DataPathType dataPath) {
        EList allPaths = ModelUtils.findContainingProcess((EObject)dataPath).getDataPath();
        for (DataPathType otherDataPath : allPaths) {
            if (otherDataPath == dataPath || !CompareHelper.areEqual((Object)otherDataPath.getId(), (Object)dataPath.getId()) || !CompareHelper.areEqual((Object)otherDataPath.getDirection(), (Object)dataPath.getDirection())) continue;
            return true;
        }
        return false;
    }
}

