/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DefaultDataValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        DataType data = (DataType)element;
        if (this.findDuplicateId(data)) {
            result.add(Issue.error((EObject)data, Validation_Messages.MSG_DuplicateDataId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (this.fullCheck() && data.getType() == null) {
            result.add(Issue.error((EObject)data, Validation_Messages.MSG_DataHasNoType, ValidationService.PKG_CWM.getDataType_Type()));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(DataType data) {
        for (DataType otherData : ModelUtils.findContainingModel((EObject)data).getData()) {
            if (otherData.getId() == null || !otherData.getId().equals(data.getId()) || data.equals(otherData)) continue;
            return true;
        }
        return false;
    }

    protected boolean fullCheck() {
        return true;
    }
}

