/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class IdentifiableModelElementValidator
implements IModelElementValidator {
    public static final int MAX_ID_LENGTH = 50;

    public static void validateIdentifiableElement(IIdentifiableElement ie, List result) {
        String elementId = ie.getId();
        if (StringUtils.isEmpty((String)elementId)) {
            result.add(Issue.error((EObject)((IModelElement)(ie instanceof IModelElement ? ie : null)), Validation_Messages.ERR_ELEMENT_EmptyId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        } else {
            if (elementId.length() > 50) {
                result.add(Issue.error((EObject)((IModelElement)(ie instanceof IModelElement ? ie : null)), MessageFormat.format(Validation_Messages.ERR_ELEMENT_IdLength, String.valueOf(50)), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            if ((ie instanceof DataType || ie instanceof AccessPointType) && !ModelUtils.isValidId((String)elementId)) {
                result.add(Issue.warning((EObject)((IModelElement)(ie instanceof IModelElement ? ie : null)), MessageFormat.format(Validation_Messages.ERR_ELEMENT_InvalidId, elementId), ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
        }
        if (StringUtils.isEmpty((String)ie.getName())) {
            result.add(Issue.warning((EObject)((IModelElement)(ie instanceof IModelElement ? ie : null)), Validation_Messages.MSG_ELEMENT_EmptyName, ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        }
    }

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList result = new ArrayList();
        if (element instanceof IIdentifiableModelElement) {
            IdentifiableModelElementValidator.validateIdentifiableElement((IIdentifiableElement)((IIdentifiableModelElement)element), result);
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

