/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.compatibility.el.EvaluationError;
import org.eclipse.stardust.engine.core.compatibility.el.Interpreter;
import org.eclipse.stardust.engine.core.compatibility.el.SymbolTable;
import org.eclipse.stardust.engine.core.compatibility.el.SyntaxError;
import org.eclipse.stardust.engine.core.pojo.data.PrimitiveAccessPathEvaluator;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPoint;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.xpdl2.ScriptType;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.stardust.modeling.javascript.editor.JavaScriptValidator;
import org.eclipse.stardust.modeling.javascript.editor.controller.JavaScriptEditorController;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.impl.ElValidationIDataAdapter;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.IProblem;

public class TransitionValidator
implements IModelElementValidator {
    private static final String CARNOT_EL = "carnotEL: ";
    private static final String ECMA_LANGUAGE = "text/ecmascript";

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        ArrayList<Issue> result = new ArrayList<Issue>();
        TransitionType transition = (TransitionType)element;
        XmlTextNode expression = transition.getExpression();
        String expressionValue = null;
        String condition = transition.getCondition();
        boolean needsValidation = true;
        ScriptType script = model.getScript();
        String language = script.getType();
        if (!StringUtils.isEmpty((String)language) && language.equals(ECMA_LANGUAGE)) {
            if (condition != null && condition.equals("OTHERWISE")) {
                needsValidation = false;
            } else if (condition != null && condition.equals("CONDITION") && ((expressionValue = ModelUtils.getCDataString((FeatureMap)expression.getMixed())).equals("true") || expressionValue.equals("false"))) {
                needsValidation = false;
            }
            if (needsValidation) {
                if (expressionValue != null && expressionValue.startsWith(CARNOT_EL)) {
                    result.add(Issue.error((EObject)transition, Validation_Messages.MSG_TransitionCondUpdate, CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Expression()));
                } else {
                    IProject project = ModelUtils.getProjectFromEObject((EObject)element);
                    IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
                    try {
                        EditorUtils.addJSSupport((IProject)project, (ModelType)model);
                    }
                    catch (CoreException coreException) {}
                    JavaScriptValidator javaScriptValidator = new JavaScriptValidator(javaProject);
                    JavaScriptEditorController controller = new JavaScriptEditorController();
                    controller.intializeModel(model);
                    String toCheck = controller.getJScript();
                    toCheck = String.valueOf(toCheck) + "\n" + expressionValue;
                    toCheck = VariableContextHelper.getInstance().getContext(model).replaceAllVariablesByDefaultValue(toCheck);
                    IProblem[] test = javaScriptValidator.validate(toCheck);
                    if (test.length > 0) {
                        test[0].getMessage();
                        result.add(Issue.warning((EObject)transition, Validation_Messages.MSG_InvalidJavaScriptTransitionCondition));
                    }
                }
            }
        } else {
            condition = expression != null ? ModelUtils.getCDataString((FeatureMap)expression.getMixed()) : transition.getCondition();
            if (condition == null || condition.trim().length() == 0) {
                result.add(Issue.error((EObject)transition, MessageFormat.format(Validation_Messages.MSG_EmptyTransitionCond, null), CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Condition()));
                needsValidation = false;
            }
            if (needsValidation) {
                try {
                    Interpreter.evaluate((String)condition, (SymbolTable)new SymbolTableAdapter(model));
                }
                catch (SyntaxError e) {
                    result.add(Issue.error((EObject)transition, MessageFormat.format(Validation_Messages.MSG_SyntaxInvalidTransitionCond, e.getMessage()), CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Condition()));
                }
                catch (EvaluationError e) {
                    result.add(Issue.error((EObject)transition, MessageFormat.format(Validation_Messages.MSG_SemanticInvalidTransitionCond, e.getMessage()), CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Condition()));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    public static class SymbolTableAdapter
    implements SymbolTable {
        private final ModelType model;

        public SymbolTableAdapter(ModelType model) {
            this.model = model;
        }

        public Object lookupSymbol(String name) {
            AccessPoint data = this.lookupSymbolType(name);
            if (data == null) {
                throw new PublicException(MessageFormat.format(Validation_Messages.MSG_InvalidSymbol, name));
            }
            Object result = null;
            if (data.getType() != null) {
                PrimitiveAccessPathEvaluator pojoEvaluator;
                if (data.getType().getId() == null) {
                    Object typeHint = data.getAttribute("carnot:engine:typeHint");
                    if ("text".equals(typeHint)) {
                        result = "";
                    } else if ("numeric".equals(typeHint)) {
                        result = new Double(0.0);
                    } else if ("complex".equals(typeHint)) {
                        result = new Serializable(){
                            private static final long serialVersionUID = 1L;
                        };
                    }
                } else if ("primitive".equals(data.getType().getId()) && (result = (pojoEvaluator = new PrimitiveAccessPathEvaluator()).createDefaultValue(data.getAllAttributes())) == null) {
                    result = pojoEvaluator.createInitialValue(data.getAllAttributes());
                }
            }
            return result;
        }

        public AccessPoint lookupSymbolType(String name) {
            DataType data = null;
            if ("activityInstance".equals(name)) {
                DataType activityInstance = CarnotWorkflowModelFactory.eINSTANCE.createDataType();
                activityInstance.setId("activityInstance");
                activityInstance.setName("Activity Instance");
                activityInstance.setPredefined(true);
                DataTypeType serializableDataType = (DataTypeType)ModelUtils.findElementById((List)this.model.getDataType(), (String)"serializable");
                activityInstance.setType(serializableDataType);
                AttributeUtil.setAttribute((IExtensibleElement)activityInstance, (String)"carnot:engine:browsable", (String)"true");
                AttributeUtil.setAttribute((IExtensibleElement)activityInstance, (String)"carnot:engine:className", (String)"ag.carnot.workflow.runtime.ActivityInstance");
                data = activityInstance;
            } else {
                data = (DataType)ModelUtils.findIdentifiableElement((List)this.model.getData(), (String)name);
            }
            if (data == null) {
                throw new PublicException(MessageFormat.format(Validation_Messages.MSG_InvalidSymbol, name));
            }
            return new ElValidationIDataAdapter(data);
        }
    }
}

