/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.actionTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.runtime.beans.IUser;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;

public class ExcludeUserActionValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:excludedPerformerData");
        String dataPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:excludedPerformerDataPath");
        if (!(dataId instanceof String) || StringUtils.isEmpty((String)dataId)) {
            result.add(Issue.error((EObject)element, Validation_Messages.MSG_NoDataSpecified));
        } else {
            DataType data = ModelUtils.findData((IModelElement)element, (String)dataId);
            if (data != null) {
                try {
                    BridgeObject rhs = BridgeObject.getBridge((ITypedElement)data, dataPath, DirectionType.OUT_LITERAL);
                    BridgeObject lhsUserOid = JavaDataTypeUtils.getBridgeObject(Long.class.getName(), null, DirectionType.IN_LITERAL);
                    BridgeObject lhsIUser = JavaDataTypeUtils.getBridgeObject(IUser.class.getName(), null, DirectionType.IN_LITERAL);
                    if (!lhsUserOid.acceptAssignmentFrom(rhs) && !lhsIUser.acceptAssignmentFrom(rhs)) {
                        result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.BridgeObject_assignmentNotCompatible, Validation_Messages.MSG_WorkflowUser, rhs), StringUtils.isEmpty((String)dataPath) ? "carnot:engine:excludedPerformerData" : "carnot:engine:excludedPerformerDataPath"));
                    }
                }
                catch (ValidationException e) {
                    result.add(Issue.error((EObject)element, e.getMessage(), StringUtils.isEmpty((String)dataPath) ? "carnot:engine:excludedPerformerData" : "carnot:engine:excludedPerformerDataPath"));
                }
            } else {
                result.add(Issue.error((EObject)element, Validation_Messages.MSG_InvalidDataSpecified));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

