/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class PlainJavaValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        IType type = null;
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        className = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(className);
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_JavaClassNotSpecified, "carnot:engine:className"));
        } else {
            type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), "carnot:engine:className"));
            }
        }
        String constructorName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:constructorName");
        constructorName = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(constructorName);
        if (StringUtils.isEmpty((String)constructorName)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_ConstructorNotSpecified, "carnot:engine:constructorName"));
        } else if (type != null) {
            MethodInfo constructor = typeFinder.getConstructor(type, constructorName);
            if (constructor == null) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_CouldntFindConstructor, constructorName, type.getElementName()), "carnot:engine:constructorName"));
            } else if (!constructor.isAccessible()) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_ConstructorNotVisible, constructorName, type.getElementName()), "carnot:engine:constructorName"));
            }
        }
        String method = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
        method = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(method);
        if (StringUtils.isEmpty((String)method)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_CompletionMethodNotSpecified, "carnot:engine:methodName"));
        } else if (type != null) {
            MethodInfo info = typeFinder.getMethod(type, method);
            if (info == null) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, type.getElementName()), "carnot:engine:methodName"));
            } else if (!info.isAccessible()) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_MethodNotVisible, method, type.getElementName()), "carnot:engine:methodName"));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

