/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class SessionBean20Validator
implements IModelElementValidator {
    private static final int HOME = 0;
    private static final int REMOTE = 1;
    private static final String[] classAttrNames = new String[]{"carnot:engine:homeInterface", "carnot:engine:remoteInterface", "carnot:engine:jndiPath"};
    private static final String[] interfaceNames = new String[]{"Home", "Remote"};
    private static final String[] methodAttrNames = new String[]{"carnot:engine:createMethodName", "carnot:engine:methodName"};
    private static final String[] methodNames = new String[]{"Creation", "Completion"};
    private ModelType model;

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (element instanceof ApplicationType) {
            ApplicationType sessionBean = (ApplicationType)element;
            ModelType cfr_ignored_0 = (ModelType)element.eContainer();
            String createdTypeName = this.checkMethod(sessionBean, 0, result);
            this.checkMethod(sessionBean, 1, result);
            String componentTypeName = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)classAttrNames[1]);
            if (!StringUtils.isEmpty((String)createdTypeName) && !StringUtils.isEmpty((String)componentTypeName)) {
                TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
                IType createdType = typeFinder.findExactType(createdTypeName);
                IType componentType = typeFinder.findExactType(componentTypeName);
                if (!TypeFinder.isAssignable(componentType, createdType)) {
                    result.add(Issue.warning((EObject)sessionBean, Validation_Messages.SessionBean_IncompatibleCreatedType, "carnot:engine:createMethodName"));
                }
            }
            this.checkJndiPath(result, (IExtensibleElement)sessionBean);
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkJndiPath(List result, IExtensibleElement element) {
        if (AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)classAttrNames[2]) == null) {
            result.add(Issue.warning((EObject)((IModelElement)element), MessageFormat.format(Validation_Messages.Validation_MSG_JNDIPathNotSpecified, new String[0]), classAttrNames[2]));
        }
    }

    private String checkMethod(ApplicationType sessionBean, int type, List issues) {
        TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
        IType iType = null;
        boolean isLocal = AttributeUtil.getBooleanValue((IExtensibleElement)sessionBean, (String)"carnot:engine:isLocal");
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)classAttrNames[type]);
        className = VariableContextHelper.getInstance().getContext(this.model).replaceAllVariablesByDefaultValue(className);
        String rType = null;
        if (className == null) {
            issues.add(Issue.warning((EObject)sessionBean, MessageFormat.format(Validation_Messages.MSG_InterfaceNotSpecified, interfaceNames[type]), classAttrNames[type]));
        } else {
            iType = typeFinder.findExactType(className);
        }
        if (iType == null) {
            issues.add(Issue.error((EObject)sessionBean, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), classAttrNames[type]));
        } else {
            String method;
            if (!isLocal) {
                Object[] objectArray;
                if (type == 1) {
                    Object[] objectArray2 = new String[3];
                    objectArray2[0] = className;
                    objectArray2[1] = EJBObject.class.getName();
                    objectArray = objectArray2;
                    objectArray2[2] = EJBLocalObject.class.getName();
                } else {
                    String[] stringArray = new String[3];
                    stringArray[0] = className;
                    stringArray[1] = EJBHome.class.getName();
                    objectArray = stringArray;
                    stringArray[2] = EJBLocalHome.class.getName();
                }
                Object[] interfaces = objectArray;
                if (!typeFinder.implementsInterface(iType, interfaces[1]) && !typeFinder.implementsInterface(iType, interfaces[2])) {
                    issues.add(Issue.warning((EObject)sessionBean, MessageFormat.format(Validation_Messages.MSG_SessionBean_InvalidEjbTypeSignature, interfaces), classAttrNames[type]));
                }
            }
            if (StringUtils.isEmpty((String)(method = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)methodAttrNames[type])))) {
                issues.add(Issue.warning((EObject)sessionBean, MessageFormat.format(Validation_Messages.MSG_MethodNotSpecified, methodNames[type]), methodAttrNames[type]));
            } else {
                MethodInfo info = typeFinder.getMethod(iType, method);
                if (info == null) {
                    issues.add(Issue.warning((EObject)sessionBean, MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, iType.getElementName()), methodAttrNames[type]));
                } else {
                    rType = info.getReturnType();
                }
            }
        }
        return rType;
    }
}

