/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.ProjectClassLoader;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class WebserviceApplicationValidator
implements IModelElementValidator {
    private static final String[] messages = new String[]{Validation_Messages.MSG_NoTypeMappingDefined, Validation_Messages.MSG_XMLTypeHasInvalidMapping, Validation_Messages.MSG_TemplateIsInvalid, Validation_Messages.MSG_WSDL_URLIsInvalid, Validation_Messages.MSG_PropertyNotSet};

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList result = new ArrayList();
        result.addAll(this.checkProperty(element, "carnot:engine:wsdlUrl"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsServiceName"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsPortName"));
        result.addAll(this.checkProperty(element, "carnot:engine:wsOperationName"));
        for (AttributeType attribute : ((IExtensibleElement)element).getAttribute()) {
            String key = attribute.getName();
            if (key.startsWith("carnot:engine:mapping:")) {
                result.addAll(this.checkTypeMapping(element, attribute));
                continue;
            }
            if (key.startsWith("carnot:engine:template:")) {
                result.addAll(this.checkXmlTemplate(element, attribute));
                continue;
            }
            if (!key.equals("carnot:engine:wsdlUrl")) continue;
            result.addAll(this.checkWsdlUrl(element, attribute));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private List checkTypeMapping(IModelElement element, AttributeType attribute) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String key = attribute.getName();
        String xmlType = key.substring("carnot:engine:mapping:".length());
        String clazz = attribute.getValue();
        if (StringUtils.isEmpty((String)clazz)) {
            result.add(Issue.warning((EObject)element, MessageFormat.format(messages[0], xmlType)));
        } else {
            TypeFinder finder = new TypeFinder((EObject)element);
            if (finder.findExactType(clazz) == null) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(messages[1], xmlType, clazz)));
            }
        }
        return result;
    }

    private List checkXmlTemplate(IModelElement element, AttributeType attribute) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String key = attribute.getName();
        String name = key.substring("carnot:engine:template:".length());
        String xml = attribute.getValue();
        if (!StringUtils.isEmpty((String)xml)) {
            try {
                XmlUtils.parseString((String)xml);
            }
            catch (Exception exception) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(messages[2], name)));
            }
        }
        return result;
    }

    private List checkWsdlUrl(IModelElement element, AttributeType attribute) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String uri = attribute.getValue();
        if (uri != null) {
            uri = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer()).replaceAllVariablesByDefaultValue(uri);
        }
        if (!StringUtils.isEmpty((String)uri)) {
            ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    IProject project = ModelUtils.getProjectFromEObject((EObject)element);
                    Thread.currentThread().setContextClassLoader(new ProjectClassLoader(XmlUtils.class.getClassLoader(), project, uri.startsWith("/") ? uri.substring(1) : uri));
                    new URL(XmlUtils.resolveResourceUri((String)uri));
                }
                catch (Exception exception) {
                    result.add(Issue.warning((EObject)element, MessageFormat.format(messages[3], uri)));
                    Thread.currentThread().setContextClassLoader(cclBackup);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cclBackup);
            }
        }
        return result;
    }

    private List checkProperty(IModelElement element, String name) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String property = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)name);
        if (StringUtils.isEmpty((String)property)) {
            result.add(Issue.error((EObject)element, MessageFormat.format(messages[4], name), name));
        }
        return result;
    }
}

