/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.conditionTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class ExceptionConditionValidator
implements IModelElementValidator {
    private static final String EXCEPTION_CLASS_ATT = "carnot:engine:exceptionName";
    private static final String[] messages = new String[]{Validation_Messages.MSG_IsNotException, Validation_Messages.MSG_MissingException};

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        try {
            String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)EXCEPTION_CLASS_ATT);
            if (className != null) {
                if (!TypeFinder.isAssignable(JavaDataTypeUtils.getTypeFromCurrentProject(Exception.class.getName()), JavaDataTypeUtils.getTypeFromCurrentProject(className))) {
                    result.add(Issue.warning((EObject)element, MessageFormat.format(messages[0], className)));
                }
            } else {
                result.add(Issue.warning((EObject)element, MessageFormat.format(messages[1], ((IIdentifiableModelElement)element).getName())));
            }
        }
        catch (Exception ex) {
            result.add(Issue.warning((EObject)element, ex.getMessage()));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

