/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.contextTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class JFCValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        if (className == null) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_JFC_UnspecifiedClass, "carnot:engine:className"));
        } else {
            TypeFinder typeFinder = new TypeFinder((EObject)element);
            className = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer()).replaceAllVariablesByDefaultValue(className);
            IType type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_JFC_CouldntFindClass, className), "carnot:engine:className"));
            } else {
                String methodName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
                if (methodName == null) {
                    result.add(Issue.warning((EObject)element, Validation_Messages.MSG_JFC_UnspecifiedCompletionMethod, "carnot:engine:methodName"));
                } else {
                    methodName = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer()).replaceAllVariablesByDefaultValue(methodName);
                    MethodInfo info = typeFinder.getMethod(type, methodName);
                    if (info == null) {
                        result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_JFC_CouldntFindCompletionMethod, methodName), "carnot:engine:methodName"));
                    } else if (!info.isAccessible()) {
                        result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_MethodNotVisible, methodName, type.getElementName()), "carnot:engine:methodName"));
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

