/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.dataTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class EntityBean20Validator
implements IModelElementValidator,
IBridgeObjectProvider {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        Object[] interfaces;
        ArrayList<Issue> result = new ArrayList<Issue>();
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        IType type = null;
        boolean isLocal = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:isLocal");
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:remoteInterface");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoRemoteIF, "carnot:engine:remoteInterface"));
        } else {
            type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), "carnot:engine:remoteInterface"));
            } else if (!(isLocal || typeFinder.implementsInterface(type, (interfaces = new String[]{className, EJBObject.class.getName(), EJBLocalObject.class.getName()})[1]) || typeFinder.implementsInterface(type, interfaces[2]))) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_EntityBean_InvalidEjbTypeSignature, interfaces), "carnot:engine:remoteInterface"));
            }
        }
        className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:homeInterface");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoHomeIF, "carnot:engine:homeInterface"));
        } else {
            type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), "carnot:engine:homeInterface"));
            } else if (!(isLocal || typeFinder.implementsInterface(type, (String)(interfaces = new String[]{className, EJBHome.class.getName(), EJBLocalHome.class.getName()})[1]) || typeFinder.implementsInterface(type, (String)interfaces[2]))) {
                result.add(Issue.warning((EObject)element, MessageFormat.format(Validation_Messages.MSG_EntityBean_InvalidEjbTypeSignature, interfaces), "carnot:engine:homeInterface"));
            }
        }
        className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:primaryKey");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoPrimaryKey, "carnot:engine:primaryKey"));
        } else {
            type = typeFinder.findExactType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), "carnot:engine:primaryKey"));
            }
        }
        if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:jndiPath"))) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoJNDI, "carnot:engine:jndiPath"));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    @Override
    public BridgeObject getBridgeObject(ITypedElement accessPoint, String accessPath, DirectionType direction) throws ValidationException {
        BridgeObject javaBridge = JavaDataTypeUtils.getBridgeObject(accessPoint, accessPath, direction);
        return new EntityBeanBridgeObject(javaBridge.getEndClass(), javaBridge.getDirection());
    }

    private class EntityBeanBridgeObject
    extends BridgeObject {
        public EntityBeanBridgeObject(IType type, DirectionType direction) {
            super(type, direction);
        }

        @Override
        public boolean acceptAssignmentFrom(BridgeObject rhs) {
            if (this.getDirection() == DirectionType.OUT_LITERAL) {
                return false;
            }
            if (rhs.getDirection() == DirectionType.IN_LITERAL) {
                return false;
            }
            return TypeFinder.isAssignable(this.getEndClass(), rhs.getEndClass()) || TypeFinder.isAssignable(rhs.getEndClass(), JavaDataTypeUtils.getTypeFromCurrentProject(EJBObject.class.getName())) || TypeFinder.isAssignable(rhs.getEndClass(), JavaDataTypeUtils.getTypeFromCurrentProject(EJBLocalObject.class.getName())) || TypeFinder.isAssignable(rhs.getEndClass(), JavaDataTypeUtils.getTypeFromCurrentProject(Handle.class.getName()));
        }
    }
}

