/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.dataTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class SerializableValidator
implements IModelElementValidator,
IBridgeObjectProvider {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.MSG_NoClass, "carnot:engine:className"));
        } else {
            TypeInfo type;
            VariableContext context = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer());
            if (context != null) {
                className = context.replaceAllVariablesByDefaultValue(className);
            }
            if ((type = typeFinder.findType(className)) == null) {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), "carnot:engine:className"));
            } else if (type.implementsInterface("java.io.Serializable") || type.isInterface()) {
                boolean autoInstantiate = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:autoInstantiate");
                if (autoInstantiate) {
                    boolean hasDefaultConstructor = false;
                    try {
                        List constructors = type.getConstructors();
                        int i = 0;
                        while (i < constructors.size()) {
                            MethodInfo ctor = (MethodInfo)constructors.get(i);
                            if (ctor.getParameterCount() == 0) {
                                hasDefaultConstructor = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    if (!hasDefaultConstructor) {
                        result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.SerializableValidator_NoDefaultConstructorMessage, className), "carnot:engine:autoInstantiate"));
                    }
                }
            } else {
                result.add(Issue.error((EObject)element, MessageFormat.format(Validation_Messages.MSG_ClassNotSerilizable, className), "carnot:engine:className"));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    @Override
    public BridgeObject getBridgeObject(ITypedElement accessPoint, String accessPath, DirectionType direction) throws ValidationException {
        return JavaDataTypeUtils.getBridgeObject(accessPoint, accessPath, direction);
    }
}

