/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavaDataTypeUtils {
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final String PATH_SEPARATOR = ".";
    private static IJavaProject javaProject;

    public static Map initPrimitiveAttributes(Type type, String defaultValue) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("carnot:engine:type", type);
        if (defaultValue != null) {
            attributes.put("carnot:engine:defaultValue", defaultValue);
        }
        return attributes;
    }

    public static Map initSerializableBeanAttributes(String beanClassName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("carnot:engine:className", beanClassName);
        return attributes;
    }

    public static String getReferenceClassName(ITypedElement data, boolean convert) {
        String className = null;
        DataTypeType dataType = null;
        if (data instanceof AccessPointType) {
            dataType = ((AccessPointType)data).getType();
        } else if (data instanceof DataType) {
            dataType = ((DataType)data).getType();
        }
        if (dataType.getId().equals("primitive")) {
            className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:type");
        } else if (dataType.getId().equals("serializable")) {
            className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:className");
        } else if (dataType.getId().equals("entity")) {
            String version = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:ejbVersion");
            className = version == null || version.equals("entity20") ? AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:remoteInterface") : AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)data), (String)"carnot:engine:className");
        } else {
            throw new PublicException(Validation_Messages.ERR_NotAJavaDataType);
        }
        String convertedClassName = TypeFinder.getClassFromAbbreviatedName(className);
        return convert && convertedClassName != null ? convertedClassName : className;
    }

    public static IType getReferenceClass(ITypedElement data) {
        return JavaDataTypeUtils.getTypeFromCurrentProject(JavaDataTypeUtils.getReferenceClassName(data, true));
    }

    public static IType getTypeFromCurrentProject(String referenceClassName) {
        if (referenceClassName == null) {
            return null;
        }
        String className = referenceClassName;
        int ix = referenceClassName.indexOf(60);
        if (ix > 0) {
            className = referenceClassName.substring(0, ix);
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        EditorPartRetriever editorPartRetriever = new EditorPartRetriever(workbench);
        workbench.getDisplay().syncExec((Runnable)editorPartRetriever);
        IEditorPart part = editorPartRetriever.getEditorPart();
        IType type = null;
        if (part != null) {
            IResource editorResource = (IResource)part.getEditorInput().getAdapter(IResource.class);
            javaProject = JavaCore.create((IProject)editorResource.getProject());
            try {
                type = javaProject.findType(className);
            }
            catch (JavaModelException javaModelException) {}
        }
        return type;
    }

    public static List parse(String pathExpression) {
        ArrayList<String> parsedPath = Collections.EMPTY_LIST;
        if (!StringUtils.isEmpty((String)pathExpression)) {
            int protocolIndex = pathExpression.indexOf(PROTOCOL_SEPARATOR);
            if (protocolIndex != -1) {
                String protocol = pathExpression.substring(0, protocolIndex);
                if (!"java".equals(protocol)) {
                    throw new PublicException(String.valueOf(Validation_Messages.ERR_InvalidJavaBeanAccessPathType) + pathExpression);
                }
                pathExpression = pathExpression.substring(protocolIndex + PROTOCOL_SEPARATOR.length());
            }
            Iterator pathTokens = StringUtils.split((String)pathExpression, (String)PATH_SEPARATOR);
            parsedPath = new ArrayList<String>();
            StringBuffer buffer = new StringBuffer();
            while (pathTokens.hasNext()) {
                String token = (String)pathTokens.next();
                buffer.append(token);
                if (token.endsWith(")")) {
                    parsedPath.add(buffer.toString());
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(PATH_SEPARATOR);
            }
        }
        return parsedPath;
    }

    public static BridgeObject getBridgeObject(String apTypeName, String path, DirectionType direction) throws ValidationException {
        IType accessPointType = JavaDataTypeUtils.getTypeFromCurrentProject(apTypeName);
        return new BridgeObject(accessPointType, direction);
    }

    public static BridgeObject getBridgeObject(ITypedElement ap, String path, DirectionType direction) throws ValidationException {
        DataTypeType dataType = (DataTypeType)ap.getMetaType();
        IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
        ITypedElement element = JavaDataTypeUtils.traversePath(editor, ap, path, direction);
        String referenceClassName = JavaDataTypeUtils.getReferenceClassName(element, true);
        IType accessPointType = JavaDataTypeUtils.getTypeFromCurrentProject(referenceClassName);
        return new BridgeObject(accessPointType, direction, referenceClassName);
    }

    public static ITypedElement traversePath(IAccessPathEditor editor, ITypedElement typed, String accessPath, DirectionType direction) throws ValidationException {
        String id = null;
        String path = accessPath;
        if (path != null && path.length() == 0) {
            path = null;
        }
        ITypedElement element = typed;
        block0: while (element != null && editor != null && path != null) {
            String[] splitted = editor.splitAccessPath(path);
            id = splitted[0];
            path = splitted[1];
            DirectionType segmentDirection = DirectionType.IN_LITERAL.equals((Object)direction) && !StringUtils.isEmpty((String)path) ? DirectionType.OUT_LITERAL : direction;
            List accessPoints = editor.getAccessPoints(id, (IExtensibleElement)element, segmentDirection);
            element = null;
            int i = 0;
            while (i < accessPoints.size()) {
                AccessPointType ap = (AccessPointType)accessPoints.get(i);
                if (ap.getId().equals(id)) {
                    element = ap;
                    editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)ap.getType());
                    continue block0;
                }
                ++i;
            }
        }
        if (element == null) {
            throw new ValidationException(MessageFormat.format(Validation_Messages.JavaDataTypeUtils_segmentProcessingError, accessPath, id), accessPath);
        }
        return element;
    }

    private JavaDataTypeUtils() {
    }

    private static final class EditorPartRetriever
    implements Runnable {
        private final IWorkbench workbench;
        private IEditorPart editorPart;

        private EditorPartRetriever(IWorkbench workbench) {
            this.workbench = workbench;
            this.editorPart = null;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null) {
                this.editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        }

        public IEditorPart getEditorPart() {
            return this.editorPart;
        }
    }
}

