/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.BridgeObject;

public class PathEntry {
    public static final int ALL = -1;
    private ITypedElement element;
    private DirectionType direction;
    private String id;
    private List<PathEntry> children;
    private Boolean indexed;
    private long index = -1L;
    private String separator;
    private String indexEnd;
    private String indexStart;
    private IAccessPathEditor editor;
    private String simpleTypeName;
    private Boolean bidirectional;

    public PathEntry(ITypedElement element, DirectionType direction) {
        this.element = element;
        this.direction = direction;
    }

    public boolean isIn() {
        return AccessPointUtil.isIn((DirectionType)this.direction);
    }

    public String getIcon() {
        IMetaType type = this.element.getMetaType();
        if (type == null) {
            return null;
        }
        if (this.getChildren().size() == 0) {
            return "{org.eclipse.stardust.modeling.data.structured}icons/primitive_data.gif";
        }
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        return registry.getTypeIcon(type.getExtensionPointId(), type.getId());
    }

    public boolean matchesDirection() {
        if (this.element instanceof DataType) {
            return true;
        }
        if (this.element instanceof AccessPointType) {
            AccessPointType ap = (AccessPointType)this.element;
            DirectionType apdir = ap.getDirection();
            return AccessPointUtil.isIn((DirectionType)this.direction) && AccessPointUtil.isIn((DirectionType)apdir) || AccessPointUtil.isOut((DirectionType)this.direction) && AccessPointUtil.isOut((DirectionType)apdir);
        }
        return false;
    }

    public String getLabel() {
        IIdentifiableElement identifiable;
        String label = null;
        if (this.element instanceof IIdentifiableElement && (label = (identifiable = (IIdentifiableElement)this.element).getName()) == null) {
            label = identifiable.getId();
        }
        return label;
    }

    public String getTypeName() {
        return this.getTypeName(this.isSingle() ? 0 : 1);
    }

    public String getTypeName(int dimension) {
        String type = this.getSimpleTypeName();
        int i = 0;
        while (i < dimension) {
            type = String.valueOf(type) + this.getIndexStart() + this.getIndexEnd();
            ++i;
        }
        return type;
    }

    public String getSimpleTypeName() {
        if (this.simpleTypeName == null) {
            BridgeObject bo = BridgeObject.getBridge(this.element, null, this.direction);
            this.simpleTypeName = bo.toString();
            if (this.simpleTypeName == null) {
                this.simpleTypeName = "";
            }
        }
        return this.simpleTypeName;
    }

    public String getIndexEnd() {
        if (this.indexEnd == null) {
            if (this.element instanceof IExtensibleElement) {
                this.indexEnd = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:path:indexEnd");
            }
            if (this.indexEnd == null) {
                this.indexEnd = "]";
            }
        }
        return this.indexEnd;
    }

    public String getIndexStart() {
        if (this.indexStart == null) {
            if (this.element instanceof IExtensibleElement) {
                this.indexStart = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:path:indexStart");
            }
            if (this.indexStart == null) {
                this.indexStart = "[";
            }
        }
        return this.indexStart;
    }

    public void setIndex(long index) {
        if (this.index != index) {
            this.children = null;
        }
        this.index = index;
    }

    public long getIndex() {
        return this.index;
    }

    public boolean isSingle() {
        return !this.isIndexed() || this.index != -1L;
    }

    public boolean isIndexed() {
        if (this.indexed == null && this.element instanceof IExtensibleElement) {
            boolean isIndexed = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:data:indexed");
            this.indexed = isIndexed ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.indexed;
    }

    public String getSeparator() {
        if (this.separator == null) {
            if (this.element instanceof IExtensibleElement) {
                this.separator = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:path:separator");
            }
            if (this.separator == null) {
                this.separator = ".";
            }
        }
        return this.separator;
    }

    public String getId() {
        if (this.id == null) {
            if (this.element instanceof IIdentifiableElement) {
                IIdentifiableElement identifiable = (IIdentifiableElement)this.element;
                this.id = identifiable.getId();
            }
            if (this.id == null) {
                this.id = "";
            }
        }
        return this.id;
    }

    public String getFullId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getId());
        if (this.isIndexed() && this.isSingle()) {
            sb.append(this.getIndexStart());
            sb.append(this.getIndex());
            sb.append(this.getIndexEnd());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFullId();
    }

    public List<PathEntry> getChildren() {
        if (this.children == null) {
            IAccessPathEditor editor;
            this.children = new ArrayList<PathEntry>();
            if ((this.isSingle() || AccessPointUtil.isOut((DirectionType)this.direction)) && (editor = this.getAccessPathEditor()) != null) {
                List points = editor.getAccessPoints(null, (IExtensibleElement)this.element, this.direction);
                int i = 0;
                while (i < points.size()) {
                    this.children.add(new PathEntry((ITypedElement)points.get(i), this.direction));
                    ++i;
                }
                if (DirectionType.IN_LITERAL == this.direction && this.includeOuts()) {
                    points = editor.getAccessPoints(null, (IExtensibleElement)this.element, DirectionType.OUT_LITERAL);
                    i = 0;
                    while (i < points.size()) {
                        IExtensibleElement element = (IExtensibleElement)points.get(i);
                        if (AttributeUtil.getBooleanValue((IExtensibleElement)element, (String)"carnot:engine:browsable")) {
                            this.children.add(new PathEntry((ITypedElement)element, this.direction));
                        }
                        ++i;
                    }
                }
            }
        }
        return this.children;
    }

    private boolean includeOuts() {
        if (this.isBidirectional()) {
            return false;
        }
        if (this.element instanceof DataType) {
            return true;
        }
        if (this.element instanceof AccessPointType) {
            AccessPointType ap = (AccessPointType)this.element;
            return AccessPointUtil.isIn((DirectionType)this.direction) && (AccessPointUtil.isOut((DirectionType)ap.getDirection()) || AttributeUtil.getBooleanValue((IExtensibleElement)ap, (String)"carnot:engine:browsable"));
        }
        return false;
    }

    public boolean isBidirectional() {
        if (this.bidirectional == null && this.element instanceof IExtensibleElement) {
            boolean isBidirectional = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:data:bidirectional");
            this.bidirectional = isBidirectional ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.bidirectional;
    }

    public IAccessPathEditor getAccessPathEditor() {
        IMetaType metaType;
        if (this.editor == null && (metaType = this.element.getMetaType()) instanceof DataTypeType) {
            DataTypeType dataType = (DataTypeType)metaType;
            this.editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
        }
        return this.editor;
    }

    public ITypedElement getElement() {
        return this.element;
    }
}

