/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.FieldInfo;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class TypeInfo {
    private static final String EXTENDS = " extends ";
    private IType type;
    private Map parameterMapping = new HashMap();
    private TypeFinder finder;

    public TypeInfo(TypeFinder finder, IType type, String parameterString) throws JavaModelException {
        this.finder = finder;
        this.type = type;
        this.setParameterString(type, parameterString);
    }

    private void setParameterString(IType type, String parameterString) throws JavaModelException {
        if (parameterString != null) {
            List parameters = this.split(this.strip(parameterString.trim()));
            ITypeParameter[] types = type.getTypeParameters();
            int i = 0;
            while (i < types.length && i < parameters.size()) {
                this.parameterMapping.put(types[i].getElementName(), parameters.get(i));
                ++i;
            }
        }
    }

    public List getConstructors() throws JavaModelException {
        HashMap methods = new HashMap();
        this.fetchMethods(methods, true);
        ArrayList result = new ArrayList();
        result.addAll(methods.values());
        return result;
    }

    public List getFields() throws JavaModelException {
        HashMap fields = new HashMap();
        HashSet visitedFields = new HashSet();
        this.fetchFields(fields, visitedFields);
        ArrayList result = new ArrayList();
        result.addAll(fields.values());
        return result;
    }

    private void fetchFields(Map list, Set visitedFields) throws JavaModelException {
        this.fetchFields(list, false);
        if (!this.type.isInterface()) {
            this.fetchFields(list, visitedFields, this.type.getSuperclassTypeSignature());
        }
        String[] interfaces = this.type.getSuperInterfaceTypeSignatures();
        int i = 0;
        while (i < interfaces.length) {
            this.fetchFields(list, visitedFields, interfaces[i]);
            ++i;
        }
    }

    private void fetchFields(Map list, Set visitedFields, String typeSignature) throws JavaModelException {
        String superType;
        String string = superType = typeSignature == null ? "java.lang.Object" : this.resolveSignature(typeSignature);
        if (!visitedFields.contains(superType)) {
            visitedFields.add(superType);
            TypeInfo descriptor = this.finder.findType(superType);
            if (descriptor == null) {
                System.err.println(MessageFormat.format(Validation_Messages.CSL_ERR_UNABLE_TO_RESOLVE_CL, superType));
            } else {
                descriptor.fetchFields(list, visitedFields);
            }
        }
    }

    private void fetchFields(Map list, boolean constructors) throws JavaModelException {
        IField[] fields = this.type.getFields();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            field.getFlags();
            String fieldName = field.getElementName();
            String fieldType = field.getTypeSignature();
            String parameterType = this.resolveSignature(fieldType);
            FieldInfo info = new FieldInfo(fieldName, parameterType, field.getFlags());
            if (!list.containsKey(fieldName)) {
                list.put(fieldName, info);
            }
            ++i;
        }
    }

    public List getMethods() throws JavaModelException {
        HashMap methods = new HashMap();
        HashSet visitedTypeNames = new HashSet();
        this.fetchMethods(methods, visitedTypeNames);
        ArrayList result = new ArrayList();
        result.addAll(methods.values());
        return result;
    }

    private void fetchMethods(Map list, Set visitedTypeNames) throws JavaModelException {
        this.fetchMethods(list, false);
        if (!this.type.isInterface()) {
            this.fetchMethods(list, visitedTypeNames, this.type.getSuperclassTypeSignature());
        }
        String[] interfaces = this.type.getSuperInterfaceTypeSignatures();
        int i = 0;
        while (i < interfaces.length) {
            this.fetchMethods(list, visitedTypeNames, interfaces[i]);
            ++i;
        }
    }

    private void fetchMethods(Map list, Set visitedTypeNames, String typeSignature) throws JavaModelException {
        String superType;
        String string = superType = typeSignature == null ? "java.lang.Object" : this.resolveSignature(typeSignature);
        if (!visitedTypeNames.contains(superType)) {
            visitedTypeNames.add(superType);
            TypeInfo descriptor = this.finder.findType(superType);
            if (descriptor == null) {
                System.err.println(String.valueOf(Validation_Messages.CSL_ERR_UNABLE_TO_RESOLVE_CL) + superType + "'.");
            } else {
                descriptor.fetchMethods(list, visitedTypeNames);
            }
        }
    }

    private void fetchMethods(Map list, boolean constructors) throws JavaModelException {
        IMethod[] methods = this.type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod mtd = methods[i];
            if (constructors == mtd.isConstructor() && mtd.getElementType() != 10) {
                boolean accessible;
                String returnType;
                String methodName = mtd.getElementName();
                String[] parameterSignatures = mtd.getParameterTypes();
                String[] parameterTypes = new String[parameterSignatures.length];
                int j = 0;
                while (j < parameterSignatures.length) {
                    parameterTypes[j] = this.resolveSignature(parameterSignatures[j]);
                    ++j;
                }
                String returnSignature = mtd.getReturnType();
                MethodInfo info = new MethodInfo(constructors, methodName, parameterSignatures, parameterTypes, returnSignature, returnType = this.resolveSignature(returnSignature), accessible = Flags.isPublic((int)mtd.getFlags()));
                String key = info.getEncoded();
                if (!list.containsKey(key)) {
                    list.put(key, info);
                }
            }
            ++i;
        }
    }

    private String resolveSignature(String signature) throws JavaModelException {
        String value = Signature.toString((String)signature);
        return this.resolve(value);
    }

    public String resolve(String value) throws JavaModelException {
        String parameterString = null;
        int ix = value.indexOf(60);
        if (ix > 0) {
            parameterString = value.substring(ix);
            value = value.substring(0, ix);
        }
        return String.valueOf(this.resolveSimpleType(value)) + this.resolveParameters(parameterString);
    }

    private String resolveParameters(String parameterString) throws JavaModelException {
        if (parameterString == null) {
            return "";
        }
        List parameters = this.split(this.strip(parameterString.trim()));
        StringBuffer builder = new StringBuffer();
        builder.append('<');
        int i = 0;
        while (i < parameters.size()) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.resolve((String)parameters.get(i)));
            ++i;
        }
        builder.append('>');
        return builder.toString();
    }

    private String resolveSimpleType(String value) throws JavaModelException {
        String[][] resolved = null;
        if (!(this.type instanceof BinaryType)) {
            resolved = this.type.resolveType(value);
        }
        if (resolved == null) {
            String match;
            String defaultValue = null;
            int ix = value.indexOf(EXTENDS);
            if (ix > 0) {
                defaultValue = value.substring(ix + EXTENDS.length());
                value = value.substring(0, ix);
            }
            if ((match = (String)this.parameterMapping.get(value)) != null) {
                value = match;
            } else if (defaultValue != null) {
                value = defaultValue;
            }
        } else if (resolved.length == 1) {
            value = String.valueOf(resolved[0][0]) + '.' + resolved[0][1];
        }
        return value;
    }

    private List split(String typeList) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (typeList.length() > 0) {
            int start = 0;
            int pcount = 0;
            int i = 0;
            while (i < typeList.length()) {
                char c = typeList.charAt(i);
                switch (c) {
                    case '<': {
                        ++pcount;
                        break;
                    }
                    case '>': {
                        --pcount;
                        break;
                    }
                    case ',': {
                        if (pcount != 0) break;
                        parameters.add(typeList.substring(start, i).trim());
                        start = i + 1;
                    }
                }
                ++i;
            }
            if (start < typeList.length()) {
                parameters.add(typeList.substring(start).trim());
            }
        }
        return parameters;
    }

    private String strip(String parameters) {
        int start = parameters.indexOf(60);
        start = start < 0 ? 0 : start + 1;
        int end = parameters.lastIndexOf(62);
        if (end < 0) {
            end = parameters.length();
        }
        return parameters.substring(start, end).trim();
    }

    public IType getType() {
        return this.type;
    }

    public String getParameterType(String elementName) {
        return (String)this.parameterMapping.get(elementName);
    }

    public String getFullName() {
        try {
            String parameterizedName = this.type.getFullyQualifiedParameterizedName();
            String fullName = this.type.getFullyQualifiedName('.');
            parameterizedName = String.valueOf(this.type.getFullyQualifiedName()) + parameterizedName.substring(fullName.length());
            return this.resolve(parameterizedName);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setParameterType(String elementName, String value) {
        if (value == null || value.trim().length() == 0) {
            this.parameterMapping.remove(elementName);
        } else {
            this.parameterMapping.put(elementName, value.trim());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean implementsInterface(String name) {
        ArrayList<TypeInfo> interfaces = new ArrayList<TypeInfo>();
        if (this.getFullName().equals(name)) {
            return true;
        }
        try {
            TypeInfo type;
            this.findInterfaces(interfaces, this.type);
            Iterator<TypeInfo> iterator = interfaces.iterator();
            do {
                if (iterator.hasNext()) continue;
                ITypeHierarchy typeHierarchy = this.type.newSupertypeHierarchy(null);
                IType superType = typeHierarchy.getSuperclass(this.type);
                TypeInfo superTypeInfo = new TypeInfo(this.finder, superType, null);
                return superTypeInfo.implementsInterface(name);
            } while (!(type = iterator.next()).getFullName().equals(name));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void findInterfaces(ArrayList<TypeInfo> list, IType thisType) throws JavaModelException {
        String[] interfaces = thisType.getSuperInterfaceTypeSignatures();
        int i = 0;
        while (i < interfaces.length) {
            try {
                String superType = this.resolveSignature(interfaces[i]);
                TypeInfo theType = this.finder.findType(superType);
                if (!list.contains(theType) && theType != null) {
                    list.add(theType);
                }
                this.getInterfaces(this.finder.findExactType(superType), list);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public List<TypeInfo> getInterfaces() {
        ArrayList<TypeInfo> list = new ArrayList<TypeInfo>();
        try {
            this.findInterfaces(list, this.type);
        }
        catch (Exception exception) {}
        return list;
    }

    private void getInterfaces(IType baseType, List<TypeInfo> list) {
        if (baseType == null) {
            return;
        }
        try {
            String[] interfaces = baseType.getSuperInterfaceTypeSignatures();
            int i = 0;
            while (i < interfaces.length) {
                try {
                    String superType = this.resolveSignature(interfaces[i]);
                    TypeInfo theType = this.finder.findType(superType);
                    if (!list.contains(theType)) {
                        list.add(theType);
                        this.getInterfaces(this.finder.findExactType(superType), list);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isInterface() {
        try {
            return this.getType().isInterface();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isSameType(String nodeName) {
        try {
            String resolvedName = this.resolve(nodeName);
            return this.getFullName().equals(resolvedName);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }
}

