/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.reporting.common.ColumnProvider;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IOneOfManyColumns;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;

public abstract class AbstractColumnProvider
implements ColumnProvider {
    View view;
    protected String name;
    private List groupColumns = new ArrayList();

    public AbstractColumnProvider(View view, String name) {
        this.view = view;
        this.name = name;
    }

    @Override
    public void addGroupColumn(GroupColumn column) {
        IOneOfManyColumns oneOfMany;
        if (!this.view.allowsUserDefinedDataColumns().contains(this.getClass())) {
            throw new RuntimeException(ReportingCommon_Messages.ExceptionDataFieldsCannotBeDefinedForThisView);
        }
        if (column instanceof IOneOfManyColumns && (oneOfMany = (IOneOfManyColumns)((Object)column)).getColumnProvider() == null) {
            oneOfMany.setColumnProvider(this);
        }
        this.groupColumns.add(column);
    }

    @Override
    public List getGroupColumns() {
        return Collections.unmodifiableList(this.groupColumns);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract String getXMLSpecification();

    @Override
    public void removeGroupColumn(GroupColumn column) {
        this.groupColumns.remove(column);
        if (this.view.getColumnProvider().contains(this)) {
            this.view.removeGroupColumn(column);
        }
    }

    public void removeGroupColumns(Collection columns) {
        for (GroupColumn column : columns) {
            this.removeGroupColumn(column);
        }
    }

    public void removeAllGroupColumns() {
        Iterator iter = this.groupColumns.iterator();
        while (iter.hasNext()) {
            this.view.removeGroupColumn((GroupColumn)iter.next());
        }
        this.groupColumns.clear();
    }

    public View getView() {
        return this.view;
    }
}

