/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Calendar;
import org.eclipse.stardust.reporting.common.ICumulationAspect;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.View;

public abstract class AbstractCumulationAspect
implements ICumulationAspect {
    private static Logger log = LogUtils.getLogger(AbstractCumulationAspect.class);
    public static final Object[] NULL_GROUP_VALUE = new Object[1];
    protected View view;
    protected long startTimestamp;
    protected long endTimestamp;
    protected int[] groupByColumnIndexes;

    public AbstractCumulationAspect(View view, long startTimestamp, long endTimestamp) {
        this.view = view;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    protected long incrementTimestamp(long timestamp, String intervalType) {
        if (intervalType.equals("single")) {
            return this.endTimestamp;
        }
        Calendar timestampCalendar = Calendar.getInstance();
        timestampCalendar.setTimeInMillis(timestamp);
        if (intervalType.equals("year")) {
            timestampCalendar.add(1, 1);
        } else if (intervalType.equals("quarter")) {
            timestampCalendar.add(2, 3);
        } else if (intervalType.equals("month")) {
            timestampCalendar.add(2, 1);
        } else if (intervalType.equals("week")) {
            timestampCalendar.add(3, 1);
        } else if (intervalType.equals("day")) {
            timestampCalendar.add(5, 1);
        } else if (intervalType.equals("hour")) {
            timestampCalendar.add(10, 1);
        } else if (intervalType.equals("minute")) {
            timestampCalendar.add(12, 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("Incremented timestamp: " + timestampCalendar.getTime());
        }
        return timestampCalendar.getTimeInMillis();
    }

    protected boolean handleGrouping() {
        return this.view.isGroupingHandlingNecessary();
    }
}

