/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.reporting.common.DataColumnAliasRegistry;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;

public abstract class AbstractDataColumn
extends GroupColumn
implements IDataColumn {
    protected Parameter valueFilterParameter;
    private String modelId;
    private String dataId;

    public AbstractDataColumn(View report, String name, String label, Class type, boolean predefined, boolean cumulatable) {
        super(report, name, label, type, predefined, cumulatable);
    }

    @Override
    public void initViewParameter() {
        super.initViewParameter();
        String filterDefault = Parameter.STRING_DEFAULT_VALUE;
        String columnName = "string_value";
        if (this.isNumeric() || this.isBoolean()) {
            filterDefault = Parameter.NUMERIC_DEFAULT_VALUE;
            columnName = "number_value";
        }
        this.valueFilterParameter = this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getName()), this.getType(), false, filterDefault, null);
        this.setDbColumnRef(new DbColumnRef(columnName, null, this.getAlias()));
        this.addParameter(this.valueFilterParameter);
    }

    @Override
    public String getAlias() {
        DataColumnAliasRegistry aliasRegistry = this.getView().getAliasRegistry();
        return aliasRegistry.getAlias(this).toLowerCase();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        result = 31 * result + (this.getDataId() == null ? 0 : this.getDataId().hashCode());
        result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataColumn other = (AbstractDataColumn)obj;
        if (this.getAttributeName() == null ? other.getAttributeName() != null : !this.getAttributeName().equals(other.getAttributeName())) {
            return false;
        }
        if (this.getDataId() == null ? other.getDataId() != null : !this.getDataId().equals(other.getDataId())) {
            return false;
        }
        return !(this.getModelId() == null ? other.getModelId() != null : !this.getModelId().equals(other.getModelId()));
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public boolean isInitial() {
        return StringUtils.isEmpty((String)this.dataId);
    }
}

