/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import com.ibm.icu.util.StringTokenizer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.beans.security.AuthorizationManager;
import org.eclipse.stardust.reporting.common.beans.security.AuthorizationManagerFactory;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.ComplexCondition;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.utils.sql.InnerJoinExpression;
import org.eclipse.stardust.reporting.common.utils.sql.LogicalOperator;
import org.eclipse.stardust.reporting.common.utils.sql.OuterJoinExpression;
import org.eclipse.stardust.reporting.common.utils.sql.SortExpression;
import org.eclipse.stardust.reporting.common.utils.sql.SqlStructure;
import org.eclipse.stardust.reporting.common.utils.sql.WhereExpression;

public abstract class AbstractQualityAssuranceView
extends View {
    protected AuthorizationManager authorizationManager;
    private DbTable processInstanceTable;
    private DbTable activityInstanceTable;

    public AbstractQualityAssuranceView(String id) {
        super(id);
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter("StartDate", Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter("EndDate", Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter("UserAccounts", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ProcessId", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ActivityId", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    protected QaSqlStructure prepareStructure(Object[] parameters) throws SQLException {
        String modelOidParam;
        long modelOid;
        String activityId;
        String processId;
        this.activityInstanceTable = new DbTable(this.getDefaultSchemaName(), "activity_instance", "ai");
        DbTable activityTable = new DbTable(this.getDefaultSchemaName(), "activity", "a");
        this.processInstanceTable = new DbTable(this.getDefaultSchemaName(), "process_instance", "pi");
        DbTable processDefinitionTable = new DbTable(this.getDefaultSchemaName(), "process_definition", "p");
        DbTable workflowUserTable = new DbTable(this.getDefaultSchemaName(), "workflowuser", "u");
        DbColumn aiStartTimeColumn = this.activityInstanceTable.getColumn("startTime");
        DbColumn activityIdColumn = activityTable.getColumn("id");
        DbColumn processDefIdColumn = processDefinitionTable.getColumn("id");
        DbColumn modelOidColumn = this.activityInstanceTable.getColumn("model");
        DbColumn activityInstanceStateColumn = this.activityInstanceTable.getColumn("state");
        DbColumn activityOidColumn = activityTable.getColumn("oid");
        DbColumn processInstanceOidColumn = this.processInstanceTable.getColumn("oid");
        DbColumn userAccountColumn = workflowUserTable.getColumn("account");
        DbColumn workflowUserOidColumn = workflowUserTable.getColumn("oid");
        DbColumn currentUserPerformerColumn = this.activityInstanceTable.getColumn("currentUserPerformer");
        DbColumn performedByColumn = this.activityInstanceTable.getColumn("performedBy");
        OuterJoinExpression workflowUserJoinFragment = DbUtils.getOuterJoin(workflowUserTable, currentUserPerformerColumn, workflowUserOidColumn);
        workflowUserJoinFragment.OR(performedByColumn, CompareOperator.EQUALS, workflowUserOidColumn);
        DbColumn aiActivityColumn = this.activityInstanceTable.getColumn("activity");
        DbColumn activityModelColumn = activityTable.getColumn("model");
        InnerJoinExpression activityTableJoinFragment = DbUtils.getInnerJoin(activityTable, activityOidColumn, aiActivityColumn);
        activityTableJoinFragment.AND(activityModelColumn, CompareOperator.EQUALS, modelOidColumn);
        DbColumn aiProcessInstanceColumn = this.activityInstanceTable.getColumn("processInstance");
        DbColumn processInstanceModelColumn = this.processInstanceTable.getColumn("model");
        InnerJoinExpression processInstanceJoinFragment = DbUtils.getInnerJoin(this.processInstanceTable, aiProcessInstanceColumn, processInstanceOidColumn);
        processInstanceJoinFragment.AND(processInstanceModelColumn, CompareOperator.EQUALS, modelOidColumn);
        DbColumn processInstanceProcessDefinitionColumn = this.processInstanceTable.getColumn("processDefinition");
        DbColumn processDefinitionTableOidColumn = processDefinitionTable.getColumn("oid");
        DbColumn processDefinitionTableModelColumn = processDefinitionTable.getColumn("model");
        InnerJoinExpression processDefinitionJoinFragment = DbUtils.getInnerJoin(processDefinitionTable, processInstanceProcessDefinitionColumn, processDefinitionTableOidColumn);
        processDefinitionJoinFragment.AND(processDefinitionTableModelColumn, CompareOperator.EQUALS, modelOidColumn);
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        long start = (Long)startEnd.getFirst();
        long end = (Long)startEnd.getSecond();
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.AND(aiStartTimeColumn, CompareOperator.GREATER_OR_EQUALS, start);
        whereExpression.AND(aiStartTimeColumn, CompareOperator.SMALLER_OR_EQUALS, end);
        List<String> userAccounts = this.getUserAccounts(parameters);
        if (!userAccounts.isEmpty()) {
            ComplexCondition complexCondition = null;
            for (String userAccount : userAccounts) {
                String predicate = DbUtils.buildPredicate(userAccountColumn, CompareOperator.EQUALS, userAccount);
                if (complexCondition == null) {
                    complexCondition = new ComplexCondition(LogicalOperator.AND, predicate);
                    continue;
                }
                complexCondition.addSubCondition(LogicalOperator.OR, predicate);
            }
            whereExpression.addCondition(complexCondition);
        }
        if (ViewUtils.isParameterSet(processId = this.getProcessIdParameter(parameters))) {
            whereExpression.AND(processDefIdColumn, CompareOperator.EQUALS, processId);
        }
        if (ViewUtils.isParameterSet(activityId = this.getActivityIdParameter(parameters))) {
            whereExpression.AND(activityIdColumn, CompareOperator.EQUALS, activityId);
        }
        if ((modelOid = ViewUtils.determineModelOid(modelOidParam = this.getModelOidParameter(parameters), null)) != -1L) {
            whereExpression.AND(modelOidColumn, CompareOperator.EQUALS, modelOid);
        }
        SortExpression sortExpression = new SortExpression();
        sortExpression.addColumnToSort(aiStartTimeColumn);
        QaSqlStructure structure = new QaSqlStructure(this.getPartitionInfo(), this.getDefaultSchemaName());
        structure.setActivityIdColumn(activityIdColumn);
        structure.setModelOidColumn(modelOidColumn);
        structure.setProcessDefinitionIdColumn(processDefIdColumn);
        structure.setActivityTable(activityTable);
        structure.setProcessDefinitionTable(processDefinitionTable);
        structure.setProcessInstanceTable(this.processInstanceTable);
        structure.setActivityInstanceStateColumn(activityInstanceStateColumn);
        structure.setFromTable(this.activityInstanceTable);
        structure.addExpressions(activityTableJoinFragment);
        structure.addExpressions(processInstanceJoinFragment);
        structure.addExpressions(processDefinitionJoinFragment);
        structure.addExpressions(workflowUserJoinFragment);
        structure.addExpressions(whereExpression);
        structure.addExpressions(sortExpression);
        return structure;
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        try {
            QaSqlStructure structure = this.prepareStructure(parameters);
            this.authorizationManager = AuthorizationManagerFactory.getInstance(AuthorizationManagerFactory.AuthorizationType.READ_ACTIVITY_INSTANCE_DATA, this);
            List<IDataPrefetchColumn> dataPrefetchColumns = this.authorizationManager.getDataPrefetchColumns();
            Map<IDataColumn, List<DataInfo>> dataInfos = this.getDataInfos(dataPrefetchColumns);
            this.authorizationManager.prepare(this, structure, this.processInstanceTable, this.activityInstanceTable, dataInfos);
            return structure.toString();
        }
        catch (SQLException e) {
            throw new ProcessDatabaseQueryException(e);
        }
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[0];
        String endDateParam = (String)parameters[1];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    protected String getUserAccountsParameter(Object[] parameters) {
        return (String)parameters[2];
    }

    protected String getProcessIdParameter(Object[] parameters) {
        return (String)parameters[3];
    }

    protected String getActivityIdParameter(Object[] parameters) {
        return (String)parameters[4];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[5];
    }

    private List<String> getUserAccounts(Object[] parameters) {
        ArrayList<String> userAccounts = new ArrayList<String>();
        String userAccountsParameter = this.getUserAccountsParameter(parameters);
        if (ViewUtils.isParameterSet(userAccountsParameter)) {
            StringTokenizer st = new StringTokenizer(userAccountsParameter, ";");
            while (st.hasMoreTokens()) {
                userAccounts.add(st.nextToken());
            }
        }
        return userAccounts;
    }

    public class QaSqlStructure
    extends SqlStructure {
        DbColumn activityIdColumn;
        DbColumn processDefinitionIdColumn;
        DbColumn modelOidColumn;
        DbColumn activityInstanceStateColumn;
        DbTable activityTable;
        DbTable processInstanceTable;
        DbTable processDefinitionTable;

        public QaSqlStructure(PartitionInfo partitionInfo, String schemaName) {
            super(partitionInfo, schemaName);
        }

        public DbColumn getActivityIdColumn() {
            return this.activityIdColumn;
        }

        public void setActivityIdColumn(DbColumn activityIdColumn) {
            this.activityIdColumn = activityIdColumn;
        }

        public DbColumn getProcessDefinitionIdColumn() {
            return this.processDefinitionIdColumn;
        }

        public void setProcessDefinitionIdColumn(DbColumn processDefinitionIdColumn) {
            this.processDefinitionIdColumn = processDefinitionIdColumn;
        }

        public DbColumn getModelOidColumn() {
            return this.modelOidColumn;
        }

        public void setModelOidColumn(DbColumn modelOidColumn) {
            this.modelOidColumn = modelOidColumn;
        }

        public DbTable getActivityTable() {
            return this.activityTable;
        }

        public void setActivityTable(DbTable activityTable) {
            this.activityTable = activityTable;
        }

        public DbTable getProcessInstanceTable() {
            return this.processInstanceTable;
        }

        public void setProcessInstanceTable(DbTable processInstanceTable) {
            this.processInstanceTable = processInstanceTable;
        }

        public DbTable getProcessDefinitionTable() {
            return this.processDefinitionTable;
        }

        public void setProcessDefinitionTable(DbTable processDefinitionTable) {
            this.processDefinitionTable = processDefinitionTable;
        }

        public DbColumn getActivityInstanceStateColumn() {
            return this.activityInstanceStateColumn;
        }

        public void setActivityInstanceStateColumn(DbColumn activityInstanceStateColumn) {
            this.activityInstanceStateColumn = activityInstanceStateColumn;
        }
    }
}

