/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.query.ActivityInstanceQuery;
import org.eclipse.stardust.engine.api.query.DataPrefetchHint;
import org.eclipse.stardust.engine.api.query.FilterAndTerm;
import org.eclipse.stardust.engine.api.query.Query;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.CumulationAspect;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelPropertyColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.StructDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.cluster.Data2ClusterMapper;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.worktime.IWorktimeCalculator;

public class ActivityInstanceView
extends View {
    private static Logger log = LogUtils.getLogger(View.class);
    private IWorktimeCalculator worktimeCalculator;

    public ActivityInstanceView() {
        super("ActivityInstance");
        DbColumn pId = new DbColumn("id", "pd");
        DbColumn piOid = new DbColumn("oid", "pi");
        DbColumn piState = new DbColumn("state", "pi");
        DbColumn aId = new DbColumn("id", "ad");
        DbColumn aiOid = new DbColumn("oid", "ai");
        DbColumn aiState = new DbColumn("state", "ai");
        this.addParameter(ReportingCommon_Messages.ColumnProcessDefinitionID, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false, Parameter.STRING_DEFAULT_VALUE, piOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceState, Integer.class, false, "2", piState.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityID, String.class, false, Parameter.STRING_DEFAULT_VALUE, aId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityInstanceOID, Long.class, false, Parameter.STRING_DEFAULT_VALUE, aiOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityInstanceState, Integer.class, false, "2", aiState.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[8];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[9];
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(this.createPredefinedColumn("Model", ReportingCommon_Messages.ColumnModel, String.class, false, new DbColumnRef("id", "model", "m")));
        this.addGroupColumn(this.createPredefinedColumn("ID", ReportingCommon_Messages.ColumnId, String.class, false, new DbColumnRef("id", "activity", "activity")));
        this.addGroupColumn(this.createPredefinedColumn("Name", ReportingCommon_Messages.ColumnName, String.class, false, new DbColumnRef("name", "activity", "activity")));
        this.addGroupColumn(this.createPredefinedColumn("Description", ReportingCommon_Messages.ColumnDescription, String.class, false, new DbColumnRef("description", "activity", "activity")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessID", ReportingCommon_Messages.ColumnProcessId, String.class, false, new DbColumnRef("id", "process_definition", "process_definition")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessName", ReportingCommon_Messages.ColumnProcessName, String.class, false, new DbColumnRef("name", "process_definition", "process_definition")));
        this.addGroupColumn(this.createPredefinedColumn("ProcessDescription", ReportingCommon_Messages.ColumnProcessDescription, String.class, false, new DbColumnRef("description", "process_definition", "process_definition")));
        this.addGroupColumnCumulated(this.createPredefinedColumn("IntervalTimestamp", ReportingCommon_Messages.ColumnIntervalTimestamp, Timestamp.class, false));
        this.addGroupColumnCumulated(this.createPredefinedColumn("Volume", ReportingCommon_Messages.ColumnVolume, Integer.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("OID", ReportingCommon_Messages.ColumnOid, Long.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("State", ReportingCommon_Messages.ColumnState, Integer.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("ProcessInstanceOID", ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("WorklistPerformerOID", ReportingCommon_Messages.ColumnWorkListPerformerOID, Long.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("UserPerformerOID", ReportingCommon_Messages.ColumnUserPerformerOID, Long.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartTimestamp", ReportingCommon_Messages.ColumnStartTimeStamp, Timestamp.class, false));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("EndTimestamp", ReportingCommon_Messages.ColumnEndTimeStamp, Timestamp.class, false));
        this.addGroupColumn(this.createPredefinedColumn("ActivityDuration", ReportingCommon_Messages.ColumnActivittyDuration, Long.class, true));
        this.addGroupColumn(this.createPredefinedColumn("ActivityWorktime", ReportingCommon_Messages.ColumnActivittyWorktime, Long.class, true));
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[6];
        String endDateParam = (String)parameters[7];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    @Override
    protected int getUncumulatedTimestampColumnIndex() {
        return 12;
    }

    @Override
    protected int getCumulatedTimestampColumnIndex() {
        return 7;
    }

    @Override
    protected int getCumulatedVolumeColumnIndex() {
        return 8;
    }

    public IWorktimeCalculator getWorktimeCalculator() {
        return this.worktimeCalculator;
    }

    public void setWorktimeCalculator(IWorktimeCalculator worktimeCalculator) {
        this.worktimeCalculator = worktimeCalculator;
    }

    @Override
    public String getReportType() {
        return "ActivityInstance";
    }

    @Override
    public boolean canBeCumulated() {
        return true;
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        ArrayList<AbstractDataColumn> dataPrefetchColumns = new ArrayList<AbstractDataColumn>();
        this.initLoginData = this.initLoginData();
        if (this.initLoginData) {
            this.authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllActivityInstances", (Class[])new Class[]{ActivityInstanceQuery.class});
            this.authPredicate = new AbstractAuthorization2Predicate(this.authorizationContext){};
            ActivityInstanceQuery activityInstanceQuery = ActivityInstanceQuery.findAll();
            this.authPredicate.addPrefetchDataHints((Query)activityInstanceQuery);
            FilterAndTerm filters = activityInstanceQuery.getFilter();
            for (Object filter : filters.getParts()) {
                if (!(filter instanceof DataPrefetchHint)) continue;
                DataPrefetchHint dataPrefetchHint = (DataPrefetchHint)filter;
                if (StringUtils.isNotEmpty((String)dataPrefetchHint.getAttributeName())) {
                    StructDataPrefetchColumn dataColumn = new StructDataPrefetchColumn((View)this, null, null, String.class, dataPrefetchHint.getAttributeName());
                    dataColumn.setColumnProvider(new StructDataDescriptor((View)this, dataPrefetchHint));
                    dataPrefetchColumns.add(dataColumn);
                    continue;
                }
                dataPrefetchColumns.add(new DataPrefetchColumn(this, dataPrefetchHint));
            }
            ArrayList<Object> fieldRefs = new ArrayList<Object>();
            fieldRefs.add(null);
            this.authPredicate.setSelectionExtension(dataPrefetchColumns.size() * -2, fieldRefs);
        }
        if (!dataPrefetchColumns.isEmpty()) {
            try {
                ArrayList<IDataColumn> dataColumns = new ArrayList<IDataColumn>(ViewUtils.getDataColumns(this));
                dataColumns.addAll(dataPrefetchColumns);
                Map<IDataColumn, List<DataInfo>> dataInfos = this.getDataInfos(dataColumns);
                Map<IDataColumn, List<DataJoinInfo>> joinInfoMap = SqlUtils.getJoinInfo(allDeployedModels, dataColumns, dataInfos);
                this.dataMapper = new Data2ClusterMapper(this, dataPrefetchColumns, parameters, true, joinInfoMap);
            }
            catch (SQLException e) {
                log.error(e.getMessage(), e);
                throw new ProcessDatabaseQueryException(e);
            }
        }
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("model", "ad"), new DbColumn("id", "ad"), new DbColumn("oid", "ad"), new DbColumn("name", "ad"), new DbColumn("description", "ad"), new DbColumn("id", "pd"), new DbColumn("name", "pd"), new DbColumn("description", "pd"), new DbColumn("oid", "ai"), new DbColumn("state", "ai"), new DbColumn("currentPerformer", "ai"), new DbColumn("currentUserPerformer", "ai"), new DbColumn("performedBy", "ai"), new DbColumn("oid", "pi"), new DbColumn("startTime", "ai"), new DbColumn("lastModificationTime", "ai"), new DbColumn("currentDepartment", "ai"), new DbColumn("processInstance", "ai"), new DbColumn("scopeProcessInstance", "pi")});
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("select ").append(selectList);
        for (IDataPrefetchColumn iDataPrefetchColumn : dataPrefetchColumns) {
            String selectFragment = this.dataMapper.getSelectFragment(iDataPrefetchColumn);
            buffer.append(", ").append(selectFragment);
        }
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("activity"), "ad"));
        String string = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processDefinition", "ad"), new DbColumn("oid", "pd")}, " = ");
        String onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ad"), new DbColumn("model", "pd")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_definition")).append(' ').append("pd").append(DbUtils.getAndOnFragment(string, onFrag2));
        String string2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "ad"), new DbColumn("activity", "ai")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ad"), new DbColumn("model", "ai")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity_instance")).append(' ').append("ai").append(DbUtils.getAndOnFragment(string2, onFrag2));
        String string3 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "pd"), new DbColumn("processDefinition", "pi")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "pd"), new DbColumn("model", "pi")}, " = ");
        String onFrag3 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", "ai"), new DbColumn("oid", "pi")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_instance")).append(' ').append("pi").append(DbUtils.getAndOnFragment(string3, onFrag2, onFrag3));
        for (IDataPrefetchColumn iDataPrefetchColumn : dataPrefetchColumns) {
            if (!(iDataPrefetchColumn instanceof DataColumn)) continue;
            DataColumn dataColumn = (DataColumn)((Object)iDataPrefetchColumn);
            String ansiJoinFragment = this.dataMapper.getAnsiJoinFragment(dataColumn);
            buffer.append(ansiJoinFragment == null ? "" : ansiJoinFragment);
        }
        if (this.dataMapper != null && this.dataMapper.foundClusterConfig()) {
            List<String> list = this.dataMapper.getClusterJoins();
            for (String clusterJoin : list) {
                buffer.append(clusterJoin);
            }
        }
        buffer.append(" where ");
        String string4 = this.aiField("startTime");
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        buffer.append(' ').append(string4).append(" >= ").append(startEnd.getFirst());
        buffer.append(" and ").append(string4).append(" <= ").append(startEnd.getSecond());
        String parameterFilters = this.getParameterFilters(parameters);
        if (!StringUtils.isEmpty((String)parameterFilters)) {
            buffer.append(parameterFilters);
        }
        this.isCumulated();
        buffer.append(this.getModelSelectionFragment(" AND ", parameters));
        buffer.append(" order by ").append(string4);
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        Localizer localizer = new Localizer(allDeployedModels);
        boolean canFetchActivity = true;
        try {
            Pair<Long, Long> startEnd = this.getStartEnd(parameterValues);
            long startTime = (Long)startEnd.getFirst();
            long endTime = (Long)startEnd.getSecond();
            List<Object[]> rows = new ArrayList();
            CumulationAspect cumulationAspect = null;
            if (this.isCumulated()) {
                cumulationAspect = new CumulationAspect(this, startTime, endTime);
            }
            while (resultSet.next()) {
                String modelId = resultSet.getString(1);
                long modelOid = resultSet.getLong(2);
                long activityRtOid = resultSet.getLong(4);
                long currentPerformer = resultSet.getLong(12);
                long currentUserPerformer = resultSet.getLong(13);
                long department = resultSet.getLong(18);
                long scopeProcessInstanceOid = resultSet.getLong(20);
                if (this.initLoginData) {
                    this.authPredicate.accept((Object)resultSet);
                    this.authorizationContext.setActivityDataWithScopePi(scopeProcessInstanceOid, activityRtOid, modelOid, currentPerformer, currentUserPerformer, department);
                    canFetchActivity = Authorization2.hasPermission((AuthorizationContext)this.authorizationContext);
                }
                if (!canFetchActivity) continue;
                Object[] row = new Object[this.getLeafColumnsUncumulated().size()];
                String activityId = resultSet.getString(3);
                String activityName = resultSet.getString(5);
                String activityDescription = resultSet.getString(6);
                String processId = resultSet.getString(7);
                String processName = resultSet.getString(8);
                String processDescription = resultSet.getString(9);
                activityName = localizer.localizeActivityName(modelOid, processId, activityId, activityName);
                activityDescription = localizer.localizeActivityDescription(modelOid, processId, activityId, activityDescription);
                processName = localizer.localizeProcessName(modelOid, processId, processName);
                processDescription = localizer.localizeProcessDescription(modelOid, processId, processDescription);
                row[0] = modelId;
                row[1] = activityId;
                row[2] = activityName;
                row[3] = activityDescription;
                row[4] = processId;
                row[5] = processName;
                row[6] = processDescription;
                row[7] = new Long(resultSet.getLong(10));
                row[8] = new Integer(resultSet.getInt(11));
                row[9] = new Long(resultSet.getLong(15));
                row[10] = new Long(resultSet.getLong(12));
                row[11] = resultSet.getInt(11) == 2 ? new Long(resultSet.getLong(14)) : new Long(resultSet.getLong(13));
                row[12] = new Timestamp(resultSet.getLong(16));
                if (resultSet.getLong(17) == 0L) {
                    row[13] = null;
                    row[14] = new Long((System.currentTimeMillis() - resultSet.getLong(16)) / 1000L);
                    row[15] = new Long(this.getWorktimeCalculator().calculateWorktime(new Date(resultSet.getLong(16)), new Date(System.currentTimeMillis()), null));
                } else {
                    row[13] = new Timestamp(resultSet.getLong(17));
                    row[14] = new Long((resultSet.getLong(17) - resultSet.getLong(16)) / 1000L);
                    row[15] = new Long(this.getWorktimeCalculator().calculateWorktime(new Date(resultSet.getLong(16)), new Date(resultSet.getLong(17)), null));
                }
                int n = 16;
                while (n < this.getLeafColumnsUncumulated().size()) {
                    Column column = (Column)this.getLeafColumnsUncumulated().get(n);
                    if (column instanceof ModelPropertyColumn) {
                        ModelPropertyColumn modelPropertyColumn = (ModelPropertyColumn)column;
                        IModel model = ActivityInstanceView.findModelByOID(allDeployedModels, resultSet.getInt(1));
                        IProcessDefinition processDefinition = model.findProcessDefinition(resultSet.getString(6));
                        IActivity activity = processDefinition.findActivity(resultSet.getString(2));
                        Object pdAttribute = activity.getAttribute(modelPropertyColumn.getPropertyFullName());
                        row[n] = pdAttribute != null ? pdAttribute.toString() : "";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Adding user defined column " + n + " = " + row[n]);
                    }
                    ++n;
                }
                if (this.isCumulated()) {
                    cumulationAspect.processRow(row);
                    continue;
                }
                rows.add(row);
            }
            if (this.isCumulated()) {
                rows = cumulationAspect.getCumulatedRows();
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

