/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Properties;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.ProcessInstanceView;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class ActivityMetricsColumn
extends GroupColumn {
    public static final String ACTIVITY_EVENT_START = "START";
    public static final String ACTIVITY_EVENT_COMPLETION = "COMPLETION";
    private String fromProcessDefinitionID;
    private String fromActivityID;
    private String fromActivityEvent;
    private String toProcessDefinitionID;
    private String toActivityID;
    private String toActivityEvent;

    public ActivityMetricsColumn(View report, String name, String label, String fromProcessDefinitionID, String fromActivityID, String fromActivityEvent, String toProcessDefinitionID, String toActivityID, String toActivityEvent) {
        super(report, name, label, Long.class, false, true);
        if (!(report instanceof ProcessInstanceView)) {
            throw new RuntimeException(ReportingCommon_Messages.ExceptionActivityMetricsColumnsCanOnlyBeUsedInProcessInstanceViews);
        }
        this.fromProcessDefinitionID = fromProcessDefinitionID;
        this.fromActivityID = fromActivityID;
        this.fromActivityEvent = fromActivityEvent;
        this.toProcessDefinitionID = toProcessDefinitionID;
        this.toActivityID = toActivityID;
        this.toActivityEvent = toActivityEvent;
    }

    public ActivityMetricsColumn(View view, String name, String label, Class type, Properties properties) {
        this(view, name, label, properties.getProperty("fromProcessDefinitionID").length() > 0 ? properties.getProperty("fromProcessDefinitionID") : null, properties.getProperty("fromActivityID").length() > 0 ? properties.getProperty("fromActivityID") : null, properties.getProperty("fromActivityEvent"), properties.getProperty("toProcessDefinitionID").length() > 0 ? properties.getProperty("toProcessDefinitionID") : null, properties.getProperty("toActivityID").length() > 0 ? properties.getProperty("toActivityID") : null, properties.getProperty("toActivityEvent"));
    }

    public String getFromProcessDefinitionID() {
        return this.fromProcessDefinitionID;
    }

    public void setFromProcessDefinitionID(String fromProcessDefinitionID) {
        this.fromProcessDefinitionID = fromProcessDefinitionID;
    }

    public String getToActivityID() {
        return this.toActivityID;
    }

    public void setToActivityID(String toActivityID) {
        this.toActivityID = toActivityID;
    }

    public String getFromActivityEvent() {
        return this.fromActivityEvent;
    }

    public void setFromActivityEvent(String fromActivityEvent) {
        this.fromActivityEvent = fromActivityEvent;
    }

    public String getFromActivityID() {
        return this.fromActivityID;
    }

    public void setFromActivityID(String fromActivityID) {
        this.fromActivityID = fromActivityID;
    }

    public String getToProcessDefinitionID() {
        return this.toProcessDefinitionID;
    }

    public void setToProcessDefinitionID(String toProcessDefinitionID) {
        this.toProcessDefinitionID = toProcessDefinitionID;
    }

    public String getToActivityEvent() {
        return this.toActivityEvent;
    }

    public void setToActivityEvent(String toActivityEvent) {
        this.toActivityEvent = toActivityEvent;
    }

    public boolean isFromActivityDefined() {
        return this.getFromActivityID() != null;
    }

    public String getAnsiJoins(int joinIndex) {
        StringBuffer buffer = new StringBuffer(200);
        View view = this.getView();
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String aAlias = " a" + joinIndex;
        String aiAlias = " ai" + joinIndex;
        String predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", aAlias), new DbColumn("model", "p")}, " = ");
        buffer.append(" inner join ").append(view.getQualifiedTableName("activity")).append(aAlias).append(DbUtils.getOnFragment(predicate1));
        predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("activity", aiAlias), new DbColumn("oid", aAlias)}, " = ");
        String predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", aiAlias), new DbColumn("model", aAlias)}, " = ");
        String predicate3 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", aiAlias), new DbColumn("oid", "pi")}, " = ");
        buffer.append(" inner join ").append(view.getQualifiedTableName("activity_instance")).append(aiAlias).append(DbUtils.getAndOnFragment(predicate1, predicate2, predicate3));
        return buffer.toString();
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<column type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' columntype='");
        buffer.append(this.getType().getName());
        buffer.append("'>\n");
        buffer.append("<property name='fromProcessDefinitionID'>" + (this.getFromProcessDefinitionID() != null ? this.getFromProcessDefinitionID() : "") + "</property>\n");
        buffer.append("<property name='fromActivityID'>" + (this.getFromActivityID() != null ? this.getFromActivityID() : "") + "</property>\n");
        buffer.append("<property name='fromActivityEvent'>" + this.getFromActivityEvent() + "</property>\n");
        buffer.append("<property name='toProcessDefinitionID'>" + (this.getToProcessDefinitionID() != null ? this.getToProcessDefinitionID() : "") + "</property>\n");
        buffer.append("<property name='toActivityID'>" + (this.getToActivityID() != null ? this.getToActivityID() : "") + "</property>\n");
        buffer.append("<property name='toActivityEvent'>" + this.getToActivityEvent() + "</property>\n");
        buffer.append("</column>\n");
        return buffer.toString();
    }
}

