/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.stardust.common.OneElementIterator;
import org.eclipse.stardust.reporting.common.AbstractCumulationAspect;
import org.eclipse.stardust.reporting.common.Cumulants;
import org.eclipse.stardust.reporting.common.DistinctEvaluator;
import org.eclipse.stardust.reporting.common.GroupByValuesComparator;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.View;

public class CumulationAspect
extends AbstractCumulationAspect {
    private static Logger log = LogUtils.getLogger(CumulationAspect.class);
    protected int uncumulatedTimestampColumnIndex;
    protected int cumulatedTimestampColumnIndex;
    protected int volumeColumnIndex;
    protected int columnCount;
    protected int[] columnIndexUncumulated;
    protected long lowerTimestamp;
    protected long upperTimestamp;
    protected int processedRowsCount;
    private List cumulatedRows = new ArrayList();
    private Map groupByCumulantsArrayMap;
    private Map groupByDistinctEvalArrayMap;

    protected CumulationAspect(View view) {
        super(view, 0L, 0L);
        this.uncumulatedTimestampColumnIndex = view.getUncumulatedTimestampColumnIndex();
        this.cumulatedTimestampColumnIndex = view.getCumulatedTimestampColumnIndex();
        this.volumeColumnIndex = view.getCumulatedVolumeColumnIndex();
        this.columnCount = view.getLeafColumnsCumulated().size();
        if (log.isDebugEnabled()) {
            log.debug("Uncumulated timestamp column: " + this.uncumulatedTimestampColumnIndex);
            log.debug("Cumulated timestamp column: " + this.cumulatedTimestampColumnIndex);
            log.debug("Volume column: " + this.volumeColumnIndex);
            log.debug("Leaf columns of the cumulated view: " + this.columnCount);
        }
        this.columnIndexUncumulated = new int[view.getGroupColumns().size()];
        int n = 0;
        while (n < view.getGroupColumns().size()) {
            GroupColumn column = (GroupColumn)view.getGroupColumns().get(n);
            if (column.isCumulatable() || n != this.cumulatedTimestampColumnIndex && n != this.volumeColumnIndex) {
                this.columnIndexUncumulated[n] = view.getColumnIndexUncumulated(column);
            }
            ++n;
        }
        this.lowerTimestamp = this.startTimestamp;
        this.upperTimestamp = this.startTimestamp;
        this.processedRowsCount = 0;
        this.groupByCumulantsArrayMap = new LazyInitializerMap(new TreeMap(new GroupByValuesComparator()), new CumulantsInitializer());
        this.groupByDistinctEvalArrayMap = new LazyInitializerMap(new TreeMap(new GroupByValuesComparator()), new DistinctEvaluatorInitializer());
    }

    public CumulationAspect(View view, long startTimestamp, long endTimestamp) {
        this(view);
        this.initializeTimestamps(startTimestamp, endTimestamp);
        LogUtils.enterInternal(log, "CumulationAspect");
        if (this.handleGrouping()) {
            this.groupByColumnIndexes = new int[view.getGroupByGroupColumns().size()];
            int n = 0;
            while (n < view.getGroupByGroupColumns().size()) {
                this.groupByColumnIndexes[n] = view.getColumnIndexUncumulated((GroupColumn)view.getGroupByGroupColumns().get(n));
                ++n;
            }
        } else {
            this.initializeEvaluators((Iterator)new OneElementIterator((Object)NULL_GROUP_VALUE), this.groupByCumulantsArrayMap, this.groupByDistinctEvalArrayMap);
        }
        LogUtils.exitInternal(log, "CumulationAspect");
    }

    @Override
    public List getCumulatedRows() {
        LogUtils.enterInternal(log, "getCumulatedRows()");
        this.cumulatedRows.addAll(this.lastResume());
        this.cumulatedRows.addAll(this.getTrailingPaddingRows());
        LogUtils.exitInternal(log, "getCumulatedRows()");
        return Collections.unmodifiableList(this.cumulatedRows);
    }

    @Override
    public void processRow(Object[] uncumulatedRow) {
        LogUtils.enterInternal(log, "processRow");
        long currentTimestamp = ((Timestamp)uncumulatedRow[this.uncumulatedTimestampColumnIndex]).getTime();
        ++this.processedRowsCount;
        if (log.isDebugEnabled()) {
            log.debug("Processing next row with timestamp " + new Date(currentTimestamp));
        }
        if (this.lowerTimestamp == this.upperTimestamp) {
            this.cumulatedRows.addAll(this.getLeadingPaddingRows(currentTimestamp));
            if (log.isDebugEnabled()) {
                log.debug("First interval boundaries retrieved: " + new Date(this.lowerTimestamp) + ", " + new Date(this.upperTimestamp));
            }
        }
        if (this.isIntervalExceded(currentTimestamp)) {
            this.cumulatedRows.addAll(this.getCollectedRows(new Timestamp(this.lowerTimestamp), this.groupByCumulantsArrayMap, this.groupByDistinctEvalArrayMap));
            this.moveInterval();
            while (this.upperTimestamp <= currentTimestamp) {
                this.cumulatedRows.addAll(this.createEmptyRows(this.lowerTimestamp, this.columnCount, this.cumulatedTimestampColumnIndex, this.volumeColumnIndex));
                this.moveInterval();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Interval processing");
        }
        if (this.isStartedInInterval(currentTimestamp)) {
            this.doProcessRow(uncumulatedRow, this.groupByCumulantsArrayMap, this.groupByDistinctEvalArrayMap);
        }
        LogUtils.exitInternal(log, "processRow");
    }

    @Override
    public void processRows(List uncumulatedRows) {
        LogUtils.enterInternal(log, "processRows");
        Iterator iter = uncumulatedRows.iterator();
        while (iter.hasNext()) {
            this.processRow((Object[])iter.next());
        }
        LogUtils.exitInternal(log, "processRows");
    }

    protected void doProcessRow(Object[] uncumulatedRow, Map groupByCumulantsArrayMap, Map groupByDistinctEvalArrayMap) {
        Object[] values = NULL_GROUP_VALUE;
        if (this.handleGrouping()) {
            values = new Object[this.groupByColumnIndexes.length];
            int n = 0;
            while (n < this.groupByColumnIndexes.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Uncumulated row for group by column " + n + ": " + uncumulatedRow[this.groupByColumnIndexes[n]]);
                }
                values[n] = uncumulatedRow[this.groupByColumnIndexes[n]];
                ++n;
            }
        }
        Cumulants[] cumulantsArray = (Cumulants[])groupByCumulantsArrayMap.get(values);
        DistinctEvaluator[] distinctEvalArray = (DistinctEvaluator[])groupByDistinctEvalArrayMap.get(values);
        int n = 0;
        int cumulantsArrayIndex = 0;
        int distinctEvalArrayIndex = 0;
        while (n < this.view.getGroupColumns().size()) {
            GroupColumn column = (GroupColumn)this.view.getGroupColumns().get(n);
            if (log.isDebugEnabled()) {
                log.debug("Processing column " + column.getFullName());
            }
            if (!this.view.getGroupByGroupColumns().contains(column) && this.columnIndexUncumulated[n] >= 0) {
                if (column.isCumulatable()) {
                    cumulantsArray[cumulantsArrayIndex].addValue((Number)uncumulatedRow[this.columnIndexUncumulated[n]]);
                    ++cumulantsArrayIndex;
                } else if (n != this.cumulatedTimestampColumnIndex && n != this.volumeColumnIndex) {
                    distinctEvalArray[distinctEvalArrayIndex].addValue(uncumulatedRow[this.columnIndexUncumulated[n]]);
                    ++distinctEvalArrayIndex;
                }
            }
            ++n;
        }
    }

    protected void initializeEvaluators(Iterator iterator, Map groupByCumulantsArrayMap, Map groupByDistinctEvalArrayMap) {
        while (iterator.hasNext()) {
            Object[] groupByValues = (Object[])iterator.next();
            this.initializeCumulants(groupByValues, groupByCumulantsArrayMap);
            this.initializeDistinctEvaluators(groupByValues, groupByDistinctEvalArrayMap);
        }
    }

    protected void initializeCumulants(Object[] groupByValues, Map groupByCumulantsArrayMap) {
        Cumulants[] cumulantsArray = new Cumulants[this.view.getCumulatableColumnsCount()];
        int n = 0;
        while (n < cumulantsArray.length) {
            cumulantsArray[n] = new Cumulants();
            ++n;
        }
        groupByCumulantsArrayMap.put(groupByValues, cumulantsArray);
    }

    protected void initializeDistinctEvaluators(Object[] groupByValues, Map groupByDistinctEvalArrayMap) {
        DistinctEvaluator[] distinctEvalArray = new DistinctEvaluator[this.view.getUncumulatableColumnsCount()];
        int n = 0;
        while (n < distinctEvalArray.length) {
            distinctEvalArray[n] = new DistinctEvaluator();
            ++n;
        }
        groupByDistinctEvalArrayMap.put(groupByValues, distinctEvalArray);
    }

    protected void initializeTimestamps(long startTimestamp, long endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.lowerTimestamp = startTimestamp;
        this.upperTimestamp = startTimestamp;
    }

    protected List getTrailingPaddingRows() {
        LogUtils.enterInternal(log, "getTrailingPaddingRows()");
        ArrayList rows = new ArrayList();
        if (this.view.getIntervalType().equals("single")) {
            return rows;
        }
        if (this.upperTimestamp == this.endTimestamp) {
            return rows;
        }
        this.moveInterval(this.getStartTimestampForTrailingPaddingRows());
        while (this.upperTimestamp <= this.endTimestamp) {
            rows.addAll(this.createEmptyRows(this.lowerTimestamp, this.columnCount, this.cumulatedTimestampColumnIndex, this.volumeColumnIndex));
            this.moveInterval();
        }
        LogUtils.exitInternal(log, "getTrailingPaddingRows()");
        return rows;
    }

    protected List lastResume() {
        LogUtils.enterInternal(log, "lastResume()");
        ArrayList<Object[]> returnList = new ArrayList<Object[]>();
        Map groupByCumulantsArrayDelegate = ((LazyInitializerMap)this.groupByCumulantsArrayMap).getDelegate();
        Map groupByDistinctEvalArrayDelegate = ((LazyInitializerMap)this.groupByDistinctEvalArrayMap).getDelegate();
        Iterator iterator = this.getCumulationKeyIterator(groupByCumulantsArrayDelegate);
        while (iterator.hasNext()) {
            int n;
            Object[] groupByValues = (Object[])iterator.next();
            Cumulants[] cumulantsArray = (Cumulants[])groupByCumulantsArrayDelegate.get(groupByValues);
            DistinctEvaluator[] distinctEvalArray = (DistinctEvaluator[])groupByDistinctEvalArrayDelegate.get(groupByValues);
            if (cumulantsArray != null) {
                n = 0;
                while (n < cumulantsArray.length) {
                    cumulantsArray[n].resume();
                    ++n;
                }
            }
            if (distinctEvalArray != null) {
                n = 0;
                while (n < distinctEvalArray.length) {
                    distinctEvalArray[n].resume();
                    ++n;
                }
            }
            Object[] row = new Object[this.columnCount];
            int n2 = 0;
            int newColumnIndex = 0;
            int cumulantsArrayIndex = 0;
            int distinctEvalArrayIndex = 0;
            while (n2 < this.view.getGroupColumns().size()) {
                GroupColumn column = (GroupColumn)this.view.getGroupColumns().get(n2);
                if (n2 == this.cumulatedTimestampColumnIndex) {
                    row[newColumnIndex] = new Timestamp(this.lowerTimestamp);
                    ++newColumnIndex;
                } else if (n2 == this.volumeColumnIndex) {
                    int volume = 0;
                    if (cumulantsArray != null) {
                        volume = cumulantsArray[0].getVolume();
                    }
                    row[newColumnIndex] = new Integer(volume);
                    ++newColumnIndex;
                } else if (this.view.getGroupByGroupColumns().contains(column)) {
                    row[newColumnIndex] = groupByValues[this.view.getGroupByGroupColumns().indexOf(column)];
                    ++newColumnIndex;
                } else if (column.isCumulatable()) {
                    if (cumulantsArray != null) {
                        row[newColumnIndex] = cumulantsArray[cumulantsArrayIndex].getMinimum();
                        row[newColumnIndex + 1] = cumulantsArray[cumulantsArrayIndex].getMaximum();
                        row[newColumnIndex + 2] = cumulantsArray[cumulantsArrayIndex].getAverage();
                        row[newColumnIndex + 3] = cumulantsArray[cumulantsArrayIndex].getDeviation();
                    }
                    newColumnIndex += 4;
                    ++cumulantsArrayIndex;
                } else if (!column.isCumulatable()) {
                    DistinctEvaluator distinctEvaluator;
                    if (distinctEvalArray != null && (distinctEvaluator = distinctEvalArray[distinctEvalArrayIndex]).isDistinct()) {
                        row[newColumnIndex] = distinctEvaluator.getDistinctValues().iterator().next();
                    }
                    ++distinctEvalArrayIndex;
                    ++newColumnIndex;
                }
                ++n2;
            }
            returnList.add(row);
        }
        LogUtils.exitInternal(log, "lastResume()");
        return returnList;
    }

    protected boolean isIntervalExceded(long currentTimestamp) {
        return currentTimestamp > this.upperTimestamp;
    }

    protected int getUncumulatedTimestampColumnIndex() {
        return this.uncumulatedTimestampColumnIndex;
    }

    protected long getLowerTimestamp() {
        return this.lowerTimestamp;
    }

    protected long getUpperTimestamp() {
        return this.upperTimestamp;
    }

    protected List getCollectedRows(Timestamp lowerTimestamp, Map groupByCumulantsArrayMap, Map groupByDistinctEvalArrayMap) {
        ArrayList<Object[]> returnList = new ArrayList<Object[]>();
        Map groupByCumulantsArrayDelegate = ((LazyInitializerMap)groupByCumulantsArrayMap).getDelegate();
        Map groupByDistinctEvalArrayDelegate = ((LazyInitializerMap)groupByDistinctEvalArrayMap).getDelegate();
        Iterator iterator = this.getCumulationKeyIterator(groupByCumulantsArrayDelegate);
        while (iterator.hasNext()) {
            int n;
            Object[] groupByValues = (Object[])iterator.next();
            Cumulants[] cumulantsArray = (Cumulants[])groupByCumulantsArrayDelegate.get(groupByValues);
            DistinctEvaluator[] distinctEvalArray = (DistinctEvaluator[])groupByDistinctEvalArrayDelegate.get(groupByValues);
            if (cumulantsArray != null) {
                n = 0;
                while (n < cumulantsArray.length) {
                    cumulantsArray[n].resume();
                    ++n;
                }
            }
            if (distinctEvalArray != null) {
                n = 0;
                while (n < distinctEvalArray.length) {
                    distinctEvalArray[n].resume();
                    ++n;
                }
            }
            Object[] row = new Object[this.columnCount];
            int n2 = 0;
            int newColumnIndex = 0;
            int cumulantsArrayIndex = 0;
            int distinctEvalArrayIndex = 0;
            while (n2 < this.view.getGroupColumns().size()) {
                GroupColumn column = (GroupColumn)this.view.getGroupColumns().get(n2);
                if (n2 == this.cumulatedTimestampColumnIndex) {
                    row[newColumnIndex] = lowerTimestamp;
                    ++newColumnIndex;
                } else if (n2 == this.volumeColumnIndex) {
                    int volume = 0;
                    if (cumulantsArray != null) {
                        volume = cumulantsArray[0].getVolume();
                    }
                    row[newColumnIndex] = new Integer(volume);
                    ++newColumnIndex;
                } else if (this.view.getGroupByGroupColumns().contains(column)) {
                    row[newColumnIndex] = groupByValues[this.view.getGroupByGroupColumns().indexOf(column)];
                    ++newColumnIndex;
                } else if (column.isCumulatable()) {
                    if (cumulantsArray != null) {
                        row[newColumnIndex] = cumulantsArray[cumulantsArrayIndex].getMinimum();
                        row[newColumnIndex + 1] = cumulantsArray[cumulantsArrayIndex].getMaximum();
                        row[newColumnIndex + 2] = cumulantsArray[cumulantsArrayIndex].getAverage();
                        row[newColumnIndex + 3] = cumulantsArray[cumulantsArrayIndex].getDeviation();
                    }
                    newColumnIndex += 4;
                    ++cumulantsArrayIndex;
                } else if (!column.isCumulatable()) {
                    DistinctEvaluator distinctEvaluator;
                    if (distinctEvalArray != null && (distinctEvaluator = distinctEvalArray[distinctEvalArrayIndex]).isDistinct()) {
                        row[newColumnIndex] = distinctEvaluator.getDistinctValues().iterator().next();
                    }
                    ++distinctEvalArrayIndex;
                    ++newColumnIndex;
                }
                ++n2;
            }
            returnList.add(row);
        }
        return returnList;
    }

    protected void moveInterval() {
        this.moveInterval(this.upperTimestamp);
    }

    protected void moveInterval(long newLowerTimestamp) {
        this.lowerTimestamp = newLowerTimestamp;
        this.upperTimestamp = this.incrementTimestamp(this.lowerTimestamp, this.view.getIntervalType());
    }

    private List getLeadingPaddingRows(long timestamp) {
        ArrayList rows = new ArrayList();
        this.moveInterval(this.startTimestamp);
        while (timestamp > this.upperTimestamp) {
            rows.addAll(this.createEmptyRows(this.lowerTimestamp, this.columnCount, this.cumulatedTimestampColumnIndex, this.volumeColumnIndex));
            this.moveInterval();
        }
        return rows;
    }

    private List createEmptyRows(long timestamp, int columnCount, int cumulatedTimestampColumnIndex, int volumeColumnIndex) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        LogUtils.enterInternal(log, "createEmptyRow()");
        Iterator iterator = this.getCumulationKeyIterator(this.groupByCumulantsArrayMap);
        while (iterator.hasNext()) {
            Object[] groupByValues = (Object[])iterator.next();
            Object[] row = new Object[columnCount];
            int n = 0;
            int newColumnIndex = 0;
            while (n < this.view.getGroupColumns().size()) {
                GroupColumn column = (GroupColumn)this.view.getGroupColumns().get(n);
                if (n == cumulatedTimestampColumnIndex) {
                    row[newColumnIndex] = new Timestamp(timestamp);
                    ++newColumnIndex;
                } else if (n == volumeColumnIndex) {
                    row[newColumnIndex] = new Integer(0);
                    ++newColumnIndex;
                } else if (this.view.getGroupByGroupColumns().contains(column)) {
                    Object groupByValue;
                    row[newColumnIndex] = groupByValue = groupByValues[this.view.getGroupByGroupColumns().indexOf(column)];
                    ++newColumnIndex;
                } else if (column.isCumulatable()) {
                    row[newColumnIndex] = null;
                    row[newColumnIndex + 1] = null;
                    row[newColumnIndex + 2] = null;
                    row[newColumnIndex + 3] = null;
                    newColumnIndex += 4;
                } else if (!column.isCumulatable()) {
                    row[newColumnIndex] = null;
                    ++newColumnIndex;
                }
                ++n;
            }
            rows.add(row);
        }
        LogUtils.exitInternal(log, "createEmptyRow()");
        return rows;
    }

    private Iterator getCumulationKeyIterator(Map localGroupByCumulantsArrayMap) {
        return this.view.isProvidingEmptyGroupValues() ? this.view.getCumulationKeyIterator() : (this.handleGrouping() ? localGroupByCumulantsArrayMap.keySet().iterator() : Collections.singleton(AbstractCumulationAspect.NULL_GROUP_VALUE).iterator());
    }

    private long getStartTimestampForTrailingPaddingRows() {
        if (this.processedRowsCount == 0) {
            return this.startTimestamp;
        }
        return this.upperTimestamp;
    }

    private boolean isStartedInInterval(long startTimestamp) {
        return startTimestamp >= this.lowerTimestamp && startTimestamp < this.upperTimestamp;
    }

    protected class CumulantsInitializer
    implements EvaluatorInitializer {
        protected CumulantsInitializer() {
        }

        @Override
        public void initialize(Object[] groupByValues, Map evaluators) {
            CumulationAspect.this.initializeCumulants(groupByValues, evaluators);
        }
    }

    protected class DistinctEvaluatorInitializer
    implements EvaluatorInitializer {
        protected DistinctEvaluatorInitializer() {
        }

        @Override
        public void initialize(Object[] groupByValues, Map evaluators) {
            CumulationAspect.this.initializeDistinctEvaluators(groupByValues, evaluators);
        }
    }

    protected static interface EvaluatorInitializer {
        public void initialize(Object[] var1, Map var2);
    }

    protected class LazyInitializerMap
    implements Map {
        private final Map delegate;
        private final EvaluatorInitializer initializer;

        public LazyInitializerMap(Map delegate, EvaluatorInitializer initializer) {
            this.delegate = delegate;
            this.initializer = initializer;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            Object value = this.delegate.get(key);
            if (value == null) {
                this.initializer.initialize((Object[])key, this.delegate);
                return this.delegate.get(key);
            }
            return value;
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            return this.delegate.keySet();
        }

        public Object put(Object key, Object value) {
            return this.delegate.put(key, value);
        }

        public void putAll(Map t) {
            this.delegate.putAll(t);
        }

        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Map getDelegate() {
            return Collections.unmodifiableMap(this.delegate);
        }
    }
}

