/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;

public class DbAwareGroupColumn
extends GroupColumn {
    private DbColumn dbColumn;

    public DbAwareGroupColumn(View report, String name, String label, Class type) {
        super(report, name, label, type, true, null, null);
    }

    public DbColumn getDbColumn() {
        return this.dbColumn;
    }

    public void setDbColumn(DbColumn dbColumn) {
        this.dbColumn = dbColumn;
    }

    public Object getValue(ResultSet rs) throws SQLException {
        Assert.isNotNull((Object)this.dbColumn, (String)"dbColumn property must no be null");
        Class type = this.getType();
        int rsIndex = this.dbColumn.getRsIndex();
        return SqlUtils.getColumnValue(type, rs, rsIndex);
    }

    public long getLongValue(ResultSet rs) throws SQLException {
        long value = 0L;
        if (this.dbColumn != null) {
            value = this.dbColumn.getLongValue(rs);
        }
        return value;
    }

    public String getStringValue(Localizer localizer, ResultSet rs) throws SQLException {
        String value = null;
        if (this.dbColumn != null) {
            value = this.dbColumn.getStringValue(localizer, rs);
        }
        return value;
    }
}

