/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Properties;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.View;

public class EnumStructDataColumn
extends DataColumn {
    public EnumStructDataColumn(View view, String name, String label, Class type, String dataID, String modelId) {
        this(view, name, label, type, dataID);
        this.setModelId(modelId);
    }

    public EnumStructDataColumn(View view, String name, String label, Class type, String dataID) {
        super(view, name, label, type, dataID);
    }

    public EnumStructDataColumn(View view, String name, String label, Class type, Properties properties) {
        super(view, name, label, type, properties);
    }

    @Override
    public String getAttributeName() {
        return "";
    }

    @Override
    public String getAliasedColumn() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAlias());
        if (this.isNumeric() || this.isBoolean()) {
            buffer.append(".number_value");
        } else {
            buffer.append(".string_value");
        }
        return buffer.toString();
    }

    @Override
    public String getDataValueFilter(Object[] parameters) {
        StringBuffer buffer = new StringBuffer();
        String stringifiedParameterValue = parameters[this.getValueFilterParameter().getIndex() - 1].toString();
        String[] parameterParts = stringifiedParameterValue.split(",");
        int n = 0;
        while (n < parameterParts.length) {
            stringifiedParameterValue = parameterParts[n].trim();
            if (this.isNumeric() || this.isBoolean()) {
                if (stringifiedParameterValue.length() != 0) {
                    if (n == 0) {
                        buffer.append(" (");
                    } else {
                        buffer.append(" or ");
                    }
                    buffer.append(this.getAlias());
                    buffer.append(".number_value = ");
                    buffer.append(stringifiedParameterValue);
                }
            } else if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                if (n == 0) {
                    buffer.append(" (");
                } else {
                    buffer.append(" or ");
                }
                buffer.append(this.getAlias());
                buffer.append(".string_value like '");
                buffer.append(stringifiedParameterValue);
                buffer.append("'");
            }
            ++n;
        }
        if (buffer.length() > 0) {
            buffer.append(")");
        }
        return buffer.toString();
    }
}

