/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.SubColumn;
import org.eclipse.stardust.reporting.common.View;

public class GroupColumn
extends Column {
    private static Logger log = LogUtils.getLogger(GroupColumn.class);
    private boolean predefined;
    private boolean cumulatable;
    private Class type;
    private String tableVariable;
    private String columnVariable;
    private List subFields;
    private List parameters;
    private DbColumnRef dbColumnRef;

    public GroupColumn(View report, String name, String label, Class type) {
        this(report, name, label, type, true, null, null);
    }

    public GroupColumn(View report, String name, String label, Class type, String tableVariable, String queryVariable) {
        this(report, name, label, type, true, tableVariable, queryVariable);
    }

    public GroupColumn(View report, String name, String label, Class type, boolean predefined, String tableVariable, String columnVariable) {
        this(report, name, label, type, predefined, tableVariable, columnVariable, false);
    }

    public GroupColumn(View report, String name, String label, Class type, boolean predefined, String tableVariable, String columnVariable, boolean createCumulantSubFields) {
        super(report, name, label);
        this.type = type;
        this.predefined = predefined;
        this.tableVariable = tableVariable;
        this.columnVariable = columnVariable;
        this.subFields = new ArrayList();
        if (createCumulantSubFields && report.isCumulated() && this.isNumeric()) {
            this.addCumulantSubFields();
        }
        this.parameters = new ArrayList();
    }

    public GroupColumn(View report, String name, String label, Class type, boolean predefined) {
        this(report, name, label, type, predefined, false);
    }

    public GroupColumn(View report, String name, String label, Class type, boolean predefined, boolean cumulatable) {
        super(report, name, label);
        this.type = type;
        this.predefined = predefined;
        this.cumulatable = cumulatable && this.isNumeric();
        this.tableVariable = null;
        this.columnVariable = null;
        this.subFields = new ArrayList();
        if (this.cumulatable) {
            this.addCumulantSubFields();
        }
        this.parameters = new ArrayList();
    }

    public GroupColumn(View report, String name, String label, Class type, Properties properties) {
        super(report, name, label);
        this.predefined = true;
        this.type = type;
        if (log.isDebugEnabled()) {
            log.debug("Creating group field " + this.getName());
        }
        this.subFields = new ArrayList();
        if (report.isCumulated() && this.isNumeric()) {
            this.addCumulantSubFields();
        }
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    public boolean isCumulatable() {
        return this.cumulatable;
    }

    protected void setCumulatable(boolean cumulatable) {
        this.cumulatable = cumulatable;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    protected void setType(Class type) {
        this.type = type;
    }

    protected void addCumulantSubFields() {
        this.addSubField(new SubColumn(this, "Minimum", ReportingCommon_Messages.ColumnMinimum, this.getType()));
        this.addSubField(new SubColumn(this, "Maximum", ReportingCommon_Messages.ColumnMaximum, this.getType()));
        this.addSubField(new SubColumn(this, "Sum", ReportingCommon_Messages.ColumnSum, this.getType()));
        this.addSubField(new SubColumn(this, "Deviation", ReportingCommon_Messages.ColumnDeviation, this.getType()));
    }

    protected void clearCumulantSubFields() {
        this.subFields.clear();
    }

    protected void adjustViewCumulation() {
        if (this.isPredefined()) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionMethodShouldOnlyBeInvokedForUserDefinedColumns);
        }
        this.clearCumulantSubFields();
        if (this.getView().isCumulated() && this.isNumeric()) {
            this.addCumulantSubFields();
        }
    }

    @Override
    public GroupColumn getGroupColumn() {
        return this;
    }

    protected void addSubField(SubColumn subField) {
        this.subFields.add(subField);
    }

    public List getSubFields() {
        return this.subFields;
    }

    public SubColumn getSubField(String name) {
        for (SubColumn subField : this.subFields) {
            if (!subField.getName().equals(name)) continue;
            return subField;
        }
        throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.UnknownSubfieldForField, (Object)name, (Object)this.getFullName()));
    }

    public String getQueryVariable() {
        if (this.tableVariable == null && this.columnVariable == null) {
            return null;
        }
        return String.valueOf(this.tableVariable) + "." + this.columnVariable;
    }

    protected void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getXMLSpecification() {
        return "";
    }

    public boolean isNumeric() {
        if (log.isDebugEnabled()) {
            log.debug("Group column " + this.getName() + " is of type " + this.getType() + "(" + Number.class.isAssignableFrom(this.getType()) + ")");
        }
        return Number.class.isAssignableFrom(this.getType()) || Date.class.isAssignableFrom(this.getType());
    }

    public boolean isBoolean() {
        if (log.isDebugEnabled()) {
            log.debug("Group column " + this.getName() + " is of type " + this.getType() + "(" + Boolean.class.isAssignableFrom(this.getType()) + ")");
        }
        return Boolean.class.isAssignableFrom(this.getType());
    }

    public DbColumnRef getDbColumnRef() {
        return this.dbColumnRef;
    }

    public void setDbColumnRef(DbColumnRef dbColumnRef) {
        this.dbColumnRef = dbColumnRef;
    }

    public void initViewParameter() {
    }
}

