/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.common.config.Parameters;

public class LogWriter {
    private static final Map loggerMap = new HashMap();
    private final PrintStream out;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss.SSS");

    protected LogWriter(PrintStream out) {
        this.out = out;
    }

    public static synchronized LogWriter getInstance(String logFile) {
        LogWriter logger = (LogWriter)loggerMap.get(logFile);
        if (logger == null) {
            PrintStream out = null;
            String logFilePath = null;
            try {
                String loggingDirectory = Parameters.instance().getString("Logging.Directory", String.valueOf(System.getProperty("user.home")) + "/log");
                File path = new File(loggingDirectory);
                if (path.exists() || path.mkdirs()) {
                    logFilePath = String.valueOf(loggingDirectory) + "/" + logFile;
                    out = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFilePath)));
                    System.out.println("Created logfile: " + logFilePath);
                } else {
                    LogWriter.printWarning(logFilePath, null);
                }
            }
            catch (FileNotFoundException e) {
                LogWriter.printWarning(logFilePath, e);
            }
            catch (SecurityException e) {
                LogWriter.printWarning(logFilePath, e);
            }
            logger = new LogWriter(out);
            loggerMap.put(logFile, logger);
        }
        return logger;
    }

    private static void printWarning(String logFilePath, Throwable t) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("Failed creating logfile: ").append(logFilePath);
        if (t != null) {
            buffer.append(" ").append(t);
        }
        System.out.println(buffer.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }

    public boolean isActive() {
        return this.out != null;
    }

    public void log(Object scope, String logLevel, Object object, Throwable t) {
        if (this.out != null) {
            if (object == null) {
                object = t != null ? t.getMessage() : "null";
            }
            this.out.print(logLevel);
            this.out.print(" ");
            this.out.print(this.dateFormat.format(new Date()));
            this.out.print(" ");
            this.out.print(object.toString());
            this.out.print(" [");
            this.out.print(scope);
            this.out.print("]");
            this.out.println();
            if (t != null) {
                t.printStackTrace(this.out);
            }
            this.out.flush();
        }
    }
}

